/*
 * Decompiled with CFR 0.152.
 */
package beast.app.tools;

import beast.app.beauti.Beauti;
import beast.app.util.FileDrop;
import beast.app.util.Utils;
import beast.app.util.WholeNumberField;
import jam.panels.ActionPanel;
import jam.panels.OptionsPanel;
import jam.table.TableRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class LogCombinerDialog {
    private final JFrame frame;
    private final OptionsPanel optionPanel;
    JTable filesTable = null;
    private FilesTableModel filesTableModel = null;
    private final JComboBox<String> fileTypeCombo = new JComboBox<String>(new String[]{"Log Files", "Tree Files"});
    private final JCheckBox decimalCheck = new JCheckBox("Convert numbers from scientific to decimal notation");
    private final JCheckBox renumberOutput = new JCheckBox("Renumber ouput states");
    private final JCheckBox resampleCheck = new JCheckBox("Resample states at lower frequency: ");
    private final WholeNumberField resampleText = new WholeNumberField(0, Integer.MAX_VALUE);
    private final List<FileInfo> files = new ArrayList<FileInfo>();
    private final JTextField fileNameText = new JTextField("not selected", 16);
    private File outputFile = null;
    Action addFileAction = new AbstractAction("+"){
        private static final long serialVersionUID = 7602227478402204088L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File[] fileArray = Utils.getLoadFiles("Select log file", new File(Beauti.g_sDir), "Trace or tree log files", "log", "trees");
            if (fileArray != null) {
                LogCombinerDialog.this.addFiles(fileArray);
            }
        }
    };
    Action removeFileAction = new AbstractAction("-"){
        private static final long serialVersionUID = 5934278375005327047L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LogCombinerDialog.this.filesTable.getSelectedRow();
            if (n != -1) {
                LogCombinerDialog.this.files.remove(n);
            }
            LogCombinerDialog.this.filesTableModel.fireTableDataChanged();
            if (n >= LogCombinerDialog.this.files.size()) {
                n = LogCombinerDialog.this.files.size() - 1;
            }
            if (n >= 0) {
                LogCombinerDialog.this.filesTable.setRowSelectionInterval(n, n);
            }
        }
    };

    public LogCombinerDialog(JFrame jFrame, String string, Icon icon) {
        this.frame = jFrame;
        this.optionPanel = new OptionsPanel(12, 12);
        JLabel jLabel = new JLabel(string);
        jLabel.setIcon(icon);
        this.optionPanel.addSpanningComponent(jLabel);
        Font font = UIManager.getFont("Label.font");
        jLabel.setFont(new Font("sans-serif", font.getStyle(), font.getSize()));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.filesTableModel = new FilesTableModel();
        this.filesTable = new JTable(this.filesTableModel);
        this.filesTable.getColumnModel().getColumn(0).setCellRenderer(new TableRenderer(2, new Insets(0, 4, 0, 4)));
        this.filesTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.filesTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.filesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LogCombinerDialog.this.filesTableSelectionChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.filesTable, 22, 31);
        jScrollPane.setPreferredSize(new Dimension(500, 285));
        ActionPanel actionPanel = new ActionPanel(false);
        actionPanel.setAddAction(this.addFileAction);
        actionPanel.setRemoveAction(this.removeFileAction);
        this.removeFileAction.setEnabled(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(actionPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add((Component)new JLabel("Select input files:"), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)actionPanel, "South");
        Color color = UIManager.getColor("Focus.color");
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, color);
        new FileDrop(null, (Component)jScrollPane, matteBorder, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] fileArray) {
                LogCombinerDialog.this.addFiles(fileArray);
            }
        });
        this.resampleText.setEnabled(false);
        this.resampleText.setColumns(12);
        this.resampleCheck.addActionListener(actionEvent -> this.resampleText.setEnabled(this.resampleCheck.isSelected()));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = Utils.getSaveFile("Select output file...", new File(Beauti.g_sDir), "Beast log and tree files", "log", "trees");
                if (file == null) {
                    return;
                }
                LogCombinerDialog.this.outputFile = file;
                String string = file.getAbsolutePath();
                String string2 = System.getProperty("file.separator");
                if (string2.equals("\\")) {
                    string2 = "\\\\";
                }
                if (string.lastIndexOf(string2) > 0) {
                    Beauti.g_sDir = string.substring(0, string.lastIndexOf(string2));
                }
                LogCombinerDialog.this.fileNameText.setText(LogCombinerDialog.this.outputFile.getName());
            }
        };
        JButton jButton = new JButton("Choose File...");
        jButton.addActionListener(actionListener);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)this.resampleCheck, "Center");
        jPanel3.add((Component)this.resampleText, "East");
        this.optionPanel.addComponentWithLabel("File type: ", this.fileTypeCombo);
        this.optionPanel.addComponent(this.decimalCheck);
        this.optionPanel.addComponent(this.renumberOutput);
        this.optionPanel.addComponent(jPanel3);
        this.optionPanel.addSpanningComponent(jPanel);
        this.fileNameText.setEditable(false);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add((Component)this.fileNameText, "Center");
        jPanel4.add((Component)jButton, "East");
        this.optionPanel.addComponentWithLabel("Output File: ", jPanel4);
    }

    public boolean showDialog(String string) {
        this.addFileAction.setEnabled(true);
        this.removeFileAction.setEnabled(false);
        this.filesTableModel.fireTableDataChanged();
        JOptionPane jOptionPane = new JOptionPane(this.optionPanel, -1, 2, null, new String[]{"Run", "Quit"}, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JDialog jDialog = jOptionPane.createDialog(this.frame, string);
        jDialog.pack();
        jDialog.setVisible(true);
        return jOptionPane.getValue().equals("Run");
    }

    public String[] getFileNames() {
        String[] stringArray = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            FileInfo fileInfo = this.files.get(i);
            stringArray[i] = fileInfo.file.getPath();
        }
        return stringArray;
    }

    public int[] getBurnins() {
        int[] nArray = new int[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            FileInfo fileInfo = this.files.get(i);
            nArray[i] = fileInfo.burnin;
        }
        return nArray;
    }

    public boolean isTreeFiles() {
        return this.fileTypeCombo.getSelectedIndex() == 1;
    }

    public boolean convertToDecimal() {
        return this.decimalCheck.isSelected();
    }

    public boolean renumberOutputStates() {
        return this.renumberOutput.isSelected();
    }

    public boolean isResampling() {
        return this.resampleCheck.isSelected();
    }

    public int getResampleFrequency() {
        return this.resampleText.getValue();
    }

    public String getOutputFileName() {
        if (this.outputFile == null) {
            return null;
        }
        return this.outputFile.getPath();
    }

    private void filesTableSelectionChanged() {
        if (this.filesTable.getSelectedRowCount() == 0) {
            this.removeFileAction.setEnabled(false);
        } else {
            this.removeFileAction.setEnabled(true);
        }
    }

    private void addFiles(File[] fileArray) {
        int n = this.files.size();
        for (File file : fileArray) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.file = file;
            fileInfo.burnin = 0;
            this.files.add(fileInfo);
            String string = file.getAbsolutePath();
            String string2 = System.getProperty("file.separator");
            if (string2.equals("\\")) {
                string2 = "\\\\";
            }
            if (string.lastIndexOf(string2) <= 0) continue;
            Beauti.g_sDir = string.substring(0, string.lastIndexOf(string2));
        }
        this.filesTableModel.fireTableDataChanged();
        int n2 = this.files.size() - 1;
        this.filesTable.setRowSelectionInterval(n, n2);
    }

    class FileInfo {
        File file;
        Integer burnin;

        FileInfo() {
        }
    }

    class FilesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4153326364833213013L;
        private final String[] columns = new String[]{"File", "Burnin (percentage)"};

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return LogCombinerDialog.this.files.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FileInfo fileInfo = (FileInfo)LogCombinerDialog.this.files.get(n);
            if (n2 == 0) {
                return fileInfo.file.getName();
            }
            return fileInfo.burnin;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FileInfo fileInfo = (FileInfo)LogCombinerDialog.this.files.get(n);
            if (n2 == 1) {
                int n3 = (Integer)object;
                if (n3 < 0 || n3 > 100) {
                    JOptionPane.showMessageDialog(LogCombinerDialog.this.frame, "Burn-in percentage must be between 0 and 100.", "Error", 0);
                } else {
                    fileInfo.burnin = n3;
                }
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

