/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.Document;
import beast.app.draw.TrackPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public abstract class Shape {
    int m_x = 0;
    int m_y = 0;
    int m_w = 1;
    int m_h = 1;
    int m_nPenWidth = 1;
    boolean m_bFilled = true;
    Color m_fillcolor = DEFUALT_FILL_COLOR;
    Color m_pencolor = DEFUALT_PEN_COLOR;
    public boolean m_bNeedsDrawing = true;
    static final Color DEFUALT_FILL_COLOR = new Color(128, 128, 128);
    static final Color DEFUALT_PEN_COLOR = new Color(0, 0, 0);
    String m_sID;
    Document m_doc;

    String getID() {
        return this.m_sID;
    }

    public Shape() {
    }

    public Shape(Node node, Document document) {
        this.m_doc = document;
    }

    public void draw(Graphics2D graphics2D, JPanel jPanel) {
    }

    void drawLabel(Graphics2D graphics2D) {
        if (this.getLabel() != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
            String string = this.getLabel();
            if (this.m_doc != null && this.m_doc.sanitiseIDs() && string.contains(".")) {
                string = string.substring(0, string.indexOf(46));
            }
            int n = 0;
            while (string.indexOf(10) >= 0) {
                String string2 = string.substring(0, string.indexOf(10));
                graphics2D.drawString(string2, this.m_x + this.m_w / 2 - fontMetrics.stringWidth(string2) / 2, this.m_y + this.m_h / 2 + n * fontMetrics.getHeight());
                string = string.substring(string2.length() + 1);
                ++n;
            }
            graphics2D.drawString(string, this.m_x + this.m_w / 2 - fontMetrics.stringWidth(string) / 2, this.m_y + this.m_h / 2 + n * fontMetrics.getHeight());
        }
    }

    List<TrackPoint> getTracker() {
        ArrayList<TrackPoint> arrayList = new ArrayList<TrackPoint>(8);
        arrayList.add(new TrackPoint(this.m_x, this.m_y, 6));
        arrayList.add(new TrackPoint(this.m_x + this.m_w, this.m_y, 7));
        arrayList.add(new TrackPoint(this.m_x, this.m_y + this.m_h, 4));
        arrayList.add(new TrackPoint(this.m_x + this.m_w, this.m_y + this.m_h, 5));
        arrayList.add(new TrackPoint(this.m_x, this.m_y + this.m_h / 2, 10));
        arrayList.add(new TrackPoint(this.m_x + this.m_w, this.m_y + this.m_h / 2, 11));
        arrayList.add(new TrackPoint(this.m_x + this.m_w / 2, this.m_y, 8));
        arrayList.add(new TrackPoint(this.m_x + this.m_w / 2, this.m_y + this.m_h, 9));
        return arrayList;
    }

    void parse(Node node, Document document, boolean bl) {
        if (node.getAttributes().getNamedItem("id") != null) {
            this.m_sID = node.getAttributes().getNamedItem("id").getNodeValue();
        }
        if (node.getAttributes().getNamedItem("x") != null) {
            this.m_x = new Integer(node.getAttributes().getNamedItem("x").getNodeValue());
            this.m_x += 400;
        }
        if (node.getAttributes().getNamedItem("y") != null) {
            this.m_y = new Integer(node.getAttributes().getNamedItem("y").getNodeValue());
            if (node.getAttributes().getNamedItem("h") != null) {
                this.m_h = new Integer(node.getAttributes().getNamedItem("h").getNodeValue());
            }
            this.m_y = 550 - this.m_y - this.m_h;
        }
        if (node.getAttributes().getNamedItem("w") != null) {
            this.m_w = new Integer(node.getAttributes().getNamedItem("w").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("penwidth") != null) {
            this.m_nPenWidth = new Integer(node.getAttributes().getNamedItem("penwidth").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("fillcolor") != null) {
            this.m_fillcolor = this.string2Color(node.getAttributes().getNamedItem("fillcolor").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("pencolor") != null) {
            this.m_pencolor = this.string2Color(node.getAttributes().getNamedItem("pencolor").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("filled") != null) {
            this.m_bFilled = !node.getAttributes().getNamedItem("filled").getNodeValue().equals("no");
        }
    }

    String XMLnormalizeAtt(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\r': {
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("&#xD;&#xA;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    String getAtts() {
        return " id='" + this.getID() + "'" + " x='" + (this.m_x - 400) + "'" + " y='" + (550 - this.m_y - this.m_h) + "'" + " w='" + this.m_w + "'" + " h='" + this.m_h + "'" + (this.m_nPenWidth != 1 ? " penwidth='" + this.m_nPenWidth + "'" : "") + (!this.m_bFilled ? " filled='no'" : "") + (this.m_fillcolor.equals(DEFUALT_FILL_COLOR) ? "" : " fillcolor='" + this.m_fillcolor.getRed() + " " + this.m_fillcolor.getGreen() + " " + this.m_fillcolor.getBlue() + "'") + (this.m_pencolor.equals(DEFUALT_PEN_COLOR) ? "" : " pencolor='" + this.m_pencolor.getRed() + " " + this.m_pencolor.getGreen() + " " + this.m_pencolor.getBlue() + "'");
    }

    void assignFrom(Shape shape) {
        this.m_x = shape.m_x;
        this.m_y = shape.m_y;
        this.m_w = shape.m_w;
        this.m_h = shape.m_h;
        this.m_nPenWidth = shape.m_nPenWidth;
        this.m_bFilled = shape.m_bFilled;
        this.m_fillcolor = shape.m_fillcolor;
        this.m_pencolor = shape.m_pencolor;
    }

    Color string2Color(String string) {
        int n = string.indexOf(32);
        if (n < 0) {
            return new Color(128, 128, 128);
        }
        int n2 = 0;
        String string2 = string.substring(n2, n);
        int n3 = new Integer(string2);
        n2 = n + 1;
        if ((n = string.indexOf(32, n2)) < 0) {
            return new Color(128, 128, 128);
        }
        String string3 = string.substring(n2, n);
        int n4 = new Integer(string3);
        n2 = n + 1;
        if ((n = string.indexOf(32, n2)) < 0) {
            n = string.length();
        }
        String string4 = string.substring(n2, n);
        int n5 = new Integer(string4);
        return new Color(n3, n4, n5);
    }

    public String getXML() {
        return "<shape" + this.getAtts() + "/>";
    }

    boolean intersects(int n, int n2) {
        return n >= this.m_x - 1 && n <= this.m_x + this.m_w + 1 && n2 >= this.m_y - 1 && n2 <= this.m_y + this.m_h + 1;
    }

    boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.m_x - 1, this.m_y - 1, this.m_w + 2, this.m_h + 2);
    }

    int offsetX(int n) {
        return n - this.m_x;
    }

    int offsetY(int n) {
        return n - this.m_y;
    }

    void offset(int n, int n2) {
        this.m_x += n;
        this.m_y += n2;
    }

    void movePosition(int n, int n2, int n3, int n4) {
        this.m_x = n3 - n;
        this.m_y = n4 - n2;
    }

    void movePoint(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                this.m_w = this.m_w + this.m_x - n4 + n2;
                this.m_x = n4 - n2;
                this.m_h = this.m_h + this.m_y - n5 + n3;
                this.m_y = n5 - n3;
                break;
            }
            case 1: {
                this.m_w = n4 - n2 - this.m_x;
                this.m_h = this.m_h + this.m_y - n5 + n3;
                this.m_y = n5 - n3;
                break;
            }
            case 2: {
                this.m_w = this.m_w + this.m_x - n4 + n2;
                this.m_x = n4 - n2;
                this.m_h = n5 - n3 - this.m_y;
                break;
            }
            case 3: {
                this.m_w = n4 - n2 - this.m_x;
                this.m_h = n5 - n3 - this.m_y;
                break;
            }
            case 5: {
                this.m_w = n4 - n2 - this.m_x;
                break;
            }
            case 4: {
                this.m_w = this.m_w + this.m_x - n4 + n2;
                this.m_x = n4 - n2;
                break;
            }
            case 7: {
                this.m_h = n5 - n3 - this.m_y;
                break;
            }
            case 6: {
                this.m_h = this.m_h + this.m_y - n5 + n3;
                this.m_y = n5 - n3;
            }
        }
    }

    void normalize() {
        int n = this.m_x;
        int n2 = this.m_x + this.m_w;
        int n3 = this.m_y;
        int n4 = this.m_y + this.m_h;
        this.m_x = Math.min(n, n2);
        this.m_w = Math.max(n, n2) - this.m_x;
        this.m_y = Math.min(n3, n4);
        this.m_h = Math.max(n3, n4) - this.m_y;
    }

    public Color getFillColor() {
        return this.m_fillcolor;
    }

    void setFillColor(Color color) {
        this.m_fillcolor = color;
    }

    Color getPenColor() {
        return this.m_pencolor;
    }

    void setPenColor(Color color) {
        this.m_pencolor = color;
    }

    int getX() {
        return this.m_x;
    }

    int getY() {
        return this.m_y;
    }

    int getX2() {
        return this.m_x + this.m_w;
    }

    int getY2() {
        return this.m_y + this.m_h;
    }

    void setX(int n) {
        this.m_x = n;
    }

    void setY(int n) {
        this.m_y = n;
    }

    void setX2(int n) {
        this.m_w = n - this.m_x;
    }

    void setY2(int n) {
        this.m_h = n - this.m_y;
    }

    String getLabel() {
        return "";
    }

    boolean isFilled() {
        return this.m_bFilled;
    }

    void toggleFilled() {
        this.m_bFilled = !this.m_bFilled;
    }

    int getPenWidth() {
        return this.m_nPenWidth;
    }

    void setPenWidth(int n) {
        this.m_nPenWidth = n;
    }

    abstract void toSVG(PrintStream var1);

    void drawSVGString(PrintStream printStream, Font font, Color color, String string) {
        if (this.getLabel() != null) {
            String string2 = this.getLabel();
            while (string2.indexOf(10) >= 0) {
                String string3 = string2.substring(0, string2.indexOf(10));
                printStream.println("<text x='" + (this.m_x + this.m_w / 2) + "' y='" + (this.m_y + this.m_h / 2) + "' font-family='" + font.getFamily() + "' " + "font-size='" + font.getSize() + "pt' " + "font-style='" + (font.isBold() ? "oblique" : "") + (font.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")' text-anchor='" + string + "'>" + string3 + "</text>\n");
                string2 = string2.substring(string3.length() + 1);
            }
            printStream.println("<text x='" + (this.m_x + this.m_w / 2) + "' y='" + (this.m_y + this.m_h / 2) + "' font-family='" + font.getFamily() + "' " + "font-size='" + font.getSize() + "pt' " + "font-style='" + (font.isBold() ? "oblique" : "") + (font.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")' " + "text-anchor='" + string + "'>" + string2 + "</text>\n");
        }
    }
}

