/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.Arrow;
import beast.app.draw.BEASTObjectDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.BEASTObjectShape;
import beast.app.draw.Document;
import beast.app.draw.ExtensionFileFilter;
import beast.app.draw.InputShape;
import beast.app.draw.MyAction;
import beast.app.draw.Selection;
import beast.app.draw.Shape;
import beast.app.draw.TrackPoint;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.Logger;
import beast.core.Operator;
import beast.core.State;
import beast.evolution.alignment.Sequence;
import beast.util.AddOnManager;
import beast.util.Randomizer;
import beast.util.XMLProducer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class ModelBuilder
extends JPanel
implements ComponentListener {
    static final long serialVersionUID = 1L;
    public static final String FILE_EXT = ".xml";
    public static final String ICONPATH = "beast/app/draw/icons/";
    JScrollPane m_jScrollPane;
    public DrawPanel g_panel;
    static final int MODE_SELECT = 0;
    static final int MODE_MOVE = 1;
    static final int MODE_ARROW = 7;
    static final int MODE_FUNCTION = 9;
    Shape m_drawShape = null;
    Rectangle m_selectRect = null;
    int m_nMode = 0;
    boolean m_bViewOperators = true;
    boolean m_bViewLoggers = true;
    boolean m_bViewSequences = true;
    boolean m_bViewState = true;
    boolean m_bRelax = false;
    boolean m_bIsEditable = true;
    int m_nRelaxSeconds = 10;
    JCheckBoxMenuItem m_viewRelax;
    Action a_new = new ActionNew();
    Action a_load = new ActionLoad();
    Action a_save = new ActionSave();
    Action a_saveas = new ActionSaveAs();
    ActionExport a_export = new ActionExport();
    ActionPrint a_print = new ActionPrint();
    Action a_quit = new ActionQuit();
    Action a_undo = new ActionUndo();
    Action a_redo = new ActionRedo();
    Action a_selectall = new ActionSelectAll();
    Action a_delnode = new ActionDeleteNode();
    Action a_cutnode = new ActionCutNode();
    Action a_copynode = new ActionCopyNode();
    Action a_pastenode = new ActionPasteNode();
    Action a_group = new ActionCollapse();
    Action a_select = new ActionSelect();
    Action a_arrow = new ActionArrow();
    Action a_function = new ActionFunction();
    Action a_fillcolor = new ActionFillColor();
    Action a_pencolor = new ActionPenColor();
    Action a_tofront = new ActionToFront();
    Action a_forward = new ActionForward();
    Action a_toback = new ActionToBack();
    Action a_backward = new ActionBackward();
    Action a_alignleft = new ActionAlignLeft();
    Action a_alignright = new ActionAlignRight();
    Action a_aligntop = new ActionAlignTop();
    Action a_alignbottom = new ActionAlignBottom();
    Action a_centerhorizontal = new ActionCenterHorizontal();
    Action a_centervertical = new ActionCenterVertical();
    Action a_spacehorizontal = new ActionSpaceHorizontal();
    Action a_spacevertical = new ActionSpaceVertical();
    Action a_about = new ActionAbout();
    Action a_relax = new ActionRelax();
    Action a_viewOperators = new ActionViewOperators();
    Action a_viewLoggers = new ActionViewLoggers();
    Action a_viewSequences = new ActionViewSequences();
    Action a_layout = new ActionLayout();
    ClipBoard m_clipboard = new ClipBoard();
    String m_sFileName = "";
    public Document m_doc = new Document();
    String m_sDir = System.getProperty("user.dir");
    Selection m_Selection = new Selection();
    ExtensionFileFilter ef1 = new ExtensionFileFilter(".xml", "BEAST files");
    ExtensionFileFilter ef2 = new ExtensionFileFilter(".gif", "GIF images");
    ExtensionFileFilter ef3 = new ExtensionFileFilter(".jpg", "JPG images");
    ExtensionFileFilter ef4 = new ExtensionFileFilter(".bmp", "BMP images");
    ExtensionFileFilter ef5 = new ExtensionFileFilter(".png", "PNG images");
    public JToolBar m_jTbTools;
    public JToolBar m_jTbTools2;

    public void setEditable(boolean bl) {
        this.m_bIsEditable = bl;
    }

    boolean validateModel() {
        int n = this.m_doc.isValidModel();
        if (n == 0) {
            return true;
        }
        String string = "<html>Document is not valid: ";
        switch (n) {
            case 1: {
                string = string + "there is a cycle in the model.";
                break;
            }
            case 3: {
                string = string + "The model is empty, there is nothing to save.";
                break;
            }
            case 2: {
                string = string + "there is no top level runnable item in the model (e.g. an MCMC node).";
                break;
            }
            case 4: {
                string = string + "there are orphaned items in the model (i.e. beastObjects that have no parents).";
            }
        }
        string = string + "<br>Do you still want to try to save the model?</html>";
        return JOptionPane.showConfirmDialog(this, string, "Model not valid", 0) == 0;
    }

    void updateStatus() {
        this.a_undo.setEnabled(this.m_doc.canUndo());
        this.a_redo.setEnabled(this.m_doc.canRedo());
        int n = this.m_Selection.m_Selection.size();
        boolean bl = n > 0;
        boolean bl2 = n > 1;
        this.a_delnode.setEnabled(bl);
        this.a_copynode.setEnabled(bl);
        this.a_cutnode.setEnabled(bl);
        this.a_pastenode.setEnabled(this.m_clipboard.hasText());
        this.a_fillcolor.setEnabled(bl);
        this.a_pencolor.setEnabled(bl);
        this.a_forward.setEnabled(bl);
        this.a_backward.setEnabled(bl);
        this.a_tofront.setEnabled(bl);
        this.a_toback.setEnabled(bl);
        this.a_group.setEnabled(bl);
        this.a_alignbottom.setEnabled(bl2);
        this.a_aligntop.setEnabled(bl2);
        this.a_alignleft.setEnabled(bl2);
        this.a_alignright.setEnabled(bl2);
        this.a_spacehorizontal.setEnabled(bl2);
        this.a_spacevertical.setEnabled(bl2);
        this.a_centerhorizontal.setEnabled(bl2);
        this.a_centervertical.setEnabled(bl2);
        this.g_panel.repaint();
    }

    public void init() {
        this.m_Selection.setDocument(this.m_doc);
        int n = UIManager.getFont("Label.font").getSize();
        this.setSize(2048 * n / 13, 2048 * n / 13);
        this.g_panel = new DrawPanel();
        this.m_jScrollPane = new JScrollPane(this.g_panel);
        this.makeToolbar();
        this.makeMenuBar();
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jScrollPane, "Center");
        this.g_panel.setPreferredSize(this.getSize());
    }

    void makeToolbar() {
        this.m_jTbTools = new JToolBar();
        this.m_jTbTools.setFloatable(false);
        this.m_jTbTools.add(this.a_new);
        this.m_jTbTools.add(this.a_save);
        this.m_jTbTools.add(this.a_load);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_cutnode);
        this.m_jTbTools.add(this.a_copynode);
        this.m_jTbTools.add(this.a_pastenode);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_undo);
        this.m_jTbTools.add(this.a_redo);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_select);
        this.m_jTbTools.add(this.a_function);
        this.m_jTbTools.add(this.a_arrow);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_alignleft);
        this.m_jTbTools.add(this.a_alignright);
        this.m_jTbTools.add(this.a_aligntop);
        this.m_jTbTools.add(this.a_alignbottom);
        this.m_jTbTools.add(this.a_centerhorizontal);
        this.m_jTbTools.add(this.a_centervertical);
        this.m_jTbTools.add(this.a_spacehorizontal);
        this.m_jTbTools.add(this.a_spacevertical);
        this.setLayout(new BorderLayout());
        this.m_jTbTools2 = new JToolBar();
        this.m_jTbTools2.setFloatable(false);
        this.m_jTbTools2.add(this.a_relax);
        this.m_jTbTools2.add(this.a_viewLoggers);
        this.m_jTbTools2.add(this.a_viewOperators);
        this.m_jTbTools2.add(this.a_viewSequences);
        this.m_jTbTools2.add(this.a_layout);
    }

    boolean needsDrawing(BEASTInterface bEASTInterface) {
        if (bEASTInterface == null) {
            return true;
        }
        if (!this.m_bViewOperators && bEASTInterface instanceof Operator) {
            return false;
        }
        if (!this.m_bViewLoggers && bEASTInterface instanceof Logger) {
            return false;
        }
        if (!this.m_bViewSequences && bEASTInterface instanceof Sequence) {
            return false;
        }
        return this.m_bViewState || !(bEASTInterface instanceof State);
    }

    public void setDrawingFlag() {
        for (int i = 0; i < this.m_doc.m_objects.size(); ++i) {
            Object object;
            Shape shape = this.m_doc.m_objects.get(i);
            shape.m_bNeedsDrawing = false;
            if (shape.m_bNeedsDrawing) {
                shape.m_bNeedsDrawing = true;
            }
            if (shape instanceof BEASTObjectShape) {
                object = ((BEASTObjectShape)shape).m_beastObject;
                if (!this.needsDrawing((BEASTInterface)object)) continue;
                shape.m_bNeedsDrawing = true;
                continue;
            }
            if (shape instanceof InputShape) {
                object = ((InputShape)shape).m_beastObjectShape;
                if (object != null) {
                    if (!this.needsDrawing(((BEASTObjectShape)object).m_beastObject)) continue;
                    shape.m_bNeedsDrawing = true;
                    continue;
                }
                shape.m_bNeedsDrawing = true;
                continue;
            }
            if (shape instanceof Arrow) {
                BEASTObjectShape bEASTObjectShape;
                object = ((Arrow)shape).m_tailShape;
                boolean bl = true;
                if (object instanceof BEASTObjectShape) {
                    bl = this.needsDrawing(((BEASTObjectShape)object).m_beastObject);
                }
                if (!bl) continue;
                InputShape inputShape = ((Arrow)shape).m_headShape;
                if (inputShape instanceof InputShape && (bEASTObjectShape = inputShape.m_beastObjectShape) != null) {
                    bl = this.needsDrawing(bEASTObjectShape.m_beastObject);
                }
                if (!bl) continue;
                shape.m_bNeedsDrawing = true;
                continue;
            }
            shape.m_bNeedsDrawing = true;
        }
    }

    public JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        jMenu.add(this.a_new);
        jMenu.add(this.a_load);
        jMenu.add(this.a_save);
        jMenu.add(this.a_saveas);
        jMenu.addSeparator();
        jMenu.add(this.a_export);
        jMenu.add(this.a_print);
        jMenu.addSeparator();
        jMenu.add(this.a_quit);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        jMenuBar.add(jMenu2);
        jMenu2.add(this.a_undo);
        jMenu2.add(this.a_redo);
        jMenu2.addSeparator();
        jMenu2.add(this.a_selectall);
        jMenu2.add(this.a_delnode);
        jMenu2.add(this.a_cutnode);
        jMenu2.add(this.a_copynode);
        jMenu2.add(this.a_pastenode);
        jMenu2.addSeparator();
        jMenu2.add(this.a_alignleft);
        jMenu2.add(this.a_alignright);
        jMenu2.add(this.a_aligntop);
        jMenu2.add(this.a_alignbottom);
        jMenu2.add(this.a_centerhorizontal);
        jMenu2.add(this.a_centervertical);
        jMenu2.add(this.a_spacehorizontal);
        jMenu2.add(this.a_spacevertical);
        jMenu2.addSeparator();
        jMenu2.add(this.a_group);
        jMenu2.addSeparator();
        JMenu jMenu3 = new JMenu("Draw");
        jMenu3.setMnemonic('D');
        jMenuBar.add(jMenu3);
        jMenu3.add(this.a_select);
        jMenu3.add(this.a_function);
        jMenu3.add(this.a_arrow);
        JMenu jMenu4 = new JMenu("Object");
        jMenu4.setMnemonic('O');
        jMenuBar.add(jMenu4);
        jMenu4.add(this.a_fillcolor);
        jMenu4.add(this.a_pencolor);
        jMenu4.addSeparator();
        jMenu4.add(this.a_tofront);
        jMenu4.add(this.a_forward);
        jMenu4.add(this.a_toback);
        jMenu4.add(this.a_backward);
        JMenu jMenu5 = new JMenu("View");
        jMenu5.setMnemonic('V');
        jMenuBar.add(jMenu5);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Operators", this.m_bViewOperators);
        jCheckBoxMenuItem.addActionListener(actionEvent -> {
            this.m_bViewOperators = jCheckBoxMenuItem.getState();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Show Loggers", this.m_bViewLoggers);
        jCheckBoxMenuItem2.addActionListener(actionEvent -> {
            this.m_bViewLoggers = jCheckBoxMenuItem2.getState();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem2);
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Show Sequences", this.m_bViewSequences);
        jCheckBoxMenuItem3.addActionListener(actionEvent -> {
            this.m_bViewSequences = jCheckBoxMenuItem3.getState();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem3);
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Show State", this.m_bViewState);
        jCheckBoxMenuItem4.addActionListener(actionEvent -> {
            this.m_bViewState = jCheckBoxMenuItem4.getState();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem4);
        this.m_viewRelax = new JCheckBoxMenuItem("Relax", this.m_bRelax);
        this.m_viewRelax.addActionListener(actionEvent -> {
            this.m_bRelax = this.m_viewRelax.getState();
            this.g_panel.repaint();
        });
        jMenu5.add(this.m_viewRelax);
        JMenuItem jMenuItem = new JMenuItem("Layout Visible Items");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener(actionEvent -> {
            this.g_panel.setCursor(new Cursor(3));
            this.m_doc.layout();
            this.m_doc.adjustArrows();
            this.repaint();
            this.g_panel.setCursor(new Cursor(0));
        });
        jMenu5.add(jMenuItem);
        jMenu5.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("Show All Inputs", this.m_doc.m_bShowALlInputs);
        jCheckBoxMenuItem5.addActionListener(actionEvent -> {
            this.m_doc.m_bShowALlInputs = jCheckBoxMenuItem5.getState();
            this.m_doc.reinit();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem5);
        JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("Sanitise IDs", this.m_doc.m_bSanitiseIDs);
        jCheckBoxMenuItem6.addActionListener(actionEvent -> {
            this.m_doc.m_bSanitiseIDs = jCheckBoxMenuItem6.getState();
            this.setDrawingFlag();
            this.g_panel.repaint();
        });
        jMenu5.add(jCheckBoxMenuItem6);
        JMenu jMenu6 = new JMenu("Help");
        jMenu6.setMnemonic('H');
        jMenuBar.add(jMenu6);
        jMenu6.add(this.a_about);
        return jMenuBar;
    }

    public static void main(String[] stringArray) {
        Randomizer.setSeed(127L);
        try {
            AddOnManager.loadExternalJars();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Model Builder");
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.init();
        JMenuBar jMenuBar = modelBuilder.makeMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        jFrame.add((Component)modelBuilder.m_jTbTools, "North");
        jFrame.add((Component)modelBuilder, "Center");
        jFrame.setDefaultCloseOperation(3);
        URL uRL = ClassLoader.getSystemResource("beast/app/draw/icons//GenerationD.png");
        try {
            jFrame.setIconImage(ImageIO.read(uRL));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length > 0) {
            modelBuilder.m_doc.loadFile(stringArray[0]);
            modelBuilder.setDrawingFlag();
        }
        int n = UIManager.getFont("Label.font").getSize();
        jFrame.setSize(800 * n / 13, 600 * n / 13);
        jFrame.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.m_jScrollPane.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.m_jScrollPane.revalidate();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.m_jScrollPane.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.m_jScrollPane.revalidate();
    }

    class DrawPanel
    extends JPanel
    implements Printable {
        static final long serialVersionUID = 1L;
        int m_nPosX = 0;
        int m_nPosY = 0;
        int m_nPoint;
        boolean m_bIsMoving = false;

        public DrawPanel() {
            this.setBackground(Color.white);
            this.addMouseMotionListener(new GBDrawMouseMotionListener());
            this.addMouseListener(new GBDrawMouseEventListener());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setBackground(Color.WHITE);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ModelBuilder.this.m_doc.adjustInputs();
            for (n = 0; n < ModelBuilder.this.m_doc.m_objects.size(); ++n) {
                object = ModelBuilder.this.m_doc.m_objects.get(n);
                if (!((Shape)object).m_bNeedsDrawing) continue;
                ((Shape)object).draw(graphics2D, this);
            }
            if (!ModelBuilder.this.a_export.isExporting() && !ModelBuilder.this.a_print.isPrinting()) {
                if (ModelBuilder.this.m_drawShape != null) {
                    ModelBuilder.this.m_drawShape.draw(graphics2D, this);
                }
                if (ModelBuilder.this.m_Selection.m_tracker != null) {
                    graphics2D.setColor(Color.BLACK);
                    for (n = 0; n < ModelBuilder.this.m_Selection.m_tracker.size(); ++n) {
                        object = ModelBuilder.this.m_Selection.m_tracker.get(n);
                        graphics2D.fillRect(((TrackPoint)object).m_nX - 4, ((TrackPoint)object).m_nY - 4, 8, 8);
                    }
                }
                if (ModelBuilder.this.m_selectRect != null) {
                    graphics2D.setXORMode(Color.green);
                    graphics2D.draw(ModelBuilder.this.m_selectRect);
                }
            }
            if (ModelBuilder.this.m_bRelax) {
                ModelBuilder.this.m_doc.relax(true);
                this.repaint();
            }
            ModelBuilder.this.m_jScrollPane.revalidate();
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n > 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.paint(graphics2D);
            return 0;
        }

        class GBDrawMouseEventListener
        extends MouseAdapter {
            GBDrawMouseEventListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.handleDoubleClick(mouseEvent);
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    this.handleRightClick(mouseEvent);
                    return;
                }
                switch (ModelBuilder.this.m_nMode) {
                    case 0: {
                        Shape shape;
                        int n;
                        int n2 = -1;
                        for (n = ModelBuilder.this.m_doc.m_objects.size() - 1; n2 < 0 && n >= 0; --n) {
                            shape = ModelBuilder.this.m_doc.m_objects.get(n);
                            if (!shape.m_bNeedsDrawing || shape instanceof Arrow || !shape.intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                            DrawPanel.this.m_nPosX = shape.offsetX(mouseEvent.getX());
                            DrawPanel.this.m_nPosY = shape.offsetY(mouseEvent.getY());
                            n2 = n;
                        }
                        if (n2 < 0) {
                            for (n = ModelBuilder.this.m_doc.m_objects.size() - 1; n2 < 0 && n >= 0; --n) {
                                shape = ModelBuilder.this.m_doc.m_objects.get(n);
                                if (!shape.m_bNeedsDrawing || !shape.intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                                DrawPanel.this.m_nPosX = shape.offsetX(mouseEvent.getX());
                                DrawPanel.this.m_nPosY = shape.offsetY(mouseEvent.getY());
                                n2 = n;
                            }
                            if (n2 < 0) {
                                return;
                            }
                        }
                        if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                            ModelBuilder.this.m_Selection.toggleSelection(n2);
                        } else if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                            ModelBuilder.this.m_Selection.addToSelection(n2);
                        } else {
                            ModelBuilder.this.m_Selection.clear();
                            ModelBuilder.this.m_Selection.setSingleSelection(n2);
                        }
                        ModelBuilder.this.updateStatus();
                    }
                }
            }

            void handleDoubleClick(MouseEvent mouseEvent) {
                try {
                    for (int i = ModelBuilder.this.m_doc.m_objects.size() - 1; i >= 0; --i) {
                        Shape shape = ModelBuilder.this.m_doc.m_objects.get(i);
                        if (!shape.m_bNeedsDrawing || !shape.intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                        if (shape instanceof InputShape) {
                            InputShape inputShape = (InputShape)shape;
                            String string = inputShape.getInputName();
                            BEASTInterface bEASTInterface = inputShape.getBEASTObject();
                            if (bEASTInterface.isPrimitive(string)) {
                                String string2 = "";
                                if (bEASTInterface.getInputValue(string) != null) {
                                    string2 = bEASTInterface.getInputValue(string).toString();
                                }
                                if ((string2 = JOptionPane.showInputDialog(string + ":", (Object)string2)) != null) {
                                    ModelBuilder.this.m_doc.setInputValue(inputShape.getPluginShape(), string, string2);
                                    ModelBuilder.this.g_panel.repaint();
                                }
                            }
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            void handleRightClick(MouseEvent mouseEvent) {
                Object object;
                Object object2;
                if (!ModelBuilder.this.m_bIsEditable) {
                    return;
                }
                JPopupMenu jPopupMenu = new JPopupMenu("Choose a value");
                if (!ModelBuilder.this.m_Selection.hasSelection()) {
                    int n = -1;
                    for (int i = 0; n < 0 && i < ModelBuilder.this.m_doc.m_objects.size(); ++i) {
                        object2 = ModelBuilder.this.m_doc.m_objects.get(i);
                        if (!((Shape)object2).m_bNeedsDrawing || !((Shape)object2).intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                        DrawPanel.this.m_nPosX = ((Shape)object2).offsetX(mouseEvent.getX());
                        DrawPanel.this.m_nPosY = ((Shape)object2).offsetY(mouseEvent.getY());
                        ModelBuilder.this.m_Selection.addToSelection(i);
                        break;
                    }
                }
                JMenuItem jMenuItem = new JMenuItem("Change label");
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Shape shape = ModelBuilder.this.m_Selection.getSingleSelectionShape();
                        String string = (String)JOptionPane.showInputDialog(null, shape.getID(), "New label", 2, null, null, shape.getID());
                        if (string == null || string.equals("")) {
                            return;
                        }
                        while (string.contains("\\n")) {
                            int n = string.indexOf("\\n");
                            string = string.substring(0, n - 1) + '\n' + string.substring(n + 2);
                        }
                        ModelBuilder.this.m_doc.setID(string, ModelBuilder.this.m_Selection.getSingleSelection());
                        DrawPanel.this.repaint();
                    }
                };
                jMenuItem.addActionListener(actionListener);
                jMenuItem.setEnabled(ModelBuilder.this.m_Selection.isSingleSelection());
                jPopupMenu.add(jMenuItem);
                object2 = new JMenuItem("Fill object");
                if (ModelBuilder.this.m_Selection.isSingleSelection() && ((Shape)(object = ModelBuilder.this.m_Selection.getSingleSelectionShape())).isFilled()) {
                    object2 = new JMenuItem("Don't fill object");
                }
                ((AbstractButton)object2).addActionListener(actionEvent -> {
                    ModelBuilder.this.m_doc.toggleFilled(ModelBuilder.this.m_Selection.getSingleSelection());
                    ModelBuilder.this.g_panel.repaint();
                });
                ((JMenuItem)object2).setEnabled(ModelBuilder.this.m_Selection.isSingleSelection());
                jPopupMenu.add((JMenuItem)object2);
                object = new JMenuItem("Properties");
                ((AbstractButton)object).addActionListener(actionEvent -> {
                    Shape shape = ModelBuilder.this.m_Selection.getSingleSelectionShape();
                    if (shape instanceof BEASTObjectShape) {
                        BEASTInterface bEASTInterface = ((BEASTObjectShape)shape).m_beastObject;
                        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
                        for (Shape shape2 : ModelBuilder.this.m_doc.m_objects) {
                            if (!(shape2 instanceof BEASTObjectShape)) continue;
                            arrayList.add(((BEASTObjectShape)shape2).m_beastObject);
                        }
                        BEASTObjectDialog bEASTObjectDialog = new BEASTObjectDialog(bEASTInterface, bEASTInterface.getClass(), arrayList, null);
                        if (bEASTObjectDialog.showDialog()) {
                            int n = 0;
                            if (arrayList.size() < BEASTObjectPanel.g_plugins.size()) {
                                for (BEASTInterface bEASTInterface2 : BEASTObjectPanel.g_plugins.values()) {
                                    if (arrayList.contains(bEASTInterface2)) continue;
                                    try {
                                        BEASTObjectShape bEASTObjectShape = new BEASTObjectShape(bEASTInterface2, ModelBuilder.this.m_doc);
                                        bEASTObjectShape.m_x = 10;
                                        bEASTObjectShape.m_y = ++n * 50;
                                        bEASTObjectShape.m_w = 80;
                                        ModelBuilder.this.m_doc.addNewShape(bEASTObjectShape);
                                        ModelBuilder.this.updateStatus();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                            ModelBuilder.this.m_Selection.clear();
                            ModelBuilder.this.m_doc.recalcArrows();
                            ModelBuilder.this.m_doc.adjustArrows();
                        }
                        DrawPanel.this.repaint();
                    }
                });
                ((JMenuItem)object).setEnabled(ModelBuilder.this.m_Selection.isSingleSelection());
                jPopupMenu.add((JMenuItem)object);
                JMenuItem jMenuItem2 = new JMenuItem("Save as");
                jMenuItem2.addActionListener(actionEvent -> {
                    int n;
                    Shape shape = ModelBuilder.this.m_Selection.getSingleSelectionShape();
                    BEASTInterface bEASTInterface = ((BEASTObjectShape)shape).m_beastObject;
                    JFileChooser jFileChooser = new JFileChooser(ModelBuilder.this.m_sDir);
                    jFileChooser.addChoosableFileFilter(ModelBuilder.this.ef1);
                    jFileChooser.setDialogTitle("Save BEASTObject As");
                    if (!ModelBuilder.this.m_sFileName.equals("")) {
                        jFileChooser.setSelectedFile(new File(ModelBuilder.this.m_sFileName));
                    }
                    if ((n = jFileChooser.showSaveDialog(ModelBuilder.this.g_panel)) == 0) {
                        String string = jFileChooser.getSelectedFile().toString();
                        if (string.lastIndexOf(47) > 0) {
                            ModelBuilder.this.m_sDir = string.substring(0, string.lastIndexOf(47));
                        }
                        if (!string.endsWith(ModelBuilder.FILE_EXT)) {
                            string = string.concat(ModelBuilder.FILE_EXT);
                        }
                        try {
                            FileWriter fileWriter = new FileWriter(string);
                            fileWriter.write(new XMLProducer().modelToXML(bEASTInterface));
                            fileWriter.close();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Something went wrong when writing the file: " + exception.getClass().getName() + " " + exception.getMessage());
                        }
                        ModelBuilder.this.m_sFileName = string;
                    }
                    DrawPanel.this.repaint();
                });
                jMenuItem2.setEnabled(ModelBuilder.this.m_Selection.isSingleSelection());
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.setLocation(mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.show(ModelBuilder.this.g_panel, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ModelBuilder.this.m_drawShape != null) {
                    ModelBuilder.this.m_drawShape.normalize();
                }
                DrawPanel.this.m_bIsMoving = false;
                boolean bl = true;
                switch (ModelBuilder.this.m_nMode) {
                    case 0: {
                        if (ModelBuilder.this.m_selectRect != null) {
                            if ((mouseEvent.getModifiersEx() & 0x80) == 0 && (mouseEvent.getModifiersEx() & 0x40) == 0) {
                                ModelBuilder.this.m_Selection.clear();
                            }
                            for (int i = 0; i < ModelBuilder.this.m_doc.m_objects.size(); ++i) {
                                if (!ModelBuilder.this.m_doc.m_objects.get(i).intersects(ModelBuilder.this.m_selectRect) || !ModelBuilder.this.m_doc.m_objects.get((int)i).m_bNeedsDrawing) continue;
                                if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                                    ModelBuilder.this.m_Selection.toggleSelection(i);
                                    continue;
                                }
                                ModelBuilder.this.m_Selection.addToSelection(i);
                            }
                            ModelBuilder.this.m_selectRect = null;
                            ModelBuilder.this.updateStatus();
                        }
                        return;
                    }
                    case 1: {
                        ModelBuilder.this.m_nMode = 0;
                        ModelBuilder.this.updateStatus();
                        return;
                    }
                    case 9: {
                        BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)ModelBuilder.this.m_drawShape;
                        if (bEASTObjectShape == null) {
                            return;
                        }
                        if (bEASTObjectShape.m_w > 0 && bEASTObjectShape.m_h > 0) {
                            String string = (String)JOptionPane.showInputDialog(ModelBuilder.this.g_panel, "Select a constant", "select", -1, null, ModelBuilder.this.m_doc.m_sPlugInNames, null);
                            if (string != null) {
                                try {
                                    bEASTObjectShape.init(string, ModelBuilder.this.m_doc);
                                    ModelBuilder.this.m_doc.addNewShape(bEASTObjectShape);
                                    ModelBuilder.this.updateStatus();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 7: {
                        Shape shape;
                        Arrow arrow = (Arrow)ModelBuilder.this.m_drawShape;
                        if (ModelBuilder.this.m_drawShape == null) break;
                        int n = -1;
                        for (int i = 0; n < 0 && i < ModelBuilder.this.m_doc.m_objects.size(); ++i) {
                            shape = ModelBuilder.this.m_doc.m_objects.get(i);
                            if (!shape.m_bNeedsDrawing || !shape.intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                            DrawPanel.this.m_nPosX = shape.offsetX(mouseEvent.getX());
                            DrawPanel.this.m_nPosY = shape.offsetY(mouseEvent.getY());
                            n = i;
                        }
                        if (n < 0) {
                            ModelBuilder.this.m_drawShape = null;
                            DrawPanel.this.repaint();
                            return;
                        }
                        Shape shape2 = ModelBuilder.this.m_doc.m_objects.get(n);
                        if (!(shape2 instanceof InputShape)) {
                            ModelBuilder.this.m_drawShape = null;
                            DrawPanel.this.repaint();
                            return;
                        }
                        shape = (InputShape)shape2;
                        if (ModelBuilder.this.m_doc.isAscendant(arrow.m_tailShape.m_beastObject, ((InputShape)shape).getBEASTObject())) {
                            JOptionPane.showMessageDialog(null, "Cannot make this connection since this creates a cycle in the model");
                            return;
                        }
                        try {
                            arrow.setHead((InputShape)shape, ModelBuilder.this.m_doc.m_objects, ModelBuilder.this.m_doc);
                            ModelBuilder.this.m_doc.addNewShape(arrow);
                            break;
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, exception.getMessage());
                            DrawPanel.this.repaint();
                        }
                    }
                }
                ModelBuilder.this.m_drawShape = null;
                ModelBuilder.this.m_nMode = 0;
                if (bl) {
                    ModelBuilder.this.m_Selection.setSingleSelection(ModelBuilder.this.m_doc.m_objects.size() - 1);
                    ModelBuilder.this.g_panel.repaint();
                } else {
                    ModelBuilder.this.m_Selection.clear();
                    ModelBuilder.this.g_panel.repaint();
                }
            }
        }

        class GBDrawMouseMotionListener
        extends MouseMotionAdapter {
            GBDrawMouseMotionListener() {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                switch (ModelBuilder.this.m_nMode) {
                    case 0: {
                        if (DrawPanel.this.m_bIsMoving || ModelBuilder.this.m_Selection.isSingleSelection() && ModelBuilder.this.m_Selection.intersects(mouseEvent.getX(), mouseEvent.getY())) {
                            DrawPanel.this.m_bIsMoving = true;
                            Shape shape = ModelBuilder.this.m_doc.m_objects.get(ModelBuilder.this.m_Selection.getSingleSelection());
                            if (DrawPanel.this.getCursor().getType() == 0) {
                                ModelBuilder.this.m_doc.moveShape(DrawPanel.this.m_nPosX, DrawPanel.this.m_nPosY, mouseEvent.getX(), mouseEvent.getY(), ModelBuilder.this.m_Selection.getSingleSelection());
                                ModelBuilder.this.m_Selection.m_tracker = shape.getTracker();
                            } else {
                                ModelBuilder.this.m_doc.movePoint(DrawPanel.this.m_nPoint, DrawPanel.this.m_nPosX, DrawPanel.this.m_nPosY, mouseEvent.getX(), mouseEvent.getY(), ModelBuilder.this.m_Selection.getSingleSelection());
                                ModelBuilder.this.m_Selection.m_tracker = shape.getTracker();
                            }
                            ModelBuilder.this.updateStatus();
                            break;
                        }
                        if (ModelBuilder.this.m_selectRect == null) {
                            if (ModelBuilder.this.m_Selection.intersects(mouseEvent.getX(), mouseEvent.getY())) {
                                ModelBuilder.this.m_nMode = 1;
                                DrawPanel.this.m_nPosX = mouseEvent.getX();
                                DrawPanel.this.m_nPosY = mouseEvent.getY();
                            } else {
                                ModelBuilder.this.m_selectRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
                            }
                        } else {
                            ModelBuilder.this.m_selectRect.width = mouseEvent.getX() - ModelBuilder.this.m_selectRect.x;
                            ModelBuilder.this.m_selectRect.height = mouseEvent.getY() - ModelBuilder.this.m_selectRect.y;
                        }
                        ModelBuilder.this.g_panel.repaint();
                        break;
                    }
                    case 1: {
                        int n = mouseEvent.getX() - DrawPanel.this.m_nPosX;
                        int n2 = mouseEvent.getY() - DrawPanel.this.m_nPosY;
                        ModelBuilder.this.m_doc.moveShapes(n, n2, ModelBuilder.this.m_Selection.m_Selection);
                        ModelBuilder.this.m_Selection.offset(n, n2);
                        ModelBuilder.this.m_doc.adjustArrows();
                        DrawPanel.this.m_nPosX = mouseEvent.getX();
                        DrawPanel.this.m_nPosY = mouseEvent.getY();
                        DrawPanel.this.repaint();
                        break;
                    }
                    case 9: {
                        BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)ModelBuilder.this.m_drawShape;
                        if (ModelBuilder.this.m_drawShape == null) {
                            bEASTObjectShape = new BEASTObjectShape();
                            bEASTObjectShape.m_x = mouseEvent.getX();
                            bEASTObjectShape.m_y = mouseEvent.getY();
                            bEASTObjectShape.m_w = 1;
                            bEASTObjectShape.m_h = 1;
                            ModelBuilder.this.m_drawShape = bEASTObjectShape;
                        } else {
                            bEASTObjectShape.m_w = mouseEvent.getX() - bEASTObjectShape.m_x;
                            bEASTObjectShape.m_h = mouseEvent.getY() - bEASTObjectShape.m_y;
                        }
                        ModelBuilder.this.m_Selection.m_tracker = bEASTObjectShape.getTracker();
                        ModelBuilder.this.g_panel.repaint();
                        break;
                    }
                    case 7: {
                        Arrow arrow = (Arrow)ModelBuilder.this.m_drawShape;
                        if (ModelBuilder.this.m_drawShape == null) {
                            int n = -1;
                            for (int i = 0; n < 0 && i < ModelBuilder.this.m_doc.m_objects.size(); ++i) {
                                Shape shape = ModelBuilder.this.m_doc.m_objects.get(i);
                                if (!shape.m_bNeedsDrawing || !shape.intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                                DrawPanel.this.m_nPosX = shape.offsetX(mouseEvent.getX());
                                DrawPanel.this.m_nPosY = shape.offsetY(mouseEvent.getY());
                                n = i;
                            }
                            if (n < 0) {
                                return;
                            }
                            Shape shape = ModelBuilder.this.m_doc.m_objects.get(n);
                            if (shape instanceof Arrow) {
                                return;
                            }
                            if (shape instanceof InputShape) {
                                shape = ((InputShape)shape).m_beastObjectShape;
                            }
                            arrow = new Arrow((BEASTObjectShape)shape, mouseEvent.getX(), mouseEvent.getY());
                            arrow.m_w = 1;
                            arrow.m_h = 1;
                            ModelBuilder.this.m_drawShape = arrow;
                        } else {
                            arrow.setHead(mouseEvent.getX() - arrow.m_x, mouseEvent.getY() - arrow.m_y);
                        }
                        ModelBuilder.this.g_panel.repaint();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Object object;
                if (ModelBuilder.this.m_Selection.m_tracker != null && ModelBuilder.this.m_Selection.isSingleSelection()) {
                    if (DrawPanel.this.getCursor().getType() != 0) {
                        DrawPanel.this.setCursor(new Cursor(0));
                    }
                    for (int i = 0; i < ModelBuilder.this.m_Selection.m_tracker.size(); ++i) {
                        object = ModelBuilder.this.m_Selection.m_tracker.get(i);
                        if (mouseEvent.getX() <= ((TrackPoint)object).m_nX - 4 || mouseEvent.getX() >= ((TrackPoint)object).m_nX + 4 || mouseEvent.getY() <= ((TrackPoint)object).m_nY - 4 || mouseEvent.getY() >= ((TrackPoint)object).m_nY + 4) continue;
                        DrawPanel.this.m_nPoint = i;
                        DrawPanel.this.m_nPosX = mouseEvent.getX() - ((TrackPoint)object).m_nX;
                        DrawPanel.this.m_nPosY = mouseEvent.getY() - ((TrackPoint)object).m_nY;
                        DrawPanel.this.setCursor(new Cursor(((TrackPoint)object).m_nCursor));
                        return;
                    }
                    Shape shape = ModelBuilder.this.m_doc.m_objects.get(ModelBuilder.this.m_Selection.getSingleSelection());
                    DrawPanel.this.m_nPosX = mouseEvent.getX() - shape.m_x;
                    DrawPanel.this.m_nPosY = mouseEvent.getY() - shape.m_y;
                } else if (DrawPanel.this.getCursor().getType() != 0) {
                    DrawPanel.this.setCursor(new Cursor(0));
                }
                for (int i = ModelBuilder.this.m_doc.m_objects.size() - 1; i >= 0; --i) {
                    object = ModelBuilder.this.m_doc.m_objects.get(i);
                    if (!((Shape)object).m_bNeedsDrawing || !((Shape)object).intersects(mouseEvent.getX(), mouseEvent.getY())) continue;
                    if (object instanceof BEASTObjectShape) {
                        BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)object;
                        try {
                            String string = "<html>";
                            for (InputShape inputShape : bEASTObjectShape.m_inputs) {
                                string = string + inputShape.getLongLabel() + "<br>";
                            }
                            string = string + "</html>";
                            DrawPanel.this.setToolTipText(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                    }
                    return;
                }
            }
        }
    }

    class ActionLayout
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionLayout() {
            super("Layout", "Layout graph", "layout", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.g_panel.setCursor(new Cursor(3));
            ModelBuilder.this.m_doc.layout();
            ModelBuilder.this.m_doc.adjustArrows();
            ModelBuilder.this.g_panel.setCursor(new Cursor(0));
            ModelBuilder.this.repaint();
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionViewSequences
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionViewSequences() {
            super("View Sequences", "View Sequences", "viewsequences", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_bViewSequences = !ModelBuilder.this.m_bViewSequences;
            ModelBuilder.this.setDrawingFlag();
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionViewOperators
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionViewOperators() {
            super("View Operators", "View Operators", "viewoperators", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_bViewOperators = !ModelBuilder.this.m_bViewOperators;
            ModelBuilder.this.setDrawingFlag();
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionViewLoggers
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionViewLoggers() {
            super("View loggers", "View loggers", "about", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_bViewLoggers = !ModelBuilder.this.m_bViewLoggers;
            ModelBuilder.this.setDrawingFlag();
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionRelax
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionRelax() {
            super("Relax", "Relax positions", "about", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_bRelax = !ModelBuilder.this.m_bRelax;
            ModelBuilder.this.m_viewRelax.setState(ModelBuilder.this.m_bRelax);
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionAbout
    extends MyAction {
        private static final long serialVersionUID = -20389110859353L;

        public ActionAbout() {
            super("About", "Help about", "about", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(null, "GenerationD Draw Tool\nRemco Bouckaert\nrrb@xm.co.nz\n2010", "About Message", -1);
        }
    }

    class ActionSpaceVertical
    extends MyAction {
        private static final long serialVersionUID = -838642085935519L;

        public ActionSpaceVertical() {
            super("Space Vertical", "Space Vertical", "spacevertical", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.spaceVertical(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionSpaceHorizontal
    extends MyAction {
        private static final long serialVersionUID = -9738642085935519L;

        public ActionSpaceHorizontal() {
            super("Space Horizontal", "Space Horizontal", "spacehorizontal", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.spaceHorizontal(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionCenterVertical
    extends MyAction {
        private static final long serialVersionUID = -8638642085935519L;

        public ActionCenterVertical() {
            super("Center Vertical", "Center Vertical", "centervertical", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.centreVertical(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionCenterHorizontal
    extends MyAction {
        private static final long serialVersionUID = -7538642085935519L;

        public ActionCenterHorizontal() {
            super("Center Horizontal", "Center Horizontal", "centerhorizontal", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.centreHorizontal(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionAlignBottom
    extends MyAction {
        private static final long serialVersionUID = -6438642085935519L;

        public ActionAlignBottom() {
            super("Align Bottom", "Align Bottom", "alignbottom", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.alignBottom(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionAlignTop
    extends MyAction {
        private static final long serialVersionUID = -5338642085935519L;

        public ActionAlignTop() {
            super("Align Top", "Align Top", "aligntop", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.alignTop(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionAlignRight
    extends MyAction {
        private static final long serialVersionUID = -4238642085935519L;

        public ActionAlignRight() {
            super("Align Right", "Align Right", "alignright", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.alignRight(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionAlignLeft
    extends MyAction {
        private static final long serialVersionUID = -3138642085935519L;

        public ActionAlignLeft() {
            super("Align Left", "Align Left", "alignleft", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.alignLeft(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionBackward
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionBackward() {
            super("Bring backward", "Backward", "backward", -1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke("minus");
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.backward(ModelBuilder.this.m_Selection);
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionToBack
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionToBack() {
            super("Bring to back", "To back", "toback", 45);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.toBack(ModelBuilder.this.m_Selection);
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionForward
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionForward() {
            super("Bring forward", "Forward", "forward", -1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke("plus");
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.forward(ModelBuilder.this.m_Selection);
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionToFront
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionToFront() {
            super("Bring to front", "To front", "tofront", 521);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.toFront(ModelBuilder.this.m_Selection);
            ModelBuilder.this.g_panel.repaint();
        }
    }

    class ActionPenColor
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionPenColor() {
            super("Pen color", "Pen color", "pencolor", -1);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Shape shape = ModelBuilder.this.m_doc.m_objects.get(ModelBuilder.this.m_Selection.getSingleSelection());
            Color color = JColorChooser.showDialog(ModelBuilder.this.g_panel, "Select Fill color", shape.getFillColor());
            if (color != null) {
                ModelBuilder.this.m_doc.setPenColor(color, ModelBuilder.this.m_Selection);
                ModelBuilder.this.g_panel.repaint();
            }
        }
    }

    class ActionFillColor
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionFillColor() {
            super("Fill color", "Fill color", "fillcolor", -1);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Shape shape = ModelBuilder.this.m_doc.m_objects.get(ModelBuilder.this.m_Selection.getSingleSelection());
            Color color = JColorChooser.showDialog(ModelBuilder.this.g_panel, "Select Fill color", shape.getFillColor());
            if (color != null) {
                ModelBuilder.this.m_doc.setFillColor(color, ModelBuilder.this.m_Selection);
                ModelBuilder.this.g_panel.repaint();
            }
        }
    }

    class ActionFunction
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionFunction() {
            super("Function", "Function", "function", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_nMode = 9;
        }
    }

    class ActionArrow
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionArrow() {
            super("Arrow", "Arrow", "arrow", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_nMode = 7;
        }
    }

    class ActionSelect
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionSelect() {
            super("Select", "Select", "select", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_nMode = 0;
        }
    }

    class ActionCollapse
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionCollapse() {
            super("Collapse shapes", "Collapse", "collapse", -1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke("G");
            this.putValue("AcceleratorKey", keyStroke);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.collapse(ModelBuilder.this.m_Selection);
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionPasteNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionPasteNode() {
            super("Paste", "Paste Nodes", "paste", 86);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ModelBuilder.this.m_doc.pasteShape(ModelBuilder.this.m_clipboard.getText());
                ModelBuilder.this.updateStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public boolean isEnabled() {
            return ModelBuilder.this.m_clipboard.hasText();
        }
    }

    class ActionCutNode
    extends ActionCopyNode {
        private static final long serialVersionUID = -2038822085935519L;

        public ActionCutNode() {
            super("Cut", "Cut Nodes", "cut", 88);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.copy();
            ModelBuilder.this.m_doc.deleteShapes(ModelBuilder.this.m_Selection.m_Selection);
            ModelBuilder.this.m_Selection.clear();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionCopyNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionCopyNode() {
            super("Copy", "Copy Nodes", "copy", 67);
            this.setEnabled(false);
        }

        public ActionCopyNode(String string, String string2, String string3, int n) {
            super(string, string2, string3, n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.copy();
        }

        public void copy() {
            if (ModelBuilder.this.m_Selection.hasSelection()) {
                String string = "<doc>\n";
                for (int n : ModelBuilder.this.m_Selection.m_Selection) {
                    string = string + ModelBuilder.this.m_doc.m_objects.get(n).getXML() + "\n";
                }
                string = string + "</doc>\n";
                ModelBuilder.this.m_clipboard.setText(string);
            }
        }
    }

    class ActionDeleteNode
    extends MyAction {
        private static final long serialVersionUID = -2038912085935519L;

        public ActionDeleteNode() {
            super("Delete Node", "Delete Node", "delnode", 127);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.deleteShapes(ModelBuilder.this.m_Selection.m_Selection);
            ModelBuilder.this.m_Selection.clear();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionSelectAll
    extends MyAction {
        private static final long serialVersionUID = -2038912085935519L;

        public ActionSelectAll() {
            super("Select All", "Select All", "selectall", 65);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_Selection.clear();
            for (int i = 0; i < ModelBuilder.this.m_doc.m_objects.size(); ++i) {
                if (!ModelBuilder.this.m_doc.m_objects.get((int)i).m_bNeedsDrawing) continue;
                ModelBuilder.this.m_Selection.m_Selection.add(new Integer(i));
            }
            ModelBuilder.this.m_Selection.refreshTracker();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionRedo
    extends MyAction {
        private static final long serialVersionUID = -4038910085935519L;

        public ActionRedo() {
            super("Redo", "Redo", "redo", 89);
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return ModelBuilder.this.m_doc.canRedo();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.redo();
            ModelBuilder.this.m_Selection.clear();
            ModelBuilder.this.setDrawingFlag();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionUndo
    extends MyAction {
        private static final long serialVersionUID = -3038910085935519L;

        public ActionUndo() {
            super("Undo", "Undo", "undo", 90);
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return ModelBuilder.this.m_doc.canUndo();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_doc.undo();
            ModelBuilder.this.m_Selection.clear();
            ModelBuilder.this.setDrawingFlag();
            ModelBuilder.this.updateStatus();
        }
    }

    class ActionLoad
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionLoad() {
            super("Load", "Load Graph", "open", 79);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(ModelBuilder.this.m_sDir);
            jFileChooser.addChoosableFileFilter(ModelBuilder.this.ef1);
            jFileChooser.setDialogTitle("Load Graph");
            int n = jFileChooser.showOpenDialog(ModelBuilder.this.g_panel);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                if (string.lastIndexOf(47) > 0) {
                    ModelBuilder.this.m_sDir = string.substring(0, string.lastIndexOf(47));
                }
                ModelBuilder.this.g_panel.setCursor(new Cursor(3));
                ModelBuilder.this.m_doc.loadFile(string);
                ModelBuilder.this.m_sFileName = string;
                ModelBuilder.this.g_panel.repaint();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ModelBuilder.this.setDrawingFlag();
                ModelBuilder.this.g_panel.repaint();
                ModelBuilder.this.g_panel.setCursor(new Cursor(0));
            }
        }
    }

    class ActionNew
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionNew() {
            super("New", "New Network", "new", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelBuilder.this.m_sFileName = "";
            ModelBuilder.this.m_doc = new Document();
            ModelBuilder.this.m_Selection.setDocument(ModelBuilder.this.m_doc);
            ModelBuilder.this.updateStatus();
            ModelBuilder.this.m_doc.clearUndoStack();
            ModelBuilder.this.m_Selection.clear();
            ModelBuilder.this.m_drawShape = null;
        }
    }

    class ActionQuit
    extends ActionSave {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionQuit() {
            super("Exit", "Exit Program", "exit", 115);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ModelBuilder.this.m_doc.m_bIsSaved) {
                int n = JOptionPane.showConfirmDialog(null, "Drawing changed. Do you want to save it?", "Save before closing?", 1);
                if (n == 2) {
                    return;
                }
                if (n == 0 && !this.saveAs()) {
                    return;
                }
            }
            System.exit(0);
        }
    }

    class ActionExport
    extends MyAction {
        boolean m_bIsExporting;
        private static final long serialVersionUID = -3027642085935519L;

        public ActionExport() {
            super("Export", "Export to graphics file", "export", -1);
            this.m_bIsExporting = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                this.m_bIsExporting = true;
                try {
                    File file = Utils.getSaveFile("Export image (type determined by extention)", new File(ModelBuilder.this.m_sDir), "Image files", "png", "bmp", "jpg", "svg", "pdf");
                    if (file == null) break block13;
                    String string = file.getAbsolutePath();
                    if (string.lastIndexOf(47) > 0) {
                        ModelBuilder.this.m_sDir = string.substring(0, string.lastIndexOf(47));
                    }
                    if (string == null || string.equals("")) break block13;
                    if (string.toLowerCase().endsWith(".pdf")) {
                        JOptionPane.showMessageDialog(null, "Not implemented yet");
                        this.m_bIsExporting = false;
                        ModelBuilder.this.repaint();
                        return;
                    }
                    if (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".jpg") || string.toLowerCase().endsWith(".bmp")) {
                        BufferedImage bufferedImage = new BufferedImage(ModelBuilder.this.g_panel.getWidth(), ModelBuilder.this.g_panel.getHeight(), 1);
                        Graphics graphics = bufferedImage.getGraphics();
                        graphics.setPaintMode();
                        graphics.setColor(ModelBuilder.this.getBackground());
                        graphics.fillRect(0, 0, ModelBuilder.this.g_panel.getWidth(), ModelBuilder.this.g_panel.getHeight());
                        ModelBuilder.this.g_panel.printAll(graphics);
                        try {
                            if (string.toLowerCase().endsWith(".png")) {
                                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
                            } else if (string.toLowerCase().endsWith(".jpg")) {
                                ImageIO.write((RenderedImage)bufferedImage, "jpg", new File(string));
                            } else if (string.toLowerCase().endsWith(".bmp")) {
                                ImageIO.write((RenderedImage)bufferedImage, "bmp", new File(string));
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, string + " was not written properly: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                        this.m_bIsExporting = false;
                        ModelBuilder.this.repaint();
                        return;
                    }
                    if (string.toLowerCase().endsWith(".svg")) {
                        this.writeSVG(string);
                        this.m_bIsExporting = false;
                        ModelBuilder.this.repaint();
                        return;
                    }
                    JOptionPane.showMessageDialog(null, "Extention of file " + string + " not recognized as png,bmp,jpg or svg file");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Something went wrong while exporting image: " + exception.getMessage());
                }
            }
            this.m_bIsExporting = false;
            ModelBuilder.this.repaint();
        }

        private void writeSVG(String string) throws FileNotFoundException {
            PrintStream printStream = new PrintStream(string);
            printStream.println("<?xml version='1.0'?>\n<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN'\n  'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'>\n<svg xmlns='http://www.w3.org/2000/svg' version='1.1'\n      width='" + ModelBuilder.this.getWidth() + "' height='" + ModelBuilder.this.getHeight() + "' viewBox='0 0 " + ModelBuilder.this.getWidth() + " " + ModelBuilder.this.getHeight() + "'>\n" + "<rect fill='#fff' width='" + ModelBuilder.this.getWidth() + "' height='" + ModelBuilder.this.getHeight() + "'/>");
            for (Shape shape : ModelBuilder.this.m_doc.m_objects) {
                shape.toSVG(printStream);
            }
            printStream.println("</svg>");
        }

        public boolean isExporting() {
            return this.m_bIsExporting;
        }
    }

    abstract class MyFileFilter
    extends FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(this.getExtention());
        }

        public abstract String getExtention();
    }

    class ActionSaveAs
    extends ActionSave {
        private static final long serialVersionUID = -20389110859354L;

        public ActionSaveAs() {
            super("Save As", "Save Graph As", "saveas", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.saveAs();
        }
    }

    class ActionPrint
    extends ActionSave {
        private static final long serialVersionUID = -20389001859354L;
        boolean m_bIsPrinting;

        public ActionPrint() {
            super("Print", "Print Graph", "print", 80);
            this.m_bIsPrinting = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(ModelBuilder.this.g_panel);
            if (printerJob.printDialog()) {
                try {
                    this.m_bIsPrinting = true;
                    printerJob.print();
                    this.m_bIsPrinting = false;
                }
                catch (PrinterException printerException) {
                    this.m_bIsPrinting = false;
                }
            }
        }

        public boolean isPrinting() {
            return this.m_bIsPrinting;
        }
    }

    class ActionSave
    extends MyAction {
        private static final long serialVersionUID = -20389110859355156L;

        public ActionSave() {
            super("Save", "Save Graph", "save", 83);
        }

        public ActionSave(String string, String string2, String string3, int n) {
            super(string, string2, string3, n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ModelBuilder.this.m_sFileName.equals("")) {
                if (!ModelBuilder.this.validateModel()) {
                    return;
                }
                this.saveFile(ModelBuilder.this.m_sFileName);
                ModelBuilder.this.m_doc.isSaved();
            } else if (this.saveAs()) {
                ModelBuilder.this.m_doc.isSaved();
            }
        }

        boolean saveAs() {
            int n;
            if (!ModelBuilder.this.validateModel()) {
                return false;
            }
            JFileChooser jFileChooser = new JFileChooser(ModelBuilder.this.m_sDir);
            jFileChooser.addChoosableFileFilter(ModelBuilder.this.ef1);
            jFileChooser.setDialogTitle("Save Model As");
            if (!ModelBuilder.this.m_sFileName.equals("")) {
                jFileChooser.setSelectedFile(new File(ModelBuilder.this.m_sFileName));
            }
            if ((n = jFileChooser.showSaveDialog(ModelBuilder.this.g_panel)) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                if (string.lastIndexOf(47) > 0) {
                    ModelBuilder.this.m_sDir = string.substring(0, string.lastIndexOf(47));
                }
                if (!string.endsWith(ModelBuilder.FILE_EXT)) {
                    string = string.concat(ModelBuilder.FILE_EXT);
                }
                this.saveFile(string);
                return true;
            }
            return false;
        }

        protected void saveFile(String string) {
            try {
                FileWriter fileWriter = new FileWriter(string);
                fileWriter.write(ModelBuilder.this.m_doc.toXML());
                fileWriter.close();
                ModelBuilder.this.m_sFileName = string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class ClipBoard {
        String m_sText = null;

        public ClipBoard() {
            if (ModelBuilder.this.a_pastenode != null) {
                ModelBuilder.this.a_pastenode.setEnabled(false);
            }
        }

        public boolean hasText() {
            return this.m_sText != null;
        }

        public String getText() {
            return this.m_sText;
        }

        public void setText(String string) {
            this.m_sText = string;
            ModelBuilder.this.a_pastenode.setEnabled(true);
        }
    }
}

