/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public abstract class DocumentFrame
extends AbstractFrame {
    private File documentFile = null;
    private AbstractAction saveAction = new AbstractAction("Save"){

        public void actionPerformed(ActionEvent actionEvent) {
            DocumentFrame.this.doSave();
        }
    };
    private AbstractAction saveAsAction = new AbstractAction("Save As..."){

        public void actionPerformed(ActionEvent actionEvent) {
            DocumentFrame.this.doSaveAs();
        }
    };

    protected abstract void initializeComponents();

    protected abstract boolean readFromFile(File var1) throws IOException;

    protected abstract boolean writeToFile(File var1) throws IOException;

    public final boolean hasFile() {
        return this.documentFile != null;
    }

    public final File getFile() {
        return this.documentFile;
    }

    public final void clearFile() {
        this.documentFile = null;
    }

    public boolean requestClose() {
        if (this.isDirty()) {
            int n = JOptionPane.showConfirmDialog(this, "Do you wish to save?", "Unsaved changes", 1, 2);
            if (n == 0) {
                return !this.doSave();
            }
            return n != 2 && n != -1;
        }
        return true;
    }

    public boolean openFile(File file) {
        try {
            if (this.readFromFile(file)) {
                this.documentFile = file;
                this.clearDirty();
                this.setFrameTitle();
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Unable to open file: File not found", "Unable to open file", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Unable to read file: " + iOException, "Unable to read file", 0);
        }
        return false;
    }

    public boolean doSave() {
        if (!this.hasFile()) {
            return this.doSaveAs();
        }
        try {
            if (this.writeToFile(this.documentFile)) {
                this.clearDirty();
                return true;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Unable to save file: " + iOException, "Unable to save file", 0);
        }
        return false;
    }

    public boolean doSaveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save Document As...", 1);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return false;
        }
        File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
        try {
            if (this.writeToFile(file)) {
                this.clearDirty();
                this.documentFile = file;
                this.setFrameTitle();
                return true;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Unable to save file: " + iOException, "Unable to save file", 0);
        }
        return false;
    }

    protected final void setFrameTitle() {
        String string = this.getTitle();
        if (this.documentFile != null) {
            this.setTitle(string + " - " + this.documentFile.getName());
            this.getRootPane().putClientProperty("Window.documentFile", this.documentFile);
        }
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public Action getSaveAsAction() {
        return this.saveAsAction;
    }
}

