/*
 * Decompiled with CFR 0.152.
 */
package jam.disclosure;

import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SlideOpenPanel
extends JPanel {
    ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = (int)Math.ceil((double)(SlideOpenPanel.this.target - SlideOpenPanel.this.topPanel.getHeight()) / 10.0);
            if (n != 0) {
                Dimension dimension = SlideOpenPanel.this.topPanel.getPreferredSize();
                dimension.height += n;
                SlideOpenPanel.this.topPanel.setPreferredSize(dimension);
                SlideOpenPanel.this.topPanel.revalidate();
                SlideOpenPanel.this.revalidate();
                SlideOpenPanel.this.repaint();
            } else {
                SlideOpenPanel.this.stopAnimation();
            }
        }
    };
    private final JPanel topPanel;
    private final JButton doneButton;
    private JPanel utilityPanel = null;
    private Timer timer = null;
    private int animationSpeed = 10;
    private int target;
    private boolean hiding;
    private static BufferedImage backgroundImage = null;
    private static Icon closeIcon = IconUtils.getIcon(SlideOpenPanel.class, "images/close.png");

    public SlideOpenPanel(JPanel jPanel) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout()){

            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        this.topPanel.setOpaque(false);
        this.topPanel.setVisible(false);
        this.topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.add((Component)this.topPanel, "North");
        this.add((Component)jPanel, "Center");
        this.doneButton = new JButton(closeIcon);
        Dimension dimension = this.doneButton.getPreferredSize();
        this.doneButton.setPreferredSize(new Dimension(26, 26));
        this.adjustComponent(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SlideOpenPanel.this.hideUtilityPanel();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "doClose");
        this.getActionMap().put("doClose", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SlideOpenPanel.this.doneButton.doClick();
            }
        });
    }

    public void showUtilityPanel(JPanel jPanel) {
        if (jPanel == null) {
            return;
        }
        this.utilityPanel = jPanel;
        this.topPanel.removeAll();
        this.topPanel.add((Component)jPanel, "Center");
        this.topPanel.add((Component)this.doneButton, "East");
        Dimension dimension = this.topPanel.getPreferredSize();
        this.target = jPanel.getPreferredSize().height + 9;
        dimension.height = 0;
        this.topPanel.setPreferredSize(dimension);
        this.topPanel.setVisible(true);
        this.hiding = false;
        this.startAnimation();
    }

    public void hideUtilityPanel() {
        this.target = 0;
        this.hiding = true;
        this.utilityPanel = null;
        this.startAnimation();
    }

    public JPanel getUtilityPanel() {
        return this.utilityPanel;
    }

    protected void adjustComponent(JComponent jComponent) {
        Font font = UIManager.getFont("SmallSystemFont");
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.putClientProperty("JComponent.sizeVariant", "small");
        if (jComponent instanceof JButton) {
            jComponent.putClientProperty("JButton.buttonType", "roundRect");
            jComponent.setFocusable(false);
        }
        if (jComponent instanceof JComboBox) {
            jComponent.putClientProperty("JComboBox.isSquare", Boolean.TRUE);
            jComponent.setFocusable(false);
        }
        if (jComponent instanceof JCheckBox) {
            jComponent.setFocusable(false);
        }
    }

    private void startAnimation() {
        this.timer = new Timer(this.animationSpeed, this.listener);
        this.timer.setRepeats(true);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    private void stopAnimation() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        if (this.hiding) {
            this.topPanel.setVisible(false);
        }
    }

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(SlideOpenPanel.class, "images/utilityBackground.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

