/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import viz.Node;

public class NodeOrderer {
    public static final int GEOINFO = -5;
    public static final int MANUAL = -4;
    public static final int DEFAULT = -3;
    public static final int CLOSEST_OUTSIDE_FIRST = -2;
    public static final int CLOSEST_FIRST = -1;
    public static final int SINGLE = 0;
    public static final int COMPLETE = 1;
    public static final int AVERAGE = 2;
    public static final int MEAN = 3;
    public static final int CENTROID = 4;
    public static final int WARD = 5;
    public static final int ADJCOMLPETE = 6;
    public static final int OPTIMISE = 7;
    public static final int SORT_BY_ROOT_CANAL_LENGTH = 8;
    public static final int META_ALL = 100;
    public static final int META_SUM = 101;
    public static final int META_AVERAGE = 102;
    int m_nLinkType = 0;

    public NodeOrderer(int nLinkType) {
        this.m_nLinkType = nLinkType;
    }

    public int[] calcOrder(int nNrOfLabels, Node[] trees, Node[] cTrees, Node rootCanalTree, float[] fTreeWeight, List<int[]> clades, List<Double> cladeWeights) throws Exception {
        int i;
        double[][] fDist = new double[nNrOfLabels][nNrOfLabels];
        int i2 = 0;
        while (i2 < cTrees.length) {
            this.calcDistance(cTrees[i2], fDist, fTreeWeight[i2], new Vector<Integer>(), new Vector<Float>());
            ++i2;
        }
        int[] nOrder = null;
        int[] nRevOrder = null;
        if (this.m_nLinkType == -2) {
            nRevOrder = this.closestOutsideFirst(fDist);
        } else if (this.m_nLinkType == -1) {
            nRevOrder = this.closestFirst(fDist);
        } else {
            nOrder = this.buildClusterer(fDist);
        }
        if (this.m_nLinkType == 7) {
            nRevOrder = new int[fDist.length];
            this.traverse(rootCanalTree, nRevOrder, 0);
        }
        if (this.m_nLinkType == 8) {
            nRevOrder = new int[fDist.length];
            this.traverse2(rootCanalTree, nRevOrder, 0);
        }
        if (nRevOrder != null) {
            nOrder = new int[nNrOfLabels];
            i = 0;
            while (i < nNrOfLabels) {
                nOrder[nRevOrder[i]] = i;
                ++i;
            }
        }
        System.out.print("nOrder: ");
        i = 0;
        while (i < nNrOfLabels) {
            System.out.print(String.valueOf(nOrder[i]) + " | ");
            ++i;
        }
        System.out.println("\nfinal score = " + this.score(nOrder, fDist));
        return nOrder;
    }

    private int traverse(Node node, int[] nOrder, int i) {
        if (node.isLeaf()) {
            nOrder[i] = node.m_iLabel;
            ++i;
        } else {
            i = this.traverse(node.m_left, nOrder, i);
            i = this.traverse(node.m_right, nOrder, i);
        }
        return i;
    }

    private int traverse2(Node node, int[] nOrder, int i) {
        if (node.isLeaf()) {
            nOrder[i] = node.m_iLabel;
            ++i;
        } else if (node.m_left.m_fLength > node.m_right.m_fLength) {
            i = this.traverse2(node.m_left, nOrder, i);
            i = this.traverse2(node.m_right, nOrder, i);
        } else {
            i = this.traverse2(node.m_right, nOrder, i);
            i = this.traverse2(node.m_left, nOrder, i);
        }
        return i;
    }

    int[] closestOutsideFirst(double[][] fDist) {
        int j;
        int n = fDist.length;
        int[] nOrder = new int[n];
        boolean[] bDone = new boolean[n];
        int iMax = 0;
        int jMax = 1;
        double fMax = fDist[0][1];
        int i = 0;
        while (i < n) {
            j = i + 1;
            while (j < n) {
                if (fDist[i][j] < fMax) {
                    fMax = fDist[i][j];
                    iMax = i;
                    jMax = j;
                }
                ++j;
            }
            ++i;
        }
        nOrder[0] = iMax;
        nOrder[1] = jMax;
        bDone[iMax] = true;
        bDone[jMax] = true;
        int k = 2;
        while (k < n) {
            iMax = -1;
            jMax = -1;
            fMax = Double.MAX_VALUE;
            int i2 = 0;
            while (i2 < n) {
                if (!bDone[i2]) {
                    if (fDist[nOrder[k - 1]][i2] < fMax) {
                        fMax = fDist[nOrder[k - 1]][i2];
                        iMax = k - 1;
                        jMax = i2;
                    }
                    if (fDist[nOrder[0]][i2] < fMax) {
                        fMax = fDist[nOrder[0]][i2];
                        iMax = 0;
                        jMax = i2;
                    }
                }
                ++i2;
            }
            if (iMax == k - 1) {
                nOrder[k] = jMax;
                bDone[jMax] = true;
            } else if (iMax == 0) {
                j = k;
                while (j > 0) {
                    nOrder[j] = nOrder[j - 1];
                    --j;
                }
                nOrder[0] = jMax;
                bDone[jMax] = true;
            } else {
                System.err.println("Something's wrong");
            }
            ++k;
        }
        return nOrder;
    }

    int[] closestFirst(double[][] fDist) {
        int j;
        int n = fDist.length;
        int[] nOrder = new int[n];
        boolean[] bDone = new boolean[n];
        int iMax = 0;
        int jMax = 1;
        double fMax = fDist[0][1];
        int i = 0;
        while (i < n) {
            j = i + 1;
            while (j < n) {
                if (fDist[i][j] < fMax) {
                    fMax = fDist[i][j];
                    iMax = i;
                    jMax = j;
                }
                ++j;
            }
            ++i;
        }
        nOrder[0] = iMax;
        nOrder[1] = jMax;
        bDone[iMax] = true;
        bDone[jMax] = true;
        int k = 2;
        while (k < n) {
            iMax = -1;
            jMax = -1;
            fMax = Double.MAX_VALUE;
            j = 0;
            while (j < k) {
                int i2 = 0;
                while (i2 < n) {
                    if (!bDone[i2] && fDist[nOrder[j]][i2] < fMax) {
                        fMax = fDist[nOrder[j]][i2];
                        iMax = i2;
                        jMax = j;
                    }
                    ++i2;
                }
                ++j;
            }
            if (jMax == 0) {
                if (fDist[nOrder[0]][nOrder[1]] > fDist[iMax][nOrder[1]]) {
                    ++jMax;
                }
            } else if (jMax == k - 1) {
                if (fDist[nOrder[k - 2]][iMax] > fDist[nOrder[k - 2]][nOrder[k - 1]]) {
                    ++jMax;
                }
            } else if (fDist[nOrder[jMax - 1]][iMax] + fDist[nOrder[jMax]][nOrder[jMax + 1]] > fDist[nOrder[jMax - 1]][nOrder[jMax]] + fDist[iMax][nOrder[jMax + 1]]) {
                ++jMax;
            }
            j = k;
            while (j > jMax) {
                nOrder[j] = nOrder[j - 1];
                --j;
            }
            nOrder[jMax] = iMax;
            bDone[iMax] = true;
            ++k;
        }
        return nOrder;
    }

    void calcDistance(Node node, double[][] fDistMatrix, double fWeight, Vector<Integer> iLabel, Vector<Float> fLength) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            iLabel.add(node.getNr());
            fLength.add(Float.valueOf(node.m_fLength + 1.0f));
        } else {
            Vector<Integer> iLeft = new Vector<Integer>();
            Vector<Integer> iRight = new Vector<Integer>();
            Vector<Float> fLeft = new Vector<Float>();
            Vector<Float> fRight = new Vector<Float>();
            this.calcDistance(node.m_left, fDistMatrix, fWeight, iLeft, fLeft);
            this.calcDistance(node.m_right, fDistMatrix, fWeight, iRight, fRight);
            int i = 0;
            while (i < iLeft.size()) {
                int i1 = iLeft.elementAt(i);
                double f = fWeight * (double)fLeft.elementAt(i).floatValue();
                int j = 0;
                while (j < iRight.size()) {
                    int i2 = iRight.elementAt(j);
                    double f2 = f + fWeight * (double)fRight.elementAt(j).floatValue();
                    double[] dArray = fDistMatrix[i1];
                    int n = i2;
                    dArray[n] = dArray[n] + f2;
                    double[] dArray2 = fDistMatrix[i2];
                    int n2 = i1;
                    dArray2[n2] = dArray2[n2] + f2;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < fLeft.size()) {
                iLabel.add(iLeft.elementAt(i));
                fLength.add(Float.valueOf(fLeft.elementAt(i).floatValue() + node.m_fLength + 1.0f));
                ++i;
            }
            i = 0;
            while (i < fRight.size()) {
                iLabel.add(iRight.elementAt(i));
                fLength.add(Float.valueOf(fRight.elementAt(i).floatValue() + node.m_fLength + 1.0f));
                ++i;
            }
        }
    }

    public int[] buildClusterer(double[][] fDistance0) throws Exception {
        Vector[] nClusterID = new Vector[fDistance0.length];
        int i = 0;
        while (i < fDistance0.length) {
            nClusterID[i] = new Vector();
            nClusterID[i].add(i);
            ++i;
        }
        int nClusters = fDistance0.length;
        PriorityQueue<Tuple> queue = new PriorityQueue<Tuple>(nClusters * nClusters / 2, new TupleComparator());
        int i2 = 0;
        while (i2 < nClusters) {
            int j = i2 + 1;
            while (j < nClusters) {
                queue.add(new Tuple(fDistance0[i2][j], i2, j, 1, 1));
                ++j;
            }
            ++i2;
        }
        int nInstances = fDistance0.length;
        TreeNode[] clusterNodes = new TreeNode[nInstances];
        while (nClusters > 1) {
            Tuple t = null;
            while ((t = queue.poll()) != null && (nClusterID[t.m_iCluster1].size() != t.m_nClusterSize1 || nClusterID[t.m_iCluster2].size() != t.m_nClusterSize2)) {
            }
            int iMin1 = t.m_iCluster1;
            int iMin2 = t.m_iCluster2;
            nClusterID[iMin1].addAll(nClusterID[iMin2]);
            nClusterID[iMin2].removeAllElements();
            int i3 = 0;
            while (i3 < nInstances) {
                if (i3 != iMin1 && nClusterID[i3].size() > 0) {
                    int i1 = Math.min(iMin1, i3);
                    int i22 = Math.max(iMin1, i3);
                    double fDistance = this.getDistance(fDistance0, nClusterID[i1], nClusterID[i22]);
                    queue.add(new Tuple(fDistance, i1, i22, nClusterID[i1].size(), nClusterID[i22].size()));
                }
                ++i3;
            }
            TreeNode node = new TreeNode();
            if (clusterNodes[iMin1] == null) {
                node.m_iLeftInstance = iMin1;
                node.m_height = 1.0;
            } else {
                node.m_left = clusterNodes[iMin1];
                clusterNodes[iMin1].m_parent = node;
                node.m_height = clusterNodes[iMin1].m_height + 1.0;
            }
            if (clusterNodes[iMin2] == null) {
                node.m_iRightInstance = iMin2;
                node.m_height = Math.max(1.0, node.m_height);
            } else {
                node.m_right = clusterNodes[iMin2];
                clusterNodes[iMin2].m_parent = node;
                node.m_height = Math.max(clusterNodes[iMin2].m_height + 1.0, node.m_height);
            }
            clusterNodes[iMin1] = node;
            --nClusters;
        }
        TreeNode cluster = null;
        int i4 = 0;
        while (i4 < nInstances) {
            if (nClusterID[i4].size() > 0) {
                cluster = clusterNodes[i4];
                break;
            }
            ++i4;
        }
        int[] order = new int[nInstances];
        cluster.label(1);
        cluster.order(order, 0);
        double fScore = this.score(order, fDistance0);
        boolean bProgress = false;
        do {
            bProgress = false;
            ArrayList<Integer> label = new ArrayList<Integer>();
            List<List<Integer>> orderings = this.calcOrderings(cluster, label);
            double fBestScore = fScore;
            int iBestNode = -1;
            int i5 = 1;
            while (i5 < orderings.size()) {
                double fScore2 = this.score2(orderings.get(i5), fDistance0);
                if (fScore2 < fBestScore) {
                    fBestScore = fScore2;
                    iBestNode = (Integer)label.get(i5 - 1);
                }
                ++i5;
            }
            if (iBestNode < 0) continue;
            this.flip(iBestNode, cluster);
            fScore = fBestScore;
            bProgress = true;
            cluster.order(order, 0);
            double fScore2 = this.score(order, fDistance0);
            System.out.println(String.valueOf(Arrays.toString(order)) + " " + fScore + " " + fScore2);
        } while (bProgress);
        cluster.order(order, 0);
        return order;
    }

    private void flip(int iBestNode, TreeNode node) {
        if (node.m_left != null) {
            this.flip(iBestNode, node.m_left);
        }
        if (node.m_right != null) {
            this.flip(iBestNode, node.m_right);
        }
        if (iBestNode == node.m_iLabel) {
            int tmp = node.m_iLeftInstance;
            node.m_iLeftInstance = node.m_iRightInstance;
            node.m_iRightInstance = tmp;
            TreeNode tmp2 = node.m_left;
            node.m_left = node.m_right;
            node.m_right = tmp2;
        }
    }

    private List<List<Integer>> calcOrderings(TreeNode node, List<Integer> label) {
        ArrayList newList;
        List<List<Integer>> rightList;
        List<List<Integer>> leftList;
        ArrayList<List<Integer>> list;
        ArrayList<Integer> leftLabel = new ArrayList<Integer>();
        ArrayList<Integer> rightLabel = new ArrayList<Integer>();
        if (node.m_left == null) {
            list = new ArrayList<List<Integer>>();
            list.add((List<Integer>)node.m_iLeftInstance);
            leftList = new ArrayList<List<Integer>>();
            leftList.add(list);
        } else {
            leftList = this.calcOrderings(node.m_left, leftLabel);
        }
        if (node.m_right == null) {
            list = new ArrayList();
            list.add((List<Integer>)node.m_iRightInstance);
            rightList = new ArrayList<List<Integer>>();
            rightList.add(list);
        } else {
            rightList = this.calcOrderings(node.m_right, rightLabel);
        }
        list = new ArrayList();
        ArrayList newList2 = new ArrayList();
        newList2.addAll(leftList.get(0));
        newList2.addAll(rightList.get(0));
        list.add(newList2);
        int i = 1;
        while (i < leftList.size()) {
            newList = new ArrayList();
            newList.addAll(leftList.get(i));
            newList.addAll(rightList.get(0));
            list.add(newList);
            ++i;
        }
        i = 1;
        while (i < rightList.size()) {
            newList = new ArrayList();
            newList.addAll(leftList.get(0));
            newList.addAll(rightList.get(i));
            list.add(newList);
            ++i;
        }
        newList = new ArrayList();
        newList.addAll(rightList.get(0));
        newList.addAll(leftList.get(0));
        list.add(newList);
        label.addAll(leftLabel);
        label.addAll(rightLabel);
        label.add(node.m_iLabel);
        return list;
    }

    private double score2(List<Integer> list, double[][] fDistance0) {
        int[] order = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            order[list.get((int)i).intValue()] = i;
            ++i;
        }
        return this.score(order, fDistance0);
    }

    private double score(int[] order, double[][] fDistance0) {
        int K = order.length;
        double fSum = 0.0;
        int i = 0;
        while (i < order.length - 1) {
            int j = -K;
            while (j < 0) {
                if (i + j >= 0) {
                    fSum -= fDistance0[order[i]][order[i + j]] / (double)(j * j * j);
                }
                ++j;
            }
            j = 1;
            while (j <= K) {
                if (i + j < order.length) {
                    fSum += fDistance0[order[i]][order[i + j]] / (double)(j * j * j);
                }
                ++j;
            }
            ++i;
        }
        return fSum;
    }

    double getDistance(double[][] fDistance, Vector<Integer> cluster1, Vector<Integer> cluster2) {
        double fBestDist = Double.MAX_VALUE;
        switch (this.m_nLinkType) {
            case 0: {
                fBestDist = Double.MAX_VALUE;
                int i = 0;
                while (i < cluster1.size()) {
                    int i1 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i2 = cluster2.elementAt(j);
                        double fDist = fDistance[i1][i2];
                        if (fBestDist > fDist) {
                            fBestDist = fDist;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 6: {
                double fDist;
                int i2;
                int i1;
                fBestDist = 0.0;
                int i = 0;
                while (i < cluster1.size()) {
                    int i12 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i22 = cluster2.elementAt(j);
                        double fDist2 = fDistance[i12][i22];
                        if (fBestDist < fDist2) {
                            fBestDist = fDist2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.m_nLinkType == 1) break;
                double fMaxDist = 0.0;
                int i3 = 0;
                while (i3 < cluster1.size()) {
                    i1 = cluster1.elementAt(i3);
                    int j = i3 + 1;
                    while (j < cluster1.size()) {
                        i2 = cluster1.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (fMaxDist < fDist) {
                            fMaxDist = fDist;
                        }
                        ++j;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < cluster2.size()) {
                    i1 = cluster2.elementAt(i3);
                    int j = i3 + 1;
                    while (j < cluster2.size()) {
                        i2 = cluster2.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (fMaxDist < fDist) {
                            fMaxDist = fDist;
                        }
                        ++j;
                    }
                    ++i3;
                }
                fBestDist -= fMaxDist;
                break;
            }
            case 2: {
                fBestDist = 0.0;
                int i = 0;
                while (i < cluster1.size()) {
                    int i1 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i2 = cluster2.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                        ++j;
                    }
                    ++i;
                }
                fBestDist /= (double)(cluster1.size() * cluster2.size());
                break;
            }
            case 3: {
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                fBestDist = 0.0;
                int i = 0;
                while (i < merged.size()) {
                    int i1 = (Integer)merged.elementAt(i);
                    int j = i + 1;
                    while (j < merged.size()) {
                        int i2 = (Integer)merged.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                        ++j;
                    }
                    ++i;
                }
                int n = merged.size();
                fBestDist /= (double)n * ((double)n - 1.0) / 2.0;
            }
        }
        return fBestDist;
    }

    class TreeNode {
        TreeNode m_left;
        TreeNode m_right;
        TreeNode m_parent;
        int m_iLeftInstance;
        int m_iRightInstance;
        double m_height = 0.0;
        int m_iLabel = -1;

        TreeNode() {
        }

        int order(int[] order, int i) {
            if (this.m_left == null) {
                order[this.m_iLeftInstance] = i++;
            } else {
                i = this.m_left.order(order, i);
            }
            if (this.m_right == null) {
                order[this.m_iRightInstance] = i++;
            } else {
                i = this.m_right.order(order, i);
            }
            return i;
        }

        int label(int i) {
            if (this.m_left == null) {
                return i;
            }
            i = this.m_left.label(i) + 1;
            this.m_iLabel = i + 1;
            if (this.m_right == null) {
                return i;
            }
            i = this.m_right.label(i) + 1;
            this.m_iLabel = i + 1;
            return i;
        }
    }

    class Tuple {
        double m_fDist;
        int m_iCluster1;
        int m_iCluster2;
        int m_nClusterSize1;
        int m_nClusterSize2;

        public Tuple(double d, int i, int j, int nSize1, int nSize2) {
            this.m_fDist = d;
            this.m_iCluster1 = i;
            this.m_iCluster2 = j;
            this.m_nClusterSize1 = nSize1;
            this.m_nClusterSize2 = nSize2;
        }
    }

    class TupleComparator
    implements Comparator<Tuple> {
        TupleComparator() {
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            if (o1.m_fDist < o2.m_fDist) {
                return -1;
            }
            if (o1.m_fDist == o2.m_fDist) {
                return 0;
            }
            return 1;
        }
    }
}

