/*
 * Decompiled with CFR 0.152.
 */
package jam.demo;

import jam.demo.DemoFrame;
import jam.demo.DemoMenuBarFactory;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.DocumentFrameFactory;
import jam.framework.MenuBarFactory;
import jam.framework.MultiDocApplication;
import jam.preferences.PreferencesSection;
import jam.util.IconUtils;
import java.awt.Font;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DemoApplication
extends MultiDocApplication {
    public DemoApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon) {
        super(menuBarFactory, string, string2, icon);
        this.addPreferencesSection(new PreferencesSection(){
            Icon projectToolIcon = IconUtils.getIcon(this.getClass(), "images/prefsGeneral.png");
            JCheckBox generalCheck = new JCheckBox("General preference");

            public String getTitle() {
                return "General";
            }

            public Icon getIcon() {
                return this.projectToolIcon;
            }

            public JPanel getPanel() {
                JPanel jPanel = new JPanel();
                jPanel.add(this.generalCheck);
                return jPanel;
            }

            public void retrievePreferences() {
                Preferences preferences = Preferences.userNodeForPackage(DemoApplication.class);
                this.generalCheck.setSelected(preferences.getBoolean("general_check", true));
            }

            public void storePreferences() {
                Preferences preferences = Preferences.userNodeForPackage(DemoApplication.class);
                preferences.putBoolean("general_check", this.generalCheck.isSelected());
            }
        });
        this.addPreferencesSection(new PreferencesSection(){
            Icon projectToolIcon = IconUtils.getIcon(this.getClass(), "images/prefsAdvanced.png");
            JCheckBox advancedCheck = new JCheckBox("Advanced preference");

            public String getTitle() {
                return "Advanced";
            }

            public Icon getIcon() {
                return this.projectToolIcon;
            }

            public JPanel getPanel() {
                JPanel jPanel = new JPanel();
                jPanel.add(new JCheckBox("Advanced preference"));
                return jPanel;
            }

            public void retrievePreferences() {
                Preferences preferences = Preferences.userNodeForPackage(DemoApplication.class);
                this.advancedCheck.setSelected(preferences.getBoolean("advanced_check", true));
            }

            public void storePreferences() {
                Preferences preferences = Preferences.userNodeForPackage(DemoApplication.class);
                preferences.putBoolean("advanced_check", this.advancedCheck.isSelected());
            }
        });
    }

    public static void main(String[] stringArray) {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.textantialiasing", "on");
        System.setProperty("apple.awt.rendering", "VALUE_RENDER_SPEED");
        try {
            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            UIManager.put("SystemFont", new Font("Lucida Grande", 0, 13));
            UIManager.put("SmallSystemFont", new Font("Lucida Grande", 0, 11));
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        URL uRL = DemoApplication.class.getResource("/images/demo.png");
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        String string = "JAM Demo";
        String string2 = "JAM Demo\nVersion 1.0\n \nCopyright 2006 Andrew Rambaut\nUniversity of Edinburgh\nAll Rights Reserved.";
        DemoApplication demoApplication = new DemoApplication(new DemoMenuBarFactory(), string, string2, imageIcon);
        demoApplication.setDocumentFrameFactory(new DocumentFrameFactory(){

            public DocumentFrame createDocumentFrame(Application application, MenuBarFactory menuBarFactory) {
                return new DemoFrame("JAM Demo");
            }
        });
        demoApplication.initialize();
        if (stringArray.length > 0) {
            for (String string3 : stringArray) {
                demoApplication.doOpen(string3);
            }
        }
        if (demoApplication.getUpperDocumentFrame() == null) {
            demoApplication.doOpen();
        }
    }
}

