/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.PascalDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.MathUtils;

public class PascalDistributionImpl
extends AbstractIntegerDistribution
implements PascalDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public PascalDistributionImpl(int n, double d) {
        this.setNumberOfSuccessesInternal(n);
        this.setProbabilityOfSuccessInternal(d);
    }

    @Override
    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    @Override
    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    @Deprecated
    public void setNumberOfSuccesses(int n) {
        this.setNumberOfSuccessesInternal(n);
    }

    private void setNumberOfSuccessesInternal(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes must be non-negative ({0})", n);
        }
        this.numberOfSuccesses = n;
    }

    @Override
    @Deprecated
    public void setProbabilityOfSuccess(double d) {
        this.setProbabilityOfSuccessInternal(d);
    }

    private void setProbabilityOfSuccessInternal(double d) {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        this.probabilityOfSuccess = d;
    }

    @Override
    protected int getDomainLowerBound(double d) {
        return -1;
    }

    @Override
    protected int getDomainUpperBound(double d) {
        return 0x7FFFFFFE;
    }

    @Override
    public double cumulativeProbability(int n) throws MathException {
        double d = n < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, n + 1);
        return d;
    }

    @Override
    public double probability(int n) {
        double d = n < 0 ? 0.0 : MathUtils.binomialCoefficientDouble(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * Math.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * Math.pow(1.0 - this.probabilityOfSuccess, n);
        return d;
    }

    @Override
    public int inverseCumulativeProbability(double d) throws MathException {
        int n = d == 0.0 ? -1 : (d == 1.0 ? Integer.MAX_VALUE : super.inverseCumulativeProbability(d));
        return n;
    }
}

