/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.FDistribution;
import org.apache.commons.math.special.Beta;

public class FDistributionImpl
extends AbstractContinuousDistribution
implements FDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final String NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE = "degrees of freedom must be positive ({0})";
    private static final long serialVersionUID = -8516354193418641566L;
    private double numeratorDegreesOfFreedom;
    private double denominatorDegreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public FDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public FDistributionImpl(double d, double d2, double d3) {
        this.setNumeratorDegreesOfFreedomInternal(d);
        this.setDenominatorDegreesOfFreedomInternal(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    @Override
    public double density(double d) {
        double d2 = this.numeratorDegreesOfFreedom / 2.0;
        double d3 = this.denominatorDegreesOfFreedom / 2.0;
        double d4 = Math.log(d);
        double d5 = Math.log(this.numeratorDegreesOfFreedom);
        double d6 = Math.log(this.denominatorDegreesOfFreedom);
        double d7 = Math.log(this.numeratorDegreesOfFreedom * d + this.denominatorDegreesOfFreedom);
        return Math.exp(d2 * d5 + d2 * d4 - d4 + d3 * d6 - d2 * d7 - d3 * d7 - Beta.logBeta(d2, d3));
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        double d2;
        if (d <= 0.0) {
            d2 = 0.0;
        } else {
            double d3 = this.numeratorDegreesOfFreedom;
            double d4 = this.denominatorDegreesOfFreedom;
            d2 = Beta.regularizedBeta(d3 * d / (d4 + d3 * d), 0.5 * d3, 0.5 * d4);
        }
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double d) {
        double d2 = 1.0;
        double d3 = this.denominatorDegreesOfFreedom;
        if (d3 > 2.0) {
            d2 = d3 / (d3 - 2.0);
        }
        return d2;
    }

    @Override
    @Deprecated
    public void setNumeratorDegreesOfFreedom(double d) {
        this.setNumeratorDegreesOfFreedomInternal(d);
    }

    private void setNumeratorDegreesOfFreedomInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE, d);
        }
        this.numeratorDegreesOfFreedom = d;
    }

    @Override
    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    @Override
    @Deprecated
    public void setDenominatorDegreesOfFreedom(double d) {
        this.setDenominatorDegreesOfFreedomInternal(d);
    }

    private void setDenominatorDegreesOfFreedomInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE, d);
        }
        this.denominatorDegreesOfFreedom = d;
    }

    @Override
    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

