/*
 * Decompiled with CFR 0.152.
 */
package jam.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    private boolean scaled;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public static void printComponentScaled(Component c) {
        new PrintUtilities(c, true).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public PrintUtilities(Component componentToBePrinted, boolean scaled) {
        this(componentToBePrinted);
        this.scaled = scaled;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (this.scaled) {
            return this.printScaled(g, pageFormat, pageIndex);
        }
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public int printScaled(Graphics g, PageFormat pageFormat, int pageIndex) {
        return PrintUtilities.printScaled(this.componentToBePrinted, g, pageFormat, pageIndex);
    }

    public static int printScaled(Component componentToBePrinted, Graphics g, PageFormat pageFormat, int pageIndex) {
        double h1;
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        double x0 = pageFormat.getImageableX();
        double y0 = pageFormat.getImageableY();
        double w0 = pageFormat.getImageableWidth();
        double h0 = pageFormat.getImageableHeight();
        double w1 = componentToBePrinted.getWidth();
        double scale = w0 / w1 < h0 / (h1 = (double)componentToBePrinted.getHeight()) ? w0 / w1 : h0 / h1;
        g2d.translate(x0, y0);
        g2d.scale(scale, scale);
        PrintUtilities.disableDoubleBuffering(componentToBePrinted);
        componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

