/*
 * Decompiled with CFR 0.152.
 */
package jam.preferences;

import jam.preferences.PreferencesSection;
import jam.toolbar.Toolbar;
import jam.toolbar.ToolbarAction;
import jam.toolbar.ToolbarButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PreferencesDialog {
    private JFrame frame;
    private CardLayout cardLayout;
    private JPanel sectionsPanel;
    String currentSection = null;
    private List<PreferencesSection> sections = new ArrayList<PreferencesSection>();
    private Map<String, JPanel> buttons = new HashMap<String, JPanel>();

    public PreferencesDialog(JFrame frame) {
        this.frame = frame;
    }

    public void showDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        Toolbar toolbar = new Toolbar(null);
        toolbar.setFloatable(false);
        this.cardLayout = new CardLayout();
        this.sectionsPanel = new JPanel(this.cardLayout);
        this.sectionsPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.add((Component)toolbar, "North");
        panel.add((Component)this.sectionsPanel, "Center");
        JOptionPane optionPane = new JOptionPane(panel, -1, -1, null, new String[]{"Done"}, null);
        optionPane.setBorder(new EmptyBorder(0, 0, 12, 0));
        final JDialog dialog = optionPane.createDialog(this.frame, this.currentSection);
        for (PreferencesSection section : this.sections) {
            final String title = section.getTitle();
            if (this.currentSection == null) {
                this.currentSection = title;
            }
            ToolbarButton button = new ToolbarButton(new ToolbarAction(title, title, section.getIcon()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferencesDialog.this.showSection(title);
                    PreferencesDialog.this.currentSection = title;
                    dialog.setTitle(PreferencesDialog.this.currentSection);
                }
            });
            button.setFocusable(false);
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            buttonPanel.add((Component)button, "Center");
            toolbar.addComponent(buttonPanel);
            this.sectionsPanel.add((Component)section.getPanel(), title);
            this.buttons.put(title, buttonPanel);
            section.retrievePreferences();
        }
        toolbar.addFlexibleSpace();
        this.showSection(this.currentSection);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PreferencesDialog.this.storePreferences();
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
                PreferencesDialog.this.storePreferences();
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }

    public void storePreferences() {
        for (PreferencesSection section : this.sections) {
            section.storePreferences();
        }
    }

    public void showSection(String title) {
        this.cardLayout.show(this.sectionsPanel, title);
        JPanel buttonPanel = this.buttons.get(this.currentSection);
        if (buttonPanel != null) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            buttonPanel.setOpaque(false);
            buttonPanel = this.buttons.get(title);
            buttonPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, Color.gray));
            buttonPanel.setBackground(new Color(0.85f, 0.85f, 0.85f, 0.5f));
            buttonPanel.setOpaque(true);
            buttonPanel.repaint();
        }
    }

    public void addSection(PreferencesSection section) {
        this.sections.add(section);
    }
}

