/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.mac.Utils;
import jam.panels.SearchPanelListener;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchPanel
extends JPanel {
    private ArrayList listeners = new ArrayList();
    private boolean searchTextEmpty = true;
    private final String emptyLabel;
    private boolean continuousSearch;
    private final JButton findButton;
    private final JTextField searchText;
    private final JButton cancelButton;
    private JComboBox comboBox;

    public SearchPanel(String emptyLabel, boolean searchAsYouType) {
        this(emptyLabel, null, searchAsYouType);
    }

    public SearchPanel(String emptyLabel, final JPopupMenu popup, boolean searchAsYouType) {
        this.continuousSearch = searchAsYouType;
        if (Utils.isMacOSX() && Utils.getMacOSXMajorVersionNumber() >= 5) {
            this.emptyLabel = "";
            this.findButton = null;
            this.cancelButton = null;
            this.searchText = new JTextField();
            this.searchText.setColumns(12);
            this.searchText.putClientProperty("JTextField.variant", "search");
            this.searchText.putClientProperty("JTextField.Search.FindPopup", popup);
            this.searchText.putClientProperty("JTextField.Search.FindAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.searchTextChanged();
                }
            });
            this.searchText.putClientProperty("JTextField.Search.CancelAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.clearSearchText();
                }
            });
            this.add((Component)this.searchText, "Center");
        } else {
            this.emptyLabel = emptyLabel;
            Icon findIcon = IconUtils.getIcon(SearchPanel.class, "images/search/find.png");
            Icon findPopupIcon = IconUtils.getIcon(SearchPanel.class, "images/search/findPopup.png");
            Icon stopIcon = IconUtils.getIcon(SearchPanel.class, "images/search/stop.png");
            Icon stopRolloverIcon = IconUtils.getIcon(SearchPanel.class, "images/search/stopRollover.png");
            Icon stopPressedIcon = IconUtils.getIcon(SearchPanel.class, "images/search/stopPressed.png");
            this.setLayout(new BorderLayout(0, 0));
            if (popup != null) {
                popup.getSelectionModel().setSelectedIndex(0);
                this.findButton = new JButton(findPopupIcon);
                this.findButton.add(popup);
                this.findButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        Component comp = mouseEvent.getComponent();
                        popup.show(comp, 0, comp.getHeight());
                    }
                });
            } else {
                this.findButton = new JButton(findIcon);
                this.findButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchPanel.this.searchText.requestFocusInWindow();
                    }
                });
            }
            this.findButton.setPreferredSize(new Dimension(this.findButton.getIcon().getIconWidth(), this.findButton.getIcon().getIconHeight()));
            this.findButton.putClientProperty("JButton.buttonType", "toolbar");
            this.findButton.setBorderPainted(false);
            this.findButton.setOpaque(false);
            this.findButton.setContentAreaFilled(false);
            JPanel findPanel = new JPanel();
            findPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            findPanel.setOpaque(false);
            findPanel.add(this.findButton);
            this.searchText = new JTextField(emptyLabel);
            this.searchText.setForeground(Color.lightGray);
            this.searchText.setBorder(null);
            this.cancelButton = new JButton(stopIcon);
            this.cancelButton.setRolloverEnabled(true);
            this.cancelButton.setRolloverIcon(stopRolloverIcon);
            this.cancelButton.setPressedIcon(stopPressedIcon);
            this.cancelButton.setPreferredSize(new Dimension(stopIcon.getIconWidth(), stopIcon.getIconHeight()));
            this.cancelButton.putClientProperty("JButton.buttonType", "toolbar");
            this.cancelButton.setBorderPainted(false);
            this.cancelButton.setOpaque(false);
            this.cancelButton.setContentAreaFilled(false);
            JPanel cancelPanel = new JPanel();
            cancelPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            cancelPanel.setOpaque(false);
            cancelPanel.add(this.cancelButton);
            this.add((Component)findPanel, "West");
            this.add((Component)this.searchText, "Center");
            this.add((Component)cancelPanel, "East");
            this.setBackground(this.searchText.getBackground());
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
            this.setPreferredSize(new Dimension(120, 24));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.clearSearchText();
                    SearchPanel.this.checkSearchTextEmpty();
                }
            });
        }
        this.searchText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchPanel.this.searchTextEmpty) {
                    SearchPanel.this.searchText.setText("");
                    SearchPanel.this.searchText.setForeground(Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchPanel.this.checkSearchTextEmpty();
            }
        });
        this.searchText.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
            }
        });
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchPanel.this.searchTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchPanel.this.searchTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchPanel.this.searchTextChanged();
            }
        });
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index;
                if (!SearchPanel.this.searchTextEmpty) {
                    if (e.getKeyCode() == 10) {
                        if (!SearchPanel.this.continuousSearch) {
                            SearchPanel.this.fireSearchStarted();
                        }
                    } else if (e.getKeyCode() == 27) {
                        SearchPanel.this.clearSearchText();
                    }
                }
                if (e.getKeyCode() == 40 && SearchPanel.this.comboBox != null) {
                    index = SearchPanel.this.comboBox.getSelectedIndex();
                    if (index < SearchPanel.this.comboBox.getItemCount() - 1) {
                        ++index;
                    }
                    SearchPanel.this.comboBox.setSelectedIndex(index);
                    e.consume();
                }
                if (e.getKeyCode() == 38 && SearchPanel.this.comboBox != null) {
                    index = SearchPanel.this.comboBox.getSelectedIndex();
                    if (index > 0) {
                        --index;
                    }
                    SearchPanel.this.comboBox.setSelectedIndex(index);
                    e.consume();
                }
            }
        });
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    private void checkSearchTextEmpty() {
        String text = this.searchText.getText().trim();
        if (text.length() == 0) {
            this.searchTextEmpty = true;
        }
        if (this.searchTextEmpty) {
            this.searchText.setForeground(Color.lightGray);
            this.searchText.setText(this.emptyLabel);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.findButton != null) {
            this.findButton.setEnabled(enabled);
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.searchText.setToolTipText(text);
        if (this.findButton != null) {
            this.findButton.setToolTipText(text);
        }
    }

    public void setFindIcon(Icon icon) {
        if (this.findButton != null) {
            this.findButton.setIcon(icon);
        }
    }

    public void addSearchPanelListener(SearchPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeDataSourceListener(SearchPanelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.searchText.requestFocusInWindow();
    }

    public void removeAllDataSourceListeners() {
        this.listeners.clear();
    }

    private void clearSearchText() {
        this.searchText.setText("");
        this.searchTextChanged();
    }

    private void fireSearchStarted() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((SearchPanelListener)i.next()).searchStarted(this.searchText.getText());
        }
    }

    private void fireSearchStopped() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((SearchPanelListener)i.next()).searchStopped();
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox comboBox) {
        this.comboBox = comboBox;
        if (comboBox != null) {
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SearchPanel.this.requestFocusInWindow();
                    SearchPanel.this.searchTextChanged();
                }
            });
        }
    }

    private void searchTextChanged() {
        if (this.searchText.isFocusOwner()) {
            this.searchTextEmpty = this.searchText.getText().length() == 0;
        }
        this.fireSearchTextChanged();
    }

    public void fireSearchTextChanged() {
        if (this.searchTextEmpty) {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(false);
            }
            if (this.continuousSearch) {
                this.fireSearchStopped();
            }
        } else {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(true);
            }
            if (this.continuousSearch) {
                this.fireSearchStarted();
            }
        }
    }
}

