/*
 * Decompiled with CFR 0.152.
 */
package jam.demo;

import jam.demo.DemoFrame;
import jam.demo.DemoMenuBarFactory;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.DocumentFrameFactory;
import jam.framework.MenuBarFactory;
import jam.framework.MultiDocApplication;
import jam.preferences.PreferencesSection;
import jam.util.IconUtils;
import java.awt.Font;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DemoApplication
extends MultiDocApplication {
    public DemoApplication(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon) {
        super(menuBarFactory, nameString, aboutString, icon);
        this.addPreferencesSection(new PreferencesSection(){
            Icon projectToolIcon = IconUtils.getIcon(this.getClass(), "images/prefsGeneral.png");
            JCheckBox generalCheck = new JCheckBox("General preference");

            @Override
            public String getTitle() {
                return "General";
            }

            @Override
            public Icon getIcon() {
                return this.projectToolIcon;
            }

            @Override
            public JPanel getPanel() {
                JPanel panel = new JPanel();
                panel.add(this.generalCheck);
                return panel;
            }

            @Override
            public void retrievePreferences() {
                Preferences prefs = Preferences.userNodeForPackage(DemoApplication.class);
                this.generalCheck.setSelected(prefs.getBoolean("general_check", true));
            }

            @Override
            public void storePreferences() {
                Preferences prefs = Preferences.userNodeForPackage(DemoApplication.class);
                prefs.putBoolean("general_check", this.generalCheck.isSelected());
            }
        });
        this.addPreferencesSection(new PreferencesSection(){
            Icon projectToolIcon = IconUtils.getIcon(this.getClass(), "images/prefsAdvanced.png");
            JCheckBox advancedCheck = new JCheckBox("Advanced preference");

            @Override
            public String getTitle() {
                return "Advanced";
            }

            @Override
            public Icon getIcon() {
                return this.projectToolIcon;
            }

            @Override
            public JPanel getPanel() {
                JPanel panel = new JPanel();
                panel.add(new JCheckBox("Advanced preference"));
                return panel;
            }

            @Override
            public void retrievePreferences() {
                Preferences prefs = Preferences.userNodeForPackage(DemoApplication.class);
                this.advancedCheck.setSelected(prefs.getBoolean("advanced_check", true));
            }

            @Override
            public void storePreferences() {
                Preferences prefs = Preferences.userNodeForPackage(DemoApplication.class);
                prefs.putBoolean("advanced_check", this.advancedCheck.isSelected());
            }
        });
    }

    public static void main(String[] args) {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.textantialiasing", "on");
        System.setProperty("apple.awt.rendering", "VALUE_RENDER_SPEED");
        try {
            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            UIManager.put("SystemFont", new Font("Lucida Grande", 0, 13));
            UIManager.put("SmallSystemFont", new Font("Lucida Grande", 0, 11));
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        URL url = DemoApplication.class.getResource("/images/demo.png");
        ImageIcon icon = null;
        if (url != null) {
            icon = new ImageIcon(url);
        }
        String nameString = "JAM Demo";
        String aboutString = "JAM Demo\nVersion 1.0\n \nCopyright 2006 Andrew Rambaut\nUniversity of Edinburgh\nAll Rights Reserved.";
        DemoApplication app = new DemoApplication(new DemoMenuBarFactory(), nameString, aboutString, icon);
        app.setDocumentFrameFactory(new DocumentFrameFactory(){

            @Override
            public DocumentFrame createDocumentFrame(Application app, MenuBarFactory menuBarFactory) {
                return new DemoFrame("JAM Demo");
            }
        });
        app.initialize();
        if (args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                app.doOpen(arg);
                ++n2;
            }
        }
        if (app.getUpperDocumentFrame() == null) {
            app.doOpen();
        }
    }
}

