/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.BEASTVersion2;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.util.AddOnManager;
import beast.util.XMLParser;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLProducer
extends XMLParser {
    HashSet<BEASTInterface> isDone;
    Map<BEASTInterface, Set<String>> isInputsDone;
    HashSet<String> IDs;
    int indent;
    public static final String DEFAULT_NAMESPACE = "beast.core:beast.evolution.alignment:beast.evolution.tree.coalescent:beast.core.util:beast.evolution.nuc:beast.evolution.operators:beast.evolution.sitemodel:beast.evolution.substitutionmodel:beast.evolution.likelihood";
    String m_sXMLBeuatifyXSL = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns='http://www.w3.org/TR/xhtml1/strict'>\n\n<xsl:output method='xml' indent='yes'/>\n\n<xsl:template match='beast'>\n    <xsl:copy>\n        <xsl:apply-templates select='@*'/>\n        <xsl:text>&#x0a;&#x0a;&#x0a;    </xsl:text>\n        <xsl:apply-templates  select='//data[not(@idref)]' mode='copy'/>\n        <xsl:text>&#x0a;&#x0a;&#x0a;    </xsl:text>\n        <xsl:apply-templates select='//beast.tree[not(@idref)]' mode='copy'/>\n        <xsl:text>&#x0a;&#x0a;&#x0a;    </xsl:text>\n        <xsl:apply-templates select='//distribution[not(@idref) and not(ancestor::distribution)]' mode='copy'/>\n        <xsl:text>&#x0a;&#x0a;&#x0a;    </xsl:text>\n        <xsl:apply-templates select='node()'/>    \n    </xsl:copy>\n</xsl:template>\n\n<xsl:template match='*' mode='copy'>\n  <xsl:copy>\n    <xsl:attribute name='id'>\n         <xsl:value-of select='@id'/>\n    </xsl:attribute>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n<xsl:template match='data|beast.tree|distribution[not(ancestor::distribution)]'>\n    <xsl:copy>\n        <xsl:attribute name='idref'>\n            <xsl:choose>\n                <xsl:when test='@idref!=\"\"'><xsl:value-of select='@idref'/></xsl:when>\n                <xsl:otherwise><xsl:value-of select='@id'/></xsl:otherwise>\n            </xsl:choose>\n        </xsl:attribute>\n    <xsl:apply-templates select='@name'/>\n    </xsl:copy>\n</xsl:template>\n\n<xsl:template match='input'>\n    <xsl:element name='{@name}'>\t\t<xsl:apply-templates select='node()|@*[name()!=\"name\"]'/>\t</xsl:element>\n</xsl:template>\n<xsl:template match='log/log'>\n    <xsl:copy><xsl:apply-templates select='*[@*!=\"\"]'/> </xsl:copy>\n</xsl:template>\n\n\n<xsl:template match='@*|node()'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n</xsl:stylesheet>\n";
    String m_sIDRefReplacementXSL = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns='http://www.w3.org/TR/xhtml1/strict'>\n\n<xsl:output method='xml' indent='yes'/>\n\n<xsl:template match='beast'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n<xsl:template match='node()'>\n    <xsl:choose>\n    <xsl:when test='count(@idref)=1 and count(@name)=1 and count(@*)=2'>\n        <xsl:element name='{@name}'>\n            <xsl:attribute name='idref'>\n                <xsl:value-of select='@idref'/>\n            </xsl:attribute>\n        </xsl:element>\n    </xsl:when>\n    <xsl:when test='not(count(@idref)=1 and count(@*)=1)'>\n        <xsl:copy>\n           <xsl:apply-templates select='@*'/>\n\t\t    <xsl:for-each select='*'>\n                <xsl:if test='count(@idref)=1 and count(@*)=1'>\n                    <xsl:attribute name='{name()}'>@<xsl:value-of select='@idref'/></xsl:attribute>\n                </xsl:if>\n\t\t    </xsl:for-each>\n           <xsl:apply-templates/>\n        </xsl:copy>\n    </xsl:when>\n    </xsl:choose>\n</xsl:template>\n\n<xsl:template match='@*'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n</xsl:stylesheet>";
    String s = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns='http://www.w3.org/TR/xhtml1/strict'>\n\n<xsl:output method='xml' indent='yes'/>\n\n<xsl:template match='beast'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n<xsl:template match='node()'>\n    <xsl:if test='not(count(@idref)=1 and count(@*)=1)'>\n    <xsl:copy>\n       <xsl:apply-templates select='@*'/>\n\t\t<xsl:for-each select='*'>\n            <xsl:if test='count(@idref)=1 and count(@*)=1'>\n                <xsl:attribute name='{name()}'>@<xsl:value-of select='@idref'/></xsl:attribute>\n            </xsl:if>\n\t\t</xsl:for-each>\n       <xsl:apply-templates/>\n    </xsl:copy>\n    </xsl:if>\n</xsl:template>\n\n<xsl:template match='@*'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n</xsl:stylesheet>\n";
    String m_sSupressAlignmentXSL = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns='http://www.w3.org/TR/xhtml1/strict'>\n\n<xsl:output method='xml'/>\n\n<xsl:template match='data'/>\n\n<xsl:template match='input[@name]'>\n    <xsl:element name='{@name}'>\t\t<xsl:apply-templates select='node()|@*[name()!=\"name\"]'/>\t</xsl:element>\n</xsl:template>\n\n<xsl:template match='@*|node()'>\n  <xsl:copy>\n    <xsl:apply-templates select='@*|node()'/>\n  </xsl:copy>\n</xsl:template>\n\n</xsl:stylesheet>\n";

    public String toXML(BEASTInterface bEASTInterface) {
        return this.toXML(bEASTInterface, new ArrayList<BEASTInterface>());
    }

    public String toXML(BEASTInterface bEASTInterface, Collection<BEASTInterface> collection) {
        try {
            String string32;
            StringBuffer stringBuffer = new StringBuffer();
            Set<String> set = AddOnManager.getPackagesAndVersions(bEASTInterface);
            String string2 = set.toString();
            string2 = string2.substring(1, string2.length() - 1);
            string2 = string2.replaceAll(", ", ":");
            stringBuffer.append("<beast version='" + new BEASTVersion2().getMajorVersion() + "'" + " required='" + string2 + "'" + " namespace='" + DEFAULT_NAMESPACE + "'>\n");
            for (String string32 : element2ClassMap.keySet()) {
                if (reservedElements.contains(string32)) continue;
                stringBuffer.append("<map name='" + string32 + "'>" + (String)element2ClassMap.get(string32) + "</map>\n");
            }
            stringBuffer.append("\n\n");
            this.isDone = new HashSet();
            this.isInputsDone = new HashMap<BEASTInterface, Set<String>>();
            this.IDs = new HashSet();
            this.indent = 0;
            this.beastObjectToXML(bEASTInterface, stringBuffer, null, true);
            String string4 = "</beast>";
            stringBuffer.append(string4);
            String string5 = string32 = this.cleanUpXML(stringBuffer.toString(), this.m_sXMLBeuatifyXSL);
            string32 = this.findPlates(string5);
            String[] stringArray = DEFAULT_NAMESPACE.split(":");
            for (String charSequence2 : stringArray) {
                string32 = string32.replaceAll("spec=\"" + charSequence2 + ".", "spec=\"");
            }
            stringBuffer = new StringBuffer();
            if (collection.size() > 0) {
                for (BEASTInterface bEASTInterface2 : collection) {
                    if (this.IDs.contains(bEASTInterface2.getID())) continue;
                    this.beastObjectToXML(bEASTInterface2, stringBuffer, null, false);
                }
            }
            int n = string32.indexOf(string4);
            String string6 = stringBuffer.toString();
            string6 = string6.replaceAll("--", "- - ");
            string32 = string32.substring(0, n) + (String)string4;
            string32 = string32.replaceAll("xmlns=\"http://www.w3.org/TR/xhtml1/strict\"", "");
            string32 = this.dedupName(string32);
            string32 = this.sortTags(string32);
            int n2 = string32.indexOf("<data ");
            StringBuffer stringBuffer2 = new StringBuffer(string32);
            while (n2 > 0) {
                while (string32.charAt(n2) != '>') {
                    if (string32.charAt(n2) == ' ' && !string32.startsWith("idref", n2 + 1)) {
                        stringBuffer2.setCharAt(n2, '\n');
                    }
                    ++n2;
                }
                n2 = string32.indexOf("<data ", n2 + 1);
            }
            return stringBuffer2.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String sortTags(String string) {
        String[] stringArray = string.split("<");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            int n;
            int n2;
            int n3;
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split(">");
            boolean[] blArray = new boolean[stringArray2.length];
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].endsWith("/")) continue;
                blArray[j] = true;
                stringArray2[j] = stringArray2[j].substring(0, stringArray2[j].length() - 1);
            }
            String[] stringArray3 = this.split(stringArray2[0]);
            for (n3 = 0; n3 < stringArray3.length && !stringArray3[n3].startsWith("spec="); ++n3) {
            }
            for (n2 = 0; n2 < stringArray3.length && !stringArray3[n2].startsWith("id="); ++n2) {
            }
            stringBuilder.append('<');
            if (stringArray3[0] != null) {
                stringBuilder.append(stringArray3[0]);
            }
            if (n2 < stringArray3.length) {
                stringBuilder.append(' ');
                stringBuilder.append(stringArray3[n2]);
            }
            if (n3 < stringArray3.length) {
                stringBuilder.append(' ');
                stringBuilder.append(stringArray3[n3]);
            }
            for (n = 1; n < stringArray3.length; ++n) {
                if (n == n2 || n == n3) continue;
                stringBuilder.append(' ');
                if (stringArray3[n] == null) continue;
                stringBuilder.append(stringArray3[n]);
            }
            for (n = 1; n < stringArray2.length; ++n) {
                if (blArray[n - 1]) {
                    stringBuilder.append('/');
                }
                stringBuilder.append('>');
                stringBuilder.append(stringArray2[n]);
            }
            if (stringArray2.length != 1 || string2 == null || !string2.endsWith(">")) continue;
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                String string2 = stringBuilder.toString();
                if (string2.contains("='") && !string2.endsWith("'") || string2.contains("=\"") && !string2.endsWith("\"")) {
                    stringBuilder.append(c);
                    continue;
                }
                arrayList.add(string2);
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[0]);
    }

    String dedupName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        while (++n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(c);
                while ((c = string.charAt(++n)) != ' ' && c != '/' && c != '>') {
                    stringBuilder2.append(c);
                }
                if (c != '/' && c != '>') {
                    StringBuilder stringBuilder3;
                    StringBuilder stringBuilder4;
                    StringBuilder stringBuilder5 = new StringBuilder();
                    while ((c = string.charAt(++n)) != '=') {
                        stringBuilder5.append(c);
                    }
                    if (stringBuilder5.toString().equals("name")) {
                        ++n;
                        stringBuilder4 = new StringBuilder();
                        while ((c = string.charAt(++n)) != '\"') {
                            stringBuilder4.append(c);
                        }
                        stringBuilder3 = new StringBuilder();
                        if ((c = string.charAt(++n)) != '>') {
                            if (c == '/') {
                                stringBuilder3.append(c);
                            }
                            while ((c = string.charAt(++n)) != '=' && c != '/' && c != '>') {
                                stringBuilder3.append(c);
                            }
                        }
                        if (c != '/' && c != '>' && stringBuilder3.toString().equals("idref")) {
                            stringBuilder3.append(c);
                            stringBuilder3.append(string.charAt(++n));
                            while ((c = string.charAt(++n)) != '\"') {
                                stringBuilder3.append(c);
                            }
                            stringBuilder.append('<');
                            stringBuilder.append((CharSequence)stringBuilder4);
                            stringBuilder.append('=');
                            stringBuilder.append((CharSequence)stringBuilder3);
                            stringBuilder.append("/>");
                            while ((c = string.charAt(++n)) != '>') {
                            }
                            continue;
                        }
                        stringBuilder.append((CharSequence)stringBuilder2);
                        stringBuilder.append(' ');
                        stringBuilder.append((CharSequence)stringBuilder5);
                        stringBuilder.append("=\"");
                        stringBuilder.append((CharSequence)stringBuilder4);
                        stringBuilder.append('\"');
                        stringBuilder.append(' ');
                        stringBuilder.append((CharSequence)stringBuilder3);
                        stringBuilder.append(c);
                        continue;
                    }
                    if (stringBuilder5.toString().equals("idref")) {
                        stringBuilder5.append(c);
                        stringBuilder5.append(string.charAt(++n));
                        while ((c = string.charAt(++n)) != ' ' && c != '/' && c != '>') {
                            stringBuilder5.append(c);
                        }
                        if (c != '/' && c != '>') {
                            stringBuilder4 = new StringBuilder();
                            while ((c = string.charAt(++n)) != '=') {
                                stringBuilder4.append(c);
                            }
                            if (stringBuilder4.toString().equals("name")) {
                                ++n;
                                stringBuilder3 = new StringBuilder();
                                while ((c = string.charAt(++n)) != '\"') {
                                    stringBuilder3.append(c);
                                }
                                stringBuilder.append('<');
                                stringBuilder.append((CharSequence)stringBuilder3);
                                stringBuilder.append(' ');
                                stringBuilder.append((CharSequence)stringBuilder5);
                                stringBuilder.append("/>");
                                while ((c = string.charAt(++n)) != '>') {
                                }
                                continue;
                            }
                            stringBuilder.append((CharSequence)stringBuilder2);
                            stringBuilder.append(' ');
                            stringBuilder.append((CharSequence)stringBuilder5);
                            stringBuilder.append(' ');
                            stringBuilder.append((CharSequence)stringBuilder4);
                            stringBuilder.append(c);
                            continue;
                        }
                        stringBuilder.append((CharSequence)stringBuilder2);
                        stringBuilder.append(' ');
                        stringBuilder.append((CharSequence)stringBuilder5);
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append(' ');
                    stringBuilder.append((CharSequence)stringBuilder5);
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String modelToXML(BEASTInterface bEASTInterface) {
        try {
            String string;
            String string2 = this.toRawXML(bEASTInterface);
            String string3 = string = this.cleanUpXML(string2, this.m_sSupressAlignmentXSL);
            string = this.findPlates(string3);
            string = string.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "");
            string = string.replaceAll("\\n\\s*\\n", "\n");
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toRawXML(BEASTInterface bEASTInterface) {
        return this.toRawXML(bEASTInterface, null);
    }

    public String toRawXML(BEASTInterface bEASTInterface, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.isDone = new HashSet();
            this.isInputsDone = new HashMap<BEASTInterface, Set<String>>();
            this.IDs = new HashSet();
            this.indent = 0;
            this.beastObjectToXML(bEASTInterface, stringBuffer, string, false);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String stateNodeToXML(BEASTInterface bEASTInterface) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.isDone = new HashSet();
            this.IDs = new HashSet();
            this.indent = 0;
            this.beastObjectToXML(bEASTInterface, stringBuffer, null, false);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    String cleanUpXML(String string, String string2) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        StringReader stringReader = new StringReader(string);
        StreamSource streamSource = new StreamSource(stringReader);
        StringReader stringReader2 = new StringReader(string2);
        StreamSource streamSource2 = new StreamSource(stringReader2);
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource2);
        transformer.transform(streamSource, streamResult);
        String string3 = stringWriter.toString();
        return string3;
    }

    String findPlates(String string) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        this.doc.normalize();
        Node node = this.doc.getElementsByTagName("*").item(0);
        this.findPlates(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        DOMSource dOMSource = new DOMSource(this.doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    void findPlates(Node node) {
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() != 1) continue;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = n + 1; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                Node node3 = nodeList.item(i);
                if (this.comparable(node2, node3, ".p1", ".p" + (arrayList.size() + 2))) {
                    arrayList.add(node3);
                    continue;
                }
                i = nodeList.getLength();
            }
            if (arrayList.size() <= 0) continue;
        }
        nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            this.findPlates(nodeList.item(n));
        }
    }

    void makePlate(Node node, String string, String string2, String string3) {
        Element element = this.doc.createElement("plate");
        element.setAttribute("var", string2);
        element.setAttribute("range", string3);
        String string4 = node.getPreviousSibling().getTextContent();
        this.replace(node, string, string2);
        node.getParentNode().replaceChild(element, node);
        element.appendChild(this.doc.createTextNode(string4 + "  "));
        element.appendChild(node);
        element.appendChild(this.doc.createTextNode(string4));
    }

    void replace(Node node, String string, String string2) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                object = attr.getValue().replaceAll(string, "\\$\\(" + string2 + "\\)");
                attr.setValue((String)object);
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            this.replace((Node)object, string, string2);
        }
    }

    boolean comparable(Node node, Node node2, String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        if (!node.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        if (!node.getTextContent().trim().equals(node2.getTextContent().trim())) {
            return false;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        NamedNodeMap namedNodeMap2 = node2.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object3 = (Attr)namedNodeMap.item(i);
            String string3 = object3.getName();
            object2 = object3.getValue();
            object = namedNodeMap2.getNamedItem(string3);
            if (object == null) {
                return false;
            }
            String string4 = ((Attr)object).getValue();
            if (((String)object2).equals(string4) || ((String)(object2 = ((String)object2).replaceAll(string, "\\$\\(n\\)"))).equals(string4 = string4.replaceAll(string2, "\\$\\(n\\)"))) continue;
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        object3 = node2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() != 1) continue;
            object = object2.getNodeName();
            boolean bl = false;
            for (int j = 0; !bl && j < object3.getLength(); ++j) {
                Node node3 = object3.item(j);
                if (node3.getNodeType() != 1 || !((String)object).equals(node3.getNodeName())) continue;
                bl = this.comparable((Node)object2, node3, string, string2);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    void beastObjectToXML(BEASTInterface bEASTInterface, StringBuffer stringBuffer, String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        Object object;
        String string2 = "input";
        for (String string3 : element2ClassMap.keySet()) {
            object = (String)element2ClassMap.get(string3);
            clazz = Class.forName((String)object);
            if (!clazz.equals(bEASTInterface.getClass())) continue;
            string2 = string3;
        }
        if (bl) {
            string2 = "run";
        }
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append("    ");
        }
        ++this.indent;
        stringBuffer.append("<").append(string2);
        if (bEASTInterface.getID() == null) {
            String string4 = bEASTInterface.getClass().getName();
            if (string4.contains(".")) {
                string4 = string4.substring(string4.lastIndexOf(46) + 1);
            }
            if (this.IDs.contains(string4)) {
                int n = 1;
                while (this.IDs.contains(string4 + n)) {
                    ++n;
                }
                string4 = string4 + n;
            }
            bEASTInterface.setID(string4);
        }
        boolean bl2 = false;
        if (this.isDone.stream().anyMatch(bEASTInterface2 -> bEASTInterface2 == bEASTInterface)) {
            stringBuffer.append(" idref='" + this.normalise(bEASTInterface.getID()) + "'");
            bl2 = true;
        } else {
            if (bEASTInterface.getID() != null && !bEASTInterface.getID().equals("")) {
                String string5 = bEASTInterface.getID();
                this.uniqueID(string5, stringBuffer);
            }
            this.isDone.add(bEASTInterface);
        }
        String string6 = bEASTInterface.getClass().getName();
        if (!(bl2 || element2ClassMap.containsKey(string2) && ((String)element2ClassMap.get(string2)).equals(string6))) {
            stringBuffer.append(" spec='" + string6 + "'");
        }
        if (string != null && !string.equals(string2)) {
            stringBuffer.append(" name='" + string + "'");
        }
        if (!bl2) {
            Object object2;
            Object object3;
            object = bEASTInterface.listInputs();
            clazz = object.iterator();
            while (clazz.hasNext()) {
                object3 = (Input)clazz.next();
                object2 = ((Input)object3).get();
                this.inputToXML((Input<?>)object3, object2, bEASTInterface, stringBuffer, true);
            }
            clazz = new StringBuffer();
            object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (Input)object3.next();
                Object t = ((Input)object2).get();
                this.inputToXML((Input<?>)object2, t, bEASTInterface, (StringBuffer)((Object)clazz), false);
            }
            if (((StringBuffer)((Object)clazz)).length() == 0) {
                --this.indent;
                stringBuffer.append("/>\n");
            } else {
                if (((StringBuffer)((Object)clazz)).indexOf("<") >= 0) {
                    stringBuffer.append(">\n");
                    stringBuffer.append((StringBuffer)((Object)clazz));
                    --this.indent;
                    for (int i = 0; i < this.indent; ++i) {
                        stringBuffer.append("    ");
                    }
                } else {
                    stringBuffer.append(">");
                    stringBuffer.append(((StringBuffer)((Object)clazz)).toString().trim());
                    --this.indent;
                }
                stringBuffer.append("</" + string2 + ">\n");
            }
        } else {
            --this.indent;
            stringBuffer.append("/>\n");
        }
        if (this.indent < 2) {
            stringBuffer.append("\n");
        }
    }

    private void uniqueID(String string, StringBuffer stringBuffer) {
        if (this.IDs.contains(string)) {
            int n = 1;
            while (this.IDs.contains(string + n)) {
                ++n;
            }
            string = string + n;
        }
        stringBuffer.append(" id='" + this.normalise(string) + "'");
        this.IDs.add(string);
    }

    void inputToXML(Input<?> input, Object object, BEASTInterface bEASTInterface, StringBuffer stringBuffer, boolean bl) throws ClassNotFoundException {
        if (object != null) {
            if (object instanceof Map) {
                if (bl) {
                    Map map = (Map)object;
                    int n = 0;
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(map.keySet());
                    Collections.sort(arrayList);
                    for (String string : arrayList) {
                        n = Math.max(n, string.length());
                    }
                    for (String string : map.keySet()) {
                        stringBuffer.append("\n        " + string);
                        for (int i = string.length(); i < n; ++i) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append("=\"" + this.normalise(map.get(string).toString()) + "\"");
                    }
                }
                return;
            }
            if (input.getName().startsWith("*")) {
                return;
            }
            if (object instanceof List) {
                if (!bl) {
                    int n = 0;
                    List list = (List)object;
                    for (Object e : list) {
                        if (e instanceof BEASTInterface) {
                            this.beastObjectToXML((BEASTInterface)e, stringBuffer, input.getName(), false);
                            continue;
                        }
                        stringBuffer.append(e.toString());
                        if (++n >= list.size()) continue;
                        stringBuffer.append(' ');
                    }
                }
                return;
            }
            if (object instanceof BEASTInterface) {
                if (!object.equals(input.defaultValue)) {
                    if (bl && this.isDone.contains(object)) {
                        stringBuffer.append(" " + input.getName() + "='@" + this.normalise(((BEASTInterface)object).getID()) + "'");
                        if (!this.isInputsDone.containsKey(bEASTInterface)) {
                            this.isInputsDone.put(bEASTInterface, new HashSet());
                        }
                        this.isInputsDone.get(bEASTInterface).add(input.getName());
                    }
                    if (!(bl || this.isInputsDone.containsKey(bEASTInterface) && this.isInputsDone.get(bEASTInterface).contains(input.getName()))) {
                        this.beastObjectToXML((BEASTInterface)object, stringBuffer, input.getName(), false);
                    }
                }
                return;
            }
            if (!object.equals(input.defaultValue)) {
                String string = object.toString();
                if (bl) {
                    if (string.indexOf(10) < 0) {
                        stringBuffer.append(" " + input.getName() + "='" + this.normalise(object.toString()) + "'");
                    }
                } else if (string.indexOf(10) >= 0) {
                    for (int i = 0; i < this.indent; ++i) {
                        stringBuffer.append("    ");
                    }
                    if (input.getName().equals("value")) {
                        stringBuffer.append(this.normalise(object.toString()));
                    } else {
                        stringBuffer.append("<input name='" + input.getName() + "'>" + this.normalise(object.toString()) + "</input>\n");
                    }
                }
            }
            return;
        }
    }

    String normalise(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("'", "&apos;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

