/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.State;
import beast.core.parameter.RealParameter;
import beast.math.distributions.LogNormalDistributionModel;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.GammaDistributionImpl;

@Description(value="A class that produces a distribution chaining values in a parameter through the Gamma distribution. The value of a parameter is assumed to be Gamma distributed with mean as the previous value in the parameter. If useLogNormal is set, a log normal distribution is used instead of a Gamma. If a Jeffrey's prior is used, the first value is assumed to be distributed as 1/x, otherwise it is assumed to be uniform. Handy for population parameters. ")
public class MarkovChainDistribution
extends Distribution {
    public final Input<Boolean> isJeffreysInput = new Input<Boolean>("jeffreys", "use Jeffrey's prior (default false)", false);
    public final Input<Boolean> isReverseInput = new Input<Boolean>("reverse", "parameter in reverse (default false)", false);
    public final Input<Boolean> useLogInput = new Input<Boolean>("uselog", "use logarithm of parameter values (default false)", false);
    public final Input<Double> shapeInput = new Input<Double>("shape", "shape parameter of the Gamma distribution (default 1.0 = exponential distribution)  or precision parameter if the log normal is used.", 1.0);
    public final Input<RealParameter> parameterInput = new Input("parameter", "chain parameter to calculate distribution over", Input.Validate.REQUIRED);
    public final Input<Boolean> useLogNormalInput = new Input<Boolean>("useLogNormal", "use Log Normal distribution instead of Gamma (default false)", false);
    private RealParameter chainParameter = null;
    private boolean jeffreys = false;
    private boolean reverse = false;
    private boolean uselog = false;
    private double shape = 1.0;
    GammaDistribution gamma;
    LogNormalDistributionModel.LogNormalImpl logNormal;
    boolean useLogNormal;

    @Override
    public void initAndValidate() {
        this.reverse = this.isReverseInput.get();
        this.jeffreys = this.isJeffreysInput.get();
        this.uselog = this.useLogInput.get();
        this.shape = this.shapeInput.get();
        this.chainParameter = this.parameterInput.get();
        this.useLogNormal = this.useLogNormalInput.get();
        this.gamma = new GammaDistributionImpl(this.shape, 1.0);
        LogNormalDistributionModel logNormalDistributionModel = new LogNormalDistributionModel();
        logNormalDistributionModel.getClass();
        this.logNormal = logNormalDistributionModel.new LogNormalDistributionModel.LogNormalImpl(1.0, 1.0);
    }

    @Override
    public double calculateLogP() {
        this.logP = 0.0;
        if (this.jeffreys) {
            this.logP += -Math.log(this.getChainValue(0));
        }
        for (int i = 1; i < this.chainParameter.getDimension(); ++i) {
            double d;
            double d2 = this.getChainValue(i - 1);
            double d3 = this.getChainValue(i);
            if (this.useLogNormal) {
                d = 1.0 / this.shape;
                double d4 = Math.log(d2) - 0.5 * d * d;
                this.logNormal.setMeanAndStdDev(d4, d);
                this.logP += this.logNormal.logDensity(d3);
                continue;
            }
            d = d2 / this.shape;
            this.gamma.setBeta(d);
            this.logP += this.gamma.logDensity(d3);
        }
        return this.logP;
    }

    private double getChainValue(int n) {
        if (this.uselog) {
            return Math.log((Double)this.chainParameter.getValue(this.index(n)));
        }
        return (Double)this.chainParameter.getValue(this.index(n));
    }

    private int index(int n) {
        if (this.reverse) {
            return this.chainParameter.getDimension() - n - 1;
        }
        return n;
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }

    @Override
    public void sample(State state, Random random) {
    }
}

