/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.math.Binomial;
import beast.util.Randomizer;
import java.util.List;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;

public interface PopulationFunction
extends UnivariateRealFunction {
    public List<String> getParameterIds();

    public double getPopSize(double var1);

    public double getIntensity(double var1);

    public double getInverseIntensity(double var1);

    public double getIntegral(double var1, double var3);

    public double getThreshold();

    public static class Utils {
        private static double getInterval(double d, PopulationFunction populationFunction, int n, double d2) {
            double d3 = populationFunction.getIntensity(d2);
            double d4 = -Math.log(d) / Binomial.choose2(n) + d3;
            return populationFunction.getInverseIntensity(d4) - d2;
        }

        public static double getSimulatedInterval(PopulationFunction populationFunction, int n, double d) {
            double d2 = Randomizer.nextDouble();
            return Utils.getInterval(d2, populationFunction, n, d);
        }

        public static double getMedianInterval(PopulationFunction populationFunction, int n, double d) {
            return Utils.getInterval(0.5, populationFunction, n, d);
        }

        public static void testConsistency(PopulationFunction populationFunction, int n, double d) {
            double d2 = d / (double)n;
            for (int i = 0; i <= n; ++i) {
                double d3 = (double)i * d2;
                double d4 = populationFunction.getIntensity(d3);
                double d5 = populationFunction.getInverseIntensity(d4);
                if (!(Math.abs(d3 - d5) > 1.0E-12)) continue;
                throw new RuntimeException("Demographic model not consistent! error size = " + Math.abs(d3 - d5));
            }
        }
    }

    @Description(value="An implementation of a population size function beastObject.Also note that if you are dealing with a diploid population N0 will be the number of alleles, not the number of individuals.")
    public static abstract class Abstract
    extends CalculationNode
    implements PopulationFunction {
        RombergIntegrator numericalIntegrator = new RombergIntegrator();

        @Override
        public void initAndValidate() {
            this.prepare();
        }

        @Override
        public double getThreshold() {
            return 0.0;
        }

        @Override
        public double getIntegral(double d, double d2) {
            return this.getIntensity(d2) - this.getIntensity(d);
        }

        public double getNumericalIntegral(double d, double d2) {
            if (d > d2) {
                throw new RuntimeException("NumericalIntegration start > finish");
            }
            if (d == d2) {
                return 0.0;
            }
            try {
                return this.numericalIntegrator.integrate(this, d, d2);
            }
            catch (MaxIterationsExceededException maxIterationsExceededException) {
                throw new RuntimeException(maxIterationsExceededException);
            }
            catch (FunctionEvaluationException functionEvaluationException) {
                throw new RuntimeException(functionEvaluationException);
            }
        }

        public void prepare() {
        }

        @Override
        public double value(double d) {
            return 1.0 / this.getPopSize(d);
        }

        public double getLogDemographic(double d) {
            return Math.log(this.getPopSize(d));
        }
    }
}

