/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.Frequencies;
import beast.evolution.substitutionmodel.GeneralSubstitutionModel;
import java.lang.reflect.InvocationTargetException;

@Description(value="Transversion model of nucleotide evolution (variable transversion rates, equal transition rates).Rates that are not specified are assumed to be 1.")
public class TVM
extends GeneralSubstitutionModel {
    public final Input<RealParameter> rateACInput = new Input("rateAC", "substitution rate for A to C (default 1)");
    public final Input<RealParameter> rateATInput = new Input("rateAT", "substitution rate for A to T (default 1)");
    public final Input<RealParameter> rateCGInput = new Input("rateCG", "substitution rate for C to G (default 1)");
    public final Input<RealParameter> rateGTInput = new Input("rateGT", "substitution rate for G to T (default 1)");
    public final Input<RealParameter> rateTransitionsInput = new Input("rateTransitions", "substitution rate for A<->G and C<->T");
    RealParameter rateAC;
    RealParameter rateGT;
    RealParameter rateAT;
    RealParameter rateCG;
    RealParameter rateTransitions;

    public TVM() {
        this.ratesInput.setRule(Input.Validate.OPTIONAL);
        try {
            this.ratesInput.setValue(null, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void initAndValidate() {
        if (this.ratesInput.get() != null) {
            throw new IllegalArgumentException("the rates attribute should not be used. Use the individual rates rateAC, rateCG, etc, instead.");
        }
        this.frequencies = (Frequencies)this.frequenciesInput.get();
        this.updateMatrix = true;
        this.nrOfStates = this.frequencies.getFreqs().length;
        if (this.nrOfStates != 4) {
            throw new IllegalArgumentException("Frequencies has wrong size. Expected 4, but got " + this.nrOfStates);
        }
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.storedRelativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.rateAC = this.getParameter(this.rateACInput);
        this.rateAT = this.getParameter(this.rateATInput);
        this.rateCG = this.getParameter(this.rateCGInput);
        this.rateGT = this.getParameter(this.rateGTInput);
        this.rateTransitions = this.getParameter(this.rateTransitionsInput);
    }

    private RealParameter getParameter(Input<RealParameter> input) {
        if (input.get() != null) {
            return input.get();
        }
        return new RealParameter("1.0");
    }

    @Override
    protected void setupRelativeRates() {
        this.relativeRates[0] = this.rateAC.getValue();
        this.relativeRates[1] = this.rateTransitions.getValue();
        this.relativeRates[2] = this.rateAT.getValue();
        this.relativeRates[3] = this.rateAC.getValue();
        this.relativeRates[4] = this.rateCG.getValue();
        this.relativeRates[5] = this.rateTransitions.getValue();
        this.relativeRates[6] = this.rateTransitions.getValue();
        this.relativeRates[7] = this.rateCG.getValue();
        this.relativeRates[8] = this.rateGT.getValue();
        this.relativeRates[9] = this.rateAT.getValue();
        this.relativeRates[10] = this.rateTransitions.getValue();
        this.relativeRates[11] = this.rateGT.getValue();
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

