/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.StateNodeInitialiser;
import beast.evolution.speciation.CalibratedYuleModel;
import beast.evolution.speciation.CalibrationPoint;
import beast.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathException;

@Description(value="A tree compatible with a set of monophyletic clades and hard limits on the clade root.")
public class CalibratedYuleInitialTree
extends Tree
implements StateNodeInitialiser {
    public final Input<List<CalibrationPoint>> calibrationsInput = new Input("calibrations", "Set of calibrated nodes", new ArrayList(), Input.Validate.REQUIRED);

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.initStateNodes();
    }

    @Override
    public void initStateNodes() {
        Tree tree;
        List<CalibrationPoint> list = this.calibrationsInput.get();
        CalibratedYuleModel calibratedYuleModel = new CalibratedYuleModel();
        for (CalibrationPoint calibrationPoint : list) {
            calibratedYuleModel.setInputValue("calibrations", calibrationPoint);
        }
        calibratedYuleModel.setInputValue("tree", this);
        calibratedYuleModel.setInputValue("type", (Object)CalibratedYuleModel.Type.NONE);
        calibratedYuleModel.initAndValidate();
        try {
            tree = calibratedYuleModel.compatibleInitialTree();
        }
        catch (MathException mathException) {
            throw new IllegalArgumentException(mathException.getMessage());
        }
        ((Tree)this.m_initial.get()).assignFromWithoutID(tree);
    }

    @Override
    public void getInitialisedStateNodes(List<StateNode> list) {
        list.add((StateNode)this.m_initial.get());
    }
}

