/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.likelihood;

import beast.evolution.likelihood.ThreadedLikelihoodCore;
import java.util.List;

public class ThreadedBeerLikelihoodCore
extends ThreadedLikelihoodCore {
    protected int m_nStates;
    protected int m_nNodes;
    protected int m_nPatterns;
    protected int m_nPartialsSize;
    protected int m_nMatrixSize;
    protected int m_nMatrices;
    protected boolean m_bIntegrateCategories;
    protected double[][][] m_fPartials;
    protected int[][] m_iStates;
    protected double[][][] m_fMatrices;
    protected int[] m_iCurrentMatrices;
    protected int[] m_iStoredMatrices;
    protected int[] m_iCurrentPartials;
    protected int[] m_iStoredPartials;
    protected boolean m_bUseScaling = false;
    protected double[][][] m_fScalingFactors;
    private double m_fScalingThreshold = 1.0E-100;
    double SCALE = 2.0;
    int[] weights;
    double[] m_fPatternLogLikelihoods;
    List<Integer> m_iConstantPattern;
    double[][] m_fRootPartials;

    public ThreadedBeerLikelihoodCore(int n) {
        this.m_nStates = n;
    }

    protected void calculateStatesStatesPruning(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, double[] dArray3, int n, int n2) {
        for (int i = 0; i < this.m_nMatrices; ++i) {
            int n3 = this.m_nStates * n + this.m_nStates * i * this.m_nPatterns;
            for (int j = n; j < n2; ++j) {
                int n4;
                int n5 = nArray[j];
                int n6 = nArray2[j];
                int n7 = i * this.m_nMatrixSize;
                if (n5 < this.m_nStates && n6 < this.m_nStates) {
                    for (n4 = 0; n4 < this.m_nStates; ++n4) {
                        dArray3[n3] = dArray[n7 + n5] * dArray2[n7 + n6];
                        ++n3;
                        n7 += this.m_nStates;
                    }
                    continue;
                }
                if (n5 < this.m_nStates) {
                    for (n4 = 0; n4 < this.m_nStates; ++n4) {
                        dArray3[n3] = dArray[n7 + n5];
                        ++n3;
                        n7 += this.m_nStates;
                    }
                    continue;
                }
                if (n6 < this.m_nStates) {
                    for (n4 = 0; n4 < this.m_nStates; ++n4) {
                        dArray3[n3] = dArray2[n7 + n6];
                        ++n3;
                        n7 += this.m_nStates;
                    }
                    continue;
                }
                for (n4 = 0; n4 < this.m_nStates; ++n4) {
                    dArray3[n3] = 1.0;
                    ++n3;
                }
            }
        }
    }

    protected void calculateStatesPartialsPruning(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        for (int i = 0; i < this.m_nMatrices; ++i) {
            int n3;
            int n4 = n3 = this.m_nStates * n + this.m_nStates * i * this.m_nPatterns;
            for (int j = n; j < n2; ++j) {
                int n5;
                double d;
                int n6;
                int n7 = nArray[j];
                int n8 = i * this.m_nMatrixSize;
                if (n7 < this.m_nStates) {
                    for (n6 = 0; n6 < this.m_nStates; ++n6) {
                        double d2 = dArray[n8 + n7];
                        d = 0.0;
                        for (n5 = 0; n5 < this.m_nStates; ++n5) {
                            d += dArray3[n8] * dArray2[n3 + n5];
                            ++n8;
                        }
                        dArray4[n4] = d2 * d;
                        ++n4;
                    }
                    n3 += this.m_nStates;
                    continue;
                }
                for (n6 = 0; n6 < this.m_nStates; ++n6) {
                    d = 0.0;
                    for (n5 = 0; n5 < this.m_nStates; ++n5) {
                        d += dArray3[n8] * dArray2[n3 + n5];
                        ++n8;
                    }
                    dArray4[n4] = d;
                    ++n4;
                }
                n3 += this.m_nStates;
            }
        }
    }

    protected void calculatePartialsPartialsPruning(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, int n2) {
        for (int i = 0; i < this.m_nMatrices; ++i) {
            int n3;
            int n4 = n3 = this.m_nStates * n + this.m_nStates * i * this.m_nPatterns;
            for (int j = n; j < n2; ++j) {
                int n5 = i * this.m_nMatrixSize;
                for (int k = 0; k < this.m_nStates; ++k) {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int i2 = 0; i2 < this.m_nStates; ++i2) {
                        d2 += dArray2[n5] * dArray[n3 + i2];
                        d += dArray4[n5] * dArray3[n3 + i2];
                        ++n5;
                    }
                    dArray5[n4] = d2 * d;
                    ++n4;
                }
                n3 += this.m_nStates;
            }
        }
    }

    protected void calculateStatesStatesPruning(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, double[] dArray3, int[] nArray3, int n, int n2) {
        int n3 = this.m_nStates * n * this.m_nMatrices;
        for (int i = n; i < n2; ++i) {
            int n4;
            int n5 = nArray[i];
            int n6 = nArray2[i];
            int n7 = nArray3[i] * this.m_nMatrixSize;
            if (n5 < this.m_nStates && n6 < this.m_nStates) {
                for (n4 = 0; n4 < this.m_nStates; ++n4) {
                    dArray3[n3] = dArray[n7 + n5] * dArray2[n7 + n6];
                    ++n3;
                    n7 += this.m_nStates;
                }
                continue;
            }
            if (n5 < this.m_nStates) {
                for (n4 = 0; n4 < this.m_nStates; ++n4) {
                    dArray3[n3] = dArray[n7 + n5];
                    ++n3;
                    n7 += this.m_nStates;
                }
                continue;
            }
            if (n6 < this.m_nStates) {
                for (n4 = 0; n4 < this.m_nStates; ++n4) {
                    dArray3[n3] = dArray2[n7 + n6];
                    ++n3;
                    n7 += this.m_nStates;
                }
                continue;
            }
            for (n4 = 0; n4 < this.m_nStates; ++n4) {
                dArray3[n3] = 1.0;
                ++n3;
            }
        }
    }

    protected void calculateStatesPartialsPruning(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = n3 = this.m_nStates * n * this.m_nMatrices;
        for (int i = n; i < n2; ++i) {
            int n5;
            double d;
            int n6;
            int n7 = nArray[i];
            int n8 = nArray2[i] * this.m_nMatrixSize;
            if (n7 < this.m_nStates) {
                for (n6 = 0; n6 < this.m_nStates; ++n6) {
                    double d2 = dArray[n8 + n7];
                    d = 0.0;
                    for (n5 = 0; n5 < this.m_nStates; ++n5) {
                        d += dArray3[n8] * dArray2[n4 + n5];
                        ++n8;
                    }
                    dArray4[n3] = d2 * d;
                    ++n3;
                }
                n4 += this.m_nStates;
                continue;
            }
            for (n6 = 0; n6 < this.m_nStates; ++n6) {
                d = 0.0;
                for (n5 = 0; n5 < this.m_nStates; ++n5) {
                    d += dArray3[n8] * dArray2[n4 + n5];
                    ++n8;
                }
                dArray4[n3] = d;
                ++n3;
            }
            n4 += this.m_nStates;
        }
    }

    protected void calculatePartialsPartialsPruning(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int[] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = this.m_nStates * n * this.m_nMatrices;
        for (int i = n; i < n2; ++i) {
            int n5 = nArray[i] * this.m_nMatrixSize;
            for (int j = 0; j < this.m_nStates; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                for (int k = 0; k < this.m_nStates; ++k) {
                    d2 += dArray2[n5] * dArray[n4 + k];
                    d += dArray4[n5] * dArray3[n4 + k];
                    ++n5;
                }
                dArray5[n3] = d2 * d;
                ++n3;
            }
            n4 += this.m_nStates;
        }
    }

    protected void calculateIntegratePartials(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        int n4;
        int n5 = n * this.m_nStates;
        int n6 = n * this.m_nStates;
        for (n4 = n; n4 < n2; ++n4) {
            for (n3 = 0; n3 < this.m_nStates; ++n3) {
                dArray3[n5] = dArray[n6] * dArray2[0];
                ++n5;
                ++n6;
            }
        }
        for (n4 = 1; n4 < this.m_nMatrices; ++n4) {
            n5 = n * this.m_nStates;
            n6 = n * this.m_nStates + n4 * this.m_nPatterns * this.m_nStates;
            for (n3 = n; n3 < n2; ++n3) {
                for (int i = 0; i < this.m_nStates; ++i) {
                    int n7 = n5++;
                    dArray3[n7] = dArray3[n7] + dArray[n6] * dArray2[n4];
                    ++n6;
                }
            }
        }
    }

    public void calculateLogLikelihoods(int n, double[] dArray, int n2, int n3) {
        double[] dArray2 = this.m_fRootPartials[n];
        int n4 = this.m_nStates * n2;
        for (int i = n2; i < n3; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.m_nStates; ++j) {
                d += dArray[j] * dArray2[n4];
                ++n4;
            }
            this.m_fPatternLogLikelihoods[i] = Math.log(d) + this.getLogScalingFactor(i);
        }
    }

    @Override
    public void initialize(int n, int n2, int n3, int[] nArray, List<Integer> list, int n4, boolean bl) {
        this.weights = nArray;
        this.m_iConstantPattern = list;
        this.m_nNodes = n;
        this.m_nPatterns = n2;
        this.m_nMatrices = n3;
        this.m_bIntegrateCategories = bl;
        this.m_nPartialsSize = bl ? n2 * this.m_nStates * n3 : n2 * this.m_nStates;
        this.m_fPartials = new double[2][n][];
        this.m_iCurrentMatrices = new int[n];
        this.m_iStoredMatrices = new int[n];
        this.m_iCurrentPartials = new int[n];
        this.m_iStoredPartials = new int[n];
        this.m_iStates = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.m_fPartials[0][i] = null;
            this.m_fPartials[1][i] = null;
            this.m_iStates[i] = null;
        }
        this.m_nMatrixSize = this.m_nStates * this.m_nStates;
        this.m_fMatrices = new double[2][n][n3 * this.m_nMatrixSize];
        this.m_fPatternLogLikelihoods = new double[n2];
        this.m_fRootPartials = new double[n4][n2 * this.m_nStates];
    }

    @Override
    public void finalize() throws Throwable {
        this.m_nNodes = 0;
        this.m_nPatterns = 0;
        this.m_nMatrices = 0;
        this.m_fPartials = null;
        this.m_iCurrentPartials = null;
        this.m_iStoredPartials = null;
        this.m_iStates = null;
        this.m_fMatrices = null;
        this.m_iCurrentMatrices = null;
        this.m_iStoredMatrices = null;
        this.m_fScalingFactors = null;
    }

    @Override
    public void setUseScaling(double d) {
        boolean bl = this.m_bUseScaling = Math.abs(d - 1.0) < 1.0E-10;
        if (this.m_bUseScaling) {
            this.m_fScalingFactors = new double[2][this.m_nNodes][this.m_nPatterns];
        }
    }

    @Override
    public void createNodePartials(int n) {
        this.m_fPartials[0][n] = new double[this.m_nPartialsSize];
        this.m_fPartials[1][n] = new double[this.m_nPartialsSize];
    }

    @Override
    public void setNodePartials(int n, double[] dArray) {
        if (this.m_fPartials[0][n] == null) {
            this.createNodePartials(n);
        }
        if (dArray.length < this.m_nPartialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.m_nMatrices; ++i) {
                System.arraycopy(dArray, 0, this.m_fPartials[0][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.m_fPartials[0][n], 0, dArray.length);
        }
    }

    @Override
    public void getNodePartials(int n, double[] dArray) {
        System.arraycopy(this.m_fPartials[this.m_iCurrentPartials[n]][n], 0, dArray, 0, dArray.length);
    }

    public void createNodeStates(int n) {
        this.m_iStates[n] = new int[this.m_nPatterns];
    }

    @Override
    public void setNodeStates(int n, int[] nArray) {
        if (this.m_iStates[n] == null) {
            this.createNodeStates(n);
        }
        System.arraycopy(nArray, 0, this.m_iStates[n], 0, this.m_nPatterns);
    }

    public void getNodeStates(int n, int[] nArray) {
        System.arraycopy(this.m_iStates[n], 0, nArray, 0, this.m_nPatterns);
    }

    @Override
    public void setNodeMatrixForUpdate(int n) {
        this.m_iCurrentMatrices[n] = 1 - this.m_iCurrentMatrices[n];
    }

    @Override
    public void setNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(dArray, 0, this.m_fMatrices[this.m_iCurrentMatrices[n]][n], n2 * this.m_nMatrixSize, this.m_nMatrixSize);
    }

    public void setPaddedNodeMatrices(int n, double[] dArray) {
        System.arraycopy(dArray, 0, this.m_fMatrices[this.m_iCurrentMatrices[n]][n], 0, this.m_nMatrices * this.m_nMatrixSize);
    }

    public void getNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(this.m_fMatrices[this.m_iCurrentMatrices[n]][n], n2 * this.m_nMatrixSize, dArray, 0, this.m_nMatrixSize);
    }

    public void setCurrentNodePartials(int n, double[] dArray) {
        if (dArray.length < this.m_nPartialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.m_nMatrices; ++i) {
                System.arraycopy(dArray, 0, this.m_fPartials[this.m_iCurrentPartials[n]][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.m_fPartials[this.m_iCurrentPartials[n]][n], 0, dArray.length);
        }
    }

    @Override
    public void calculateAllPartials(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            this.calculatePartials(nArray[i], nArray2[i], nArray3[i], n2, n3);
        }
    }

    @Override
    public void calculatePartials(int n, int n2, int n3, int n4, int n5) {
        this.m_iCurrentPartials[n3] = 1 - this.m_iStoredPartials[n3];
        if (this.m_iStates[n] != null) {
            if (this.m_iStates[n2] != null) {
                this.calculateStatesStatesPruning(this.m_iStates[n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_iStates[n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], n4, n5);
            } else {
                this.calculateStatesPartialsPruning(this.m_iStates[n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n2]][n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], n4, n5);
            }
        } else if (this.m_iStates[n2] != null) {
            this.calculateStatesPartialsPruning(this.m_iStates[n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n]][n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], n4, n5);
        } else {
            this.calculatePartialsPartialsPruning(this.m_fPartials[this.m_iCurrentPartials[n]][n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n2]][n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], n4, n5);
        }
        if (this.m_bUseScaling) {
            this.scalePartials(n3, n4, n5);
        }
    }

    public void calculatePartials(int n, int n2, int n3, int[] nArray, int n4, int n5) {
        if (this.m_iStates[n] != null) {
            if (this.m_iStates[n2] != null) {
                this.calculateStatesStatesPruning(this.m_iStates[n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_iStates[n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], nArray, n4, n5);
            } else {
                this.calculateStatesPartialsPruning(this.m_iStates[n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n2]][n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], nArray, n4, n5);
            }
        } else if (this.m_iStates[n2] != null) {
            this.calculateStatesPartialsPruning(this.m_iStates[n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n]][n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], nArray, n4, n5);
        } else {
            this.calculatePartialsPartialsPruning(this.m_fPartials[this.m_iCurrentPartials[n]][n], this.m_fMatrices[this.m_iCurrentMatrices[n]][n], this.m_fPartials[this.m_iCurrentPartials[n2]][n2], this.m_fMatrices[this.m_iCurrentMatrices[n2]][n2], this.m_fPartials[this.m_iCurrentPartials[n3]][n3], nArray, n4, n5);
        }
        if (this.m_bUseScaling) {
            this.scalePartials(n3, n4, n5);
        }
    }

    public void integratePartials(int n, double[] dArray, int n2, int n3, int n4) {
        double[] dArray2 = this.m_fRootPartials[n2];
        this.calculateIntegratePartials(this.m_fPartials[this.m_iCurrentPartials[n]][n], dArray, dArray2, n3, n4);
    }

    protected void scalePartials(int n, int n2, int n3) {
        int n4 = this.m_nStates * n2;
        for (int i = n2; i < n3; ++i) {
            int n5;
            int n6;
            double d = 0.0;
            int n7 = n4;
            for (n6 = 0; n6 < this.m_nMatrices; ++n6) {
                for (n5 = 0; n5 < this.m_nStates; ++n5) {
                    if (this.m_fPartials[this.m_iCurrentPartials[n]][n][n7] > d) {
                        d = this.m_fPartials[this.m_iCurrentPartials[n]][n][n7];
                    }
                    ++n7;
                }
                n7 += (this.m_nPatterns - 1) * this.m_nStates;
            }
            if (d < this.m_fScalingThreshold) {
                n7 = n4;
                for (n6 = 0; n6 < this.m_nMatrices; ++n6) {
                    for (n5 = 0; n5 < this.m_nStates; ++n5) {
                        double[] dArray = this.m_fPartials[this.m_iCurrentPartials[n]][n];
                        int n8 = n7++;
                        dArray[n8] = dArray[n8] / d;
                    }
                    n7 += (this.m_nPatterns - 1) * this.m_nStates;
                }
                this.m_fScalingFactors[this.m_iCurrentPartials[n]][n][i] = Math.log(d);
            } else {
                this.m_fScalingFactors[this.m_iCurrentPartials[n]][n][i] = 0.0;
            }
            n4 += this.m_nStates;
        }
    }

    @Override
    public double getLogScalingFactor(int n) {
        double d = 0.0;
        if (this.m_bUseScaling) {
            for (int i = 0; i < this.m_nNodes; ++i) {
                d += this.m_fScalingFactors[this.m_iCurrentPartials[i]][i][n];
            }
        }
        return d;
    }

    public void getPartials(int n, double[] dArray) {
        double[] dArray2 = this.m_fPartials[this.m_iCurrentPartials[n]][n];
        System.arraycopy(dArray2, 0, dArray, 0, this.m_nPartialsSize);
    }

    @Override
    public void restore() {
        int[] nArray = this.m_iCurrentMatrices;
        this.m_iCurrentMatrices = this.m_iStoredMatrices;
        this.m_iStoredMatrices = nArray;
        int[] nArray2 = this.m_iCurrentPartials;
        this.m_iCurrentPartials = this.m_iStoredPartials;
        this.m_iStoredPartials = nArray2;
    }

    @Override
    public void unstore() {
        System.arraycopy(this.m_iStoredMatrices, 0, this.m_iCurrentMatrices, 0, this.m_nNodes);
        System.arraycopy(this.m_iStoredPartials, 0, this.m_iCurrentPartials, 0, this.m_nNodes);
    }

    @Override
    public void store() {
        System.arraycopy(this.m_iCurrentMatrices, 0, this.m_iStoredMatrices, 0, this.m_nNodes);
        System.arraycopy(this.m_iCurrentPartials, 0, this.m_iStoredPartials, 0, this.m_nNodes);
    }

    @Override
    public double calcPartialLogP(int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += this.m_fPatternLogLikelihoods[i] * (double)this.weights[i];
        }
        return d;
    }

    @Override
    public double[] getPatternLogLikelihoods() {
        return this.m_fPatternLogLikelihoods;
    }

    void calcInvarCorrection(double d, int n) {
        double[] dArray = this.m_fRootPartials[n];
        for (int n2 : this.m_iConstantPattern) {
            if (dArray[n2] == 0.0) continue;
            int n3 = n2;
            dArray[n3] = dArray[n3] + d;
        }
    }

    @Override
    double calcLogP(int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, int n4, int n5, double[] dArray, double d, double[] dArray2) {
        this.calculateAllPartials(nArray, nArray2, nArray3, n2, n3, n4);
        this.integratePartials(n5, dArray, n, n3, n4);
        if (this.m_iConstantPattern != null) {
            this.calcInvarCorrection(d, n);
        }
        this.calculateLogLikelihoods(n, dArray2, n3, n4);
        double d2 = this.calcPartialLogP(n3, n4);
        return d2;
    }
}

