/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.branchratemodel;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.math.statistic.DiscreteStatistics;
import java.io.PrintStream;

@Description(value="A statistic that tracks the mean, variance and coefficent of variation of rates. It has three dimensions, one for each statistic.")
public class RateStatistic
extends BEASTObject
implements Loggable,
Function {
    public final Input<GenericTreeLikelihood> likelihoodInput = new Input("treeLikelihood", "TreeLikelihood containing branch rate model that provides rates for a tree");
    public final Input<BranchRateModel> branchRateModelInput = new Input("branchratemodel", "model that provides rates for a tree", Input.Validate.XOR, this.likelihoodInput);
    public final Input<Tree> treeInput = new Input("tree", "tree for which the rates apply");
    public final Input<Boolean> internalInput = new Input<Boolean>("internal", "consider internal nodes, default true", true);
    public final Input<Boolean> externalInput = new Input<Boolean>("external", "consider external nodes, default true", true);
    private Tree tree = null;
    private BranchRateModel branchRateModel = null;
    private boolean internal = true;
    private boolean external = true;
    static final int MEAN = 0;
    static final int VARIANCE = 1;
    static final int COEFFICIENT_OF_VARIATION = 2;

    @Override
    public void initAndValidate() {
        this.tree = this.treeInput.get();
        this.branchRateModel = this.branchRateModelInput.get();
        if (this.branchRateModel == null) {
            this.branchRateModel = this.likelihoodInput.get().branchRateModelInput.get();
        }
        this.internal = this.internalInput.get();
        this.external = this.externalInput.get();
    }

    public double[] calcValues() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.tree.getLeafNodeCount();
        if (this.external) {
            n2 += n4;
        }
        if (this.internal) {
            n2 += this.tree.getInternalNodeCount() - 1;
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        Node[] nodeArray = this.tree.getNodesAsArray();
        if (this.external) {
            for (n = 0; n < n4; ++n) {
                Node node = nodeArray[n];
                Node node2 = node.getParent();
                dArray2[n] = node2.getHeight() - node.getHeight();
                dArray[n] = this.branchRateModel.getRateForBranch(node);
            }
            n3 = n4;
        }
        if (this.internal) {
            n = this.tree.getNodeCount();
            int n5 = n3;
            for (int i = n4; i < n; ++i) {
                Node node = nodeArray[i];
                if (node.isRoot()) continue;
                Node node3 = node.getParent();
                dArray2[n5] = node3.getHeight() - node.getHeight();
                dArray[n5] = this.branchRateModel.getRateForBranch(node);
                ++n5;
            }
        }
        double[] dArray3 = new double[3];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
            d2 += dArray2[i];
        }
        dArray3[0] = d / d2;
        dArray3[1] = DiscreteStatistics.variance(dArray);
        double d3 = DiscreteStatistics.mean(dArray);
        dArray3[2] = Math.sqrt(DiscreteStatistics.variance(dArray, d3)) / d3;
        return dArray3;
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double getArrayValue() {
        return this.calcValues()[0];
    }

    @Override
    public double getArrayValue(int n) {
        if (n > 3) {
            throw new IllegalArgumentException();
        }
        return this.calcValues()[n];
    }

    @Override
    public void init(PrintStream printStream) {
        String string = this.getID();
        if (string == null) {
            string = "";
        }
        printStream.print(string + ".mean\t" + string + ".variance\t" + string + ".coefficientOfVariation\t");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        double[] dArray = this.calcValues();
        printStream.print(dArray[0] + "\t" + dArray[1] + "\t" + dArray[2] + "\t");
    }

    @Override
    public void close(PrintStream printStream) {
    }
}

