/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.IntegerParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.datatype.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Description(value="Alignment based on a filter operation on another alignment")
public class FilteredAlignment
extends Alignment {
    public final Input<String> filterInput = new Input("filter", "specifies which of the sites in the input alignment should be selected First site is 1.Filter specs are comma separated, either a singleton, a range [from]-[to] or iteration [from]:[to]:[step]; 1-100 defines a range, 1-100\u0003 or 1:100:3 defines every third in range 1-100, 1::3,2::3 removes every third site. Default for range [1]-[last site], default for iterator [1]:[last site]:[1]", Input.Validate.REQUIRED);
    public final Input<Alignment> alignmentInput = new Input("data", "alignment to be filtered", Input.Validate.REQUIRED);
    public final Input<IntegerParameter> constantSiteWeightsInput = new Input("constantSiteWeights", "if specified, constant sites will be added with weights specified by the input. The dimension and order of weights must match the datatype. For example for nucleotide data, a 4 dimensional parameter with weights for A, C, G and T respectively need to be specified.");
    int[] from;
    int[] to;
    int[] step;
    int[] filter;
    boolean convertDataType = false;

    public FilteredAlignment() {
        this.sequenceInput.setRule(Input.Validate.OPTIONAL);
        this.siteWeightsInput.setRule(Input.Validate.FORBIDDEN);
    }

    @Override
    public void initAndValidate() {
        this.parseFilterSpec();
        this.calcFilter();
        Alignment alignment = this.alignmentInput.get();
        this.m_dataType = alignment.m_dataType;
        if (this.userDataTypeInput.get() != null) {
            this.m_dataType = (DataType)this.userDataTypeInput.get();
            this.convertDataType = true;
        }
        if (this.constantSiteWeightsInput.get() != null && this.constantSiteWeightsInput.get().getDimension() != this.m_dataType.getStateCount()) {
            throw new IllegalArgumentException("constantSiteWeights should be of the same dimension as the datatype (" + this.constantSiteWeightsInput.get().getDimension() + "!=" + this.m_dataType.getStateCount() + ")");
        }
        this.counts = alignment.getCounts();
        this.taxaNames = alignment.taxaNames;
        this.stateCounts = alignment.stateCounts;
        if (this.convertDataType && this.m_dataType.getStateCount() > 0) {
            for (int i = 0; i < this.stateCounts.size(); ++i) {
                this.stateCounts.set(i, this.m_dataType.getStateCount());
            }
        }
        if (this.alignmentInput.get().siteWeightsInput.get() != null) {
            String string = this.alignmentInput.get().siteWeightsInput.get().trim();
            String[] stringArray = string.split(",");
            this.siteWeights = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.siteWeights[i] = Integer.parseInt(stringArray[i].trim());
            }
        }
        this.calcPatterns();
        this.setupAscertainment();
    }

    private void parseFilterSpec() {
        String string = this.filterInput.get();
        String[] stringArray = string.split(",");
        this.from = new int[stringArray.length];
        this.to = new int[stringArray.length];
        this.step = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            string = " " + stringArray[i] + " ";
            if (string.matches(".*-.*")) {
                if (string.indexOf(92) >= 0) {
                    object = string.substring(string.indexOf(92) + 1);
                    this.step[i] = this.parseInt((String)object, 1);
                    string = string.substring(0, string.indexOf(92));
                } else {
                    this.step[i] = 1;
                }
                object = string.split("-");
                this.from[i] = this.parseInt(object[0], 1) - 1;
                this.to[i] = this.parseInt(object[1], this.alignmentInput.get().getSiteCount()) - 1;
                continue;
            }
            if (string.matches(".*:.*:.+")) {
                object = string.split(":");
                this.from[i] = this.parseInt(object[0], 1) - 1;
                this.to[i] = this.parseInt(object[1], this.alignmentInput.get().getSiteCount()) - 1;
                this.step[i] = this.parseInt(object[2], 1);
                continue;
            }
            if (string.trim().matches("[0-9]*")) {
                this.from[i] = this.parseInt(string.trim(), 1) - 1;
                this.to[i] = this.from[i];
                this.step[i] = 1;
                continue;
            }
            throw new IllegalArgumentException("Don't know how to parse filter " + string);
        }
    }

    int parseInt(String string, int n) {
        string = string.replaceAll("\\s+", "");
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private void calcFilter() {
        int n;
        int n2;
        boolean[] blArray = new boolean[this.alignmentInput.get().getSiteCount()];
        for (n2 = 0; n2 < this.to.length; ++n2) {
            for (n = this.from[n2]; n <= this.to[n2]; n += this.step[n2]) {
                blArray[n] = true;
            }
        }
        n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        this.filter = new int[n2];
        n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            this.filter[n2++] = n;
        }
    }

    @Override
    public List<List<Integer>> getCounts() {
        if (this.counts == null) {
            int n;
            this.counts = new ArrayList();
            for (n = 0; n < this.sitePatterns[0].length; ++n) {
                this.counts.add(new ArrayList());
            }
            for (n = 0; n < this.getSiteCount(); ++n) {
                int[] nArray = this.getPattern(this.getPatternIndex(n));
                for (int i = 0; i < this.getTaxonCount(); ++i) {
                    ((List)this.counts.get(i)).add(nArray[i]);
                }
            }
        }
        return this.counts;
    }

    @Override
    protected void calcPatterns() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int n7 = this.counts.size();
        int n8 = this.filter.length;
        DataType dataType = this.alignmentInput.get().m_dataType;
        Object object2 = new int[n8][n7];
        for (n6 = 0; n6 < n7; ++n6) {
            object = (List)this.counts.get(n6);
            for (n5 = 0; n5 < n8; ++n5) {
                object2[n5][n6] = (Integer)object.get(this.filter[n5]);
                if (!this.convertDataType) continue;
                try {
                    String string = dataType.getCode(object2[n5][n6]);
                    object2[n5][n6] = this.m_dataType.string2state(string).get(0);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.constantSiteWeightsInput.get() != null) {
            n6 = this.constantSiteWeightsInput.get().getDimension();
            object = new int[n8 + n6][];
            System.arraycopy(object2, 0, object, 0, n8);
            for (n5 = 0; n5 < n6; ++n5) {
                object[n8 + n5] = new int[n7];
                for (int i = 0; i < n7; ++i) {
                    object[n8 + n5][i] = n5;
                }
            }
            object2 = object;
            n8 += n6;
        }
        Alignment.SiteComparator siteComparator = new Alignment.SiteComparator();
        Arrays.sort(object2, siteComparator);
        object = new int[n8];
        n5 = 1;
        if (n8 > 0) {
            object[0] = true;
            for (int i = 1; i < n8; ++i) {
                if (siteComparator.compare(object2[i - 1], object2[i]) != 0) {
                    object2[++n5 - 1] = object2[i];
                }
                Object object3 = object;
                int n9 = n5 - 1;
                object3[n9] = object3[n9] + true;
            }
        } else {
            n5 = 0;
        }
        if (((Boolean)this.stripInvariantSitesInput.get()).booleanValue()) {
            Log.info.print("Stripping invariant sites");
            int n10 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = 1;
                for (n2 = 1; n2 < n7; ++n2) {
                    if (object2[n4][n2] == object2[n4][0]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                Log.warning.print(" <" + object2[n4][0] + "> ");
                n10 += object[n4];
                object[n4] = false;
            }
            Log.warning.println(" removed " + n10 + " sites ");
        }
        if (this.constantSiteWeightsInput.get() != null) {
            Integer[] integerArray = (Integer[])this.constantSiteWeightsInput.get().getValues();
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = 1;
                for (n2 = 1; n2 < n7; ++n2) {
                    if (object2[n4][n2] == object2[n4][0]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0 || object2[n4][0] < 0 || object2[n4][0] >= integerArray.length) continue;
                object[n4] = ((Boolean)this.stripInvariantSitesInput.get() != false ? false : object[n4] - true) + integerArray[object2[n4][0]];
            }
            n8 -= integerArray.length;
        }
        this.patternWeight = new int[n5];
        this.sitePatterns = new int[n5][n7];
        for (n = 0; n < n5; ++n) {
            this.patternWeight[n] = (int)object[n];
            this.sitePatterns[n] = object2[n];
        }
        this.patternIndex = new int[n8];
        for (n = 0; n < n8; ++n) {
            int[] nArray = new int[n7];
            for (n3 = 0; n3 < n7; ++n3) {
                nArray[n3] = (Integer)((List)this.counts.get(n3)).get(this.filter[n]);
                if (!this.convertDataType) continue;
                try {
                    nArray[n3] = this.m_dataType.string2state(dataType.getCode(nArray[n3])).get(0);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.patternIndex[n] = Arrays.binarySearch(this.sitePatterns, nArray, siteComparator);
        }
        if (this.siteWeights != null) {
            throw new RuntimeException("Cannot handle site weights in FilteredAlignment. Remove \"weights\" from data input.");
        }
        this.maxStateCount = 0;
        Integer[] integerArray = this.stateCounts.iterator();
        while (integerArray.hasNext()) {
            n4 = (Integer)integerArray.next();
            this.maxStateCount = Math.max(this.maxStateCount, n4);
        }
        if (this.convertDataType) {
            this.maxStateCount = Math.max(this.maxStateCount, this.m_dataType.getStateCount());
        }
        Log.info.println("Filter " + this.filterInput.get());
        Log.info.println(this.getTaxonCount() + " taxa");
        if (this.constantSiteWeightsInput.get() != null) {
            integerArray = (Integer[])this.constantSiteWeightsInput.get().getValues();
            n4 = 0;
            Integer[] integerArray2 = integerArray;
            int n11 = integerArray2.length;
            for (int i = 0; i < n11; ++i) {
                int n12 = integerArray2[i];
                n4 += n12;
            }
            Log.info.println(this.getSiteCount() + " sites + " + n4 + " constant sites");
        } else {
            Log.info.println(this.getSiteCount() + " sites");
        }
        Log.info.println(this.getPatternCount() + " patterns");
        this.counts = null;
    }

    public int[] indices() {
        return (int[])this.filter.clone();
    }
}

