/*
 * Decompiled with CFR 0.152.
 */
package beast.app.treeannotator;

import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CladeSystem {
    protected Map<BitSet, Clade> cladeMap = new HashMap<BitSet, Clade>();

    public CladeSystem() {
    }

    public CladeSystem(Tree tree) {
        this.add(tree, true);
    }

    public void add(Tree tree, boolean bl) {
        this.addClades(tree.getRoot(), bl);
    }

    private BitSet addClades(Node node, boolean bl) {
        BitSet bitSet = new BitSet();
        if (node.isLeaf()) {
            int n = this.getTaxonIndex(node);
            bitSet.set(2 * n);
            if (bl) {
                this.addClade(bitSet);
            }
        } else {
            int n;
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                bitSet.or(this.addClades(node2, bl));
            }
            for (n = 1; n < bitSet.length(); n += 2) {
                bitSet.set(n, false);
            }
            if (node.isFake()) {
                n = this.getTaxonIndex(node.getDirectAncestorChild());
                bitSet.set(2 * n + 1);
            }
            this.addClade(bitSet);
        }
        return bitSet;
    }

    private void addClade(BitSet bitSet) {
        Clade clade = this.cladeMap.get(bitSet);
        if (clade == null) {
            clade = new Clade(bitSet);
            this.cladeMap.put(bitSet, clade);
        }
        clade.setCount(clade.getCount() + 1);
    }

    public void collectAttributes(Tree tree, Set<String> set) {
        this.collectAttributes(tree.getRoot(), set);
    }

    private BitSet collectAttributes(Node node, Set<String> set) {
        BitSet bitSet = new BitSet();
        if (node.isLeaf()) {
            int n = this.getTaxonIndex(node);
            if (n < 0) {
                throw new IllegalArgumentException("Taxon, " + node.getID() + ", not found in target tree");
            }
            bitSet.set(2 * n);
        } else {
            int n;
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                bitSet.or(this.collectAttributes(node2, set));
            }
            for (n = 1; n < bitSet.length(); n += 2) {
                bitSet.set(n, false);
            }
            if (node.isFake()) {
                n = this.getTaxonIndex(node.getDirectAncestorChild());
                bitSet.set(2 * n + 1);
            }
        }
        this.collectAttributesForClade(bitSet, node, set);
        return bitSet;
    }

    private void collectAttributesForClade(BitSet bitSet, Node node, Set<String> set) {
        Clade clade = this.cladeMap.get(bitSet);
        if (clade != null) {
            if (clade.attributeValues == null) {
                clade.attributeValues = new ArrayList<Object[]>();
            }
            int n = 0;
            Object[] objectArray = new Object[set.size()];
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                String string;
                switch (string = iterator.next()) {
                    case "height": {
                        object = node.getHeight();
                        break;
                    }
                    case "length": {
                        object = this.getBranchLength(node);
                        break;
                    }
                    default: {
                        object = node.getMetaData(string);
                        if (!(object instanceof String) || !((String)object).startsWith("\"")) break;
                        object = ((String)object).replaceAll("\"", "");
                    }
                }
                objectArray[n] = object;
                ++n;
            }
            clade.attributeValues.add(objectArray);
            clade.setCount(clade.getCount() + 1);
        }
    }

    private Object getBranchLength(Node node) {
        if (node.isRoot()) {
            return 0;
        }
        return node.getParent().getHeight() - node.getHeight();
    }

    public Map<BitSet, Clade> getCladeMap() {
        return this.cladeMap;
    }

    public void calculateCladeCredibilities(int n) {
        for (Clade clade : this.cladeMap.values()) {
            if (clade.getCount() > n) {
                throw new AssertionError((Object)("clade.getCount=(" + clade.getCount() + ") should be <= totalTreesUsed = (" + n + ")"));
            }
            clade.setCredibility((double)clade.getCount() / (double)n);
        }
    }

    public double getSumCladeCredibility(Node node, BitSet bitSet) {
        double d = 0.0;
        if (node.isLeaf()) {
            int n = this.getTaxonIndex(node);
            bitSet.set(2 * n);
        } else {
            int n;
            BitSet bitSet2 = new BitSet();
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                d += this.getSumCladeCredibility(node2, bitSet2);
            }
            for (n = 1; n < bitSet2.length(); n += 2) {
                bitSet2.set(n, false);
            }
            if (node.isFake()) {
                n = this.getTaxonIndex(node.getDirectAncestorChild());
                bitSet2.set(2 * n + 1);
            }
            d += this.getCladeCredibility(bitSet2);
            if (bitSet != null) {
                bitSet.or(bitSet2);
            }
        }
        return d;
    }

    public double getLogCladeCredibility(Node node, BitSet bitSet) {
        double d = 0.0;
        if (node.isLeaf()) {
            int n = this.getTaxonIndex(node);
            bitSet.set(2 * n);
        } else {
            int n;
            BitSet bitSet2 = new BitSet();
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                d += this.getLogCladeCredibility(node2, bitSet2);
            }
            for (n = 1; n < bitSet2.length(); n += 2) {
                bitSet2.set(n, false);
            }
            if (node.isFake()) {
                n = this.getTaxonIndex(node.getDirectAncestorChild());
                bitSet2.set(2 * n + 1);
            }
            d += Math.log(this.getCladeCredibility(bitSet2));
            if (bitSet != null) {
                bitSet.or(bitSet2);
            }
        }
        return d;
    }

    private double getCladeCredibility(BitSet bitSet) {
        Clade clade = this.cladeMap.get(bitSet);
        if (clade == null) {
            return 0.0;
        }
        return clade.getCredibility();
    }

    public BitSet removeClades(Node node, boolean bl) {
        BitSet bitSet = new BitSet();
        if (node.isLeaf()) {
            int n = this.getTaxonIndex(node);
            bitSet.set(2 * n);
            if (bl) {
                this.removeClade(bitSet);
            }
        } else {
            int n;
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                bitSet.or(this.removeClades(node2, bl));
            }
            for (n = 1; n < bitSet.length(); n += 2) {
                bitSet.set(n, false);
            }
            if (node.isFake()) {
                n = this.getTaxonIndex(node.getDirectAncestorChild());
                bitSet.set(2 * n + 1);
            }
            this.removeClade(bitSet);
        }
        return bitSet;
    }

    private void removeClade(BitSet bitSet) {
        Clade clade = this.cladeMap.get(bitSet);
        if (clade != null) {
            clade.setCount(clade.getCount() - 1);
        }
    }

    void getTreeCladeCodes(Tree tree, BitSet[] bitSetArray) {
        this.getTreeCladeCodes(tree.getRoot(), bitSetArray);
    }

    int getTreeCladeCodes(Node node, BitSet[] bitSetArray) {
        int n = node.getNr();
        bitSetArray[n].clear();
        if (node.isLeaf()) {
            int n2 = this.getTaxonIndex(node);
            bitSetArray[n].set(n2);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node node2 = node.getChild(i);
                int n3 = this.getTreeCladeCodes(node2, bitSetArray);
                bitSetArray[n].or(bitSetArray[n3]);
            }
        }
        return n;
    }

    public int getTaxonIndex(Node node) {
        return node.getNr();
    }

    public class Clade {
        int count;
        double credibility;
        BitSet bits;
        List<Object[]> attributeValues = null;

        public Clade(BitSet bitSet) {
            this.bits = bitSet;
            this.count = 0;
            this.credibility = 0.0;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }

        public double getCredibility() {
            return this.credibility;
        }

        public void setCredibility(double d) {
            this.credibility = d;
        }

        public List<Object[]> getAttributeValues() {
            return this.attributeValues;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Clade clade = (Clade)object;
            return !(this.bits == null ? clade.bits != null : !this.bits.equals(clade.bits));
        }

        public int hashCode() {
            return this.bits != null ? this.bits.hashCode() : 0;
        }

        public String toString() {
            return "clade " + this.bits.toString();
        }
    }
}

