/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.DocMaker;
import beast.core.util.Log;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpBrowser
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    static DocMaker m_docMaker;
    List<String> m_sPlugins = new ArrayList<String>();
    int m_iCurrentPlugin = 0;
    JEditorPane m_editorPane;
    JButton m_forwardButton;
    JButton m_backwardButton;

    public HelpBrowser(String string) {
        if (m_docMaker == null) {
            m_docMaker = new DocMaker();
        }
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.setContentType("text/html");
        this.m_editorPane.addHyperlinkListener(this);
        this.setModal(true);
        JScrollPane jScrollPane = new JScrollPane(this.m_editorPane);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.m_forwardButton = new JButton(">");
        this.m_forwardButton.setToolTipText("Browse forward");
        this.m_forwardButton.addActionListener(actionEvent -> this.browseForward());
        this.m_backwardButton = new JButton("<");
        this.m_backwardButton.setToolTipText("Browse backward");
        this.m_backwardButton.addActionListener(actionEvent -> this.browseBackward());
        JButton jButton = new JButton("x");
        jButton.setToolTipText("Close Help");
        jButton.addActionListener(actionEvent -> this.dispose());
        box.add(this.m_backwardButton);
        box.add(this.m_forwardButton);
        box.add(jButton);
        Box box2 = Box.createVerticalBox();
        box2.add(box);
        box2.add(jScrollPane);
        this.m_sPlugins.add(string);
        this.updateState();
        this.add(box2);
    }

    void browseForward() {
        if (this.m_iCurrentPlugin < this.m_sPlugins.size() - 1) {
            ++this.m_iCurrentPlugin;
        }
        this.updateState();
    }

    void browseBackward() {
        if (this.m_iCurrentPlugin > 0) {
            --this.m_iCurrentPlugin;
        }
        this.updateState();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        try {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                string = string.replaceAll(".html", "");
                ++this.m_iCurrentPlugin;
                while (this.m_iCurrentPlugin < this.m_sPlugins.size()) {
                    this.m_sPlugins.remove(this.m_iCurrentPlugin);
                }
                this.m_sPlugins.add(string);
                this.updateState();
            }
        }
        catch (Exception exception) {
            Log.err.println(exception.getMessage());
        }
    }

    void updateState() {
        String string = this.m_sPlugins.get(this.m_iCurrentPlugin);
        try {
            String string2 = m_docMaker.getHTML(string, false);
            this.m_editorPane.setText(string2);
        }
        catch (Exception exception) {
            Log.err.println("HelpBrowser: Something is wrong: " + exception.getClass().getName() + " " + exception.getMessage());
        }
        this.m_backwardButton.setEnabled(this.m_iCurrentPlugin > 0);
        this.m_forwardButton.setEnabled(this.m_iCurrentPlugin < this.m_sPlugins.size() - 1);
    }

    public static void main(String[] stringArray) {
        try {
            HelpBrowser helpBrowser = new HelpBrowser("beast.core.MCMC");
            int n = UIManager.getFont("Label.font").getSize();
            helpBrowser.setSize(800 * n / 13, 800 * n / 13);
            helpBrowser.setVisible(true);
            helpBrowser.setDefaultCloseOperation(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

