/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.alignment.Alignment;
import beast.evolution.substitutionmodel.Frequencies;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class FrequenciesInputEditor
extends BEASTObjectInputEditor {
    RealParameter freqsParameter;
    Alignment alignment;
    private static final long serialVersionUID = 1L;
    boolean useDefaultBehavior;

    public FrequenciesInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return ActionEvent.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        super.init(input, bEASTInterface, n, expandOption, bl);
    }

    @Override
    protected void addComboBox(JComponent jComponent, Input<?> input, BEASTInterface bEASTInterface) {
        Frequencies frequencies = (Frequencies)input.get();
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Estimated", "Empirical", "All equal"});
        if (frequencies.frequenciesInput.get() != null) {
            jComboBox.setSelectedIndex(0);
            this.freqsParameter = frequencies.frequenciesInput.get();
            this.alignment = (Alignment)this.getCandidate(frequencies.dataInput, frequencies);
        } else if (frequencies.estimateInput.get().booleanValue()) {
            jComboBox.setSelectedIndex(1);
            this.alignment = frequencies.dataInput.get();
            this.freqsParameter = (RealParameter)this.getCandidate(frequencies.frequenciesInput, frequencies);
        } else {
            jComboBox.setSelectedIndex(2);
            this.alignment = frequencies.dataInput.get();
            this.freqsParameter = (RealParameter)this.getCandidate(frequencies.frequenciesInput, frequencies);
        }
        jComboBox.addActionListener(actionEvent -> {
            int n = jComboBox.getSelectedIndex();
            try {
                switch (n) {
                    case 0: {
                        frequencies.frequenciesInput.setValue(this.freqsParameter, frequencies);
                        frequencies.dataInput.setValue(null, frequencies);
                        break;
                    }
                    case 1: {
                        frequencies.frequenciesInput.setValue(null, frequencies);
                        frequencies.dataInput.setValue(this.alignment, frequencies);
                        frequencies.estimateInput.setValue(true, frequencies);
                        break;
                    }
                    case 2: {
                        frequencies.frequenciesInput.setValue(null, frequencies);
                        frequencies.dataInput.setValue(this.alignment, frequencies);
                        frequencies.estimateInput.setValue(false, frequencies);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        jComponent.add(jComboBox);
    }

    private BEASTInterface getCandidate(Input<?> input, Frequencies frequencies) {
        return this.getDoc().getPartition(frequencies);
    }

    @Override
    protected void addInputLabel() {
        super.addInputLabel();
    }
}

