/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.AlignmentImporter;
import beast.app.beauti.AlignmentViewer;
import beast.app.beauti.Beauti;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.alignment.Sequence;
import beast.util.AddOnManager;
import beast.util.NexusParser;
import beast.util.XMLParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Description(value="Class for creating new alignments to be edited by AlignmentListInputEditor")
public class BeautiAlignmentProvider
extends BEASTObject {
    static List<AlignmentImporter> importers = null;
    static final String[] IMPLEMENTATION_DIR = new String[]{"beast.app"};
    public final Input<BeautiSubTemplate> template = new Input("template", "template to be used after creating a new alignment. ", Input.Validate.REQUIRED);

    private void initImporters() {
        importers = new ArrayList<AlignmentImporter>();
        importers.add(new NexusImporter());
        importers.add(new XMLImporter());
        importers.add(new FastaImporter());
        List<String> list = AddOnManager.find(AlignmentImporter.class, IMPLEMENTATION_DIR);
        for (String string : list) {
            try {
                if (string.startsWith(this.getClass().getName())) continue;
                AlignmentImporter alignmentImporter = (AlignmentImporter)Class.forName(string).newInstance();
                importers.add(alignmentImporter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }

    @Override
    public void initAndValidate() {
    }

    protected int matches(Alignment alignment) {
        return 1;
    }

    protected List<BEASTInterface> getAlignments(BeautiDoc beautiDoc) {
        if (importers == null) {
            this.initImporters();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AlignmentImporter alignmentImporter : importers) {
            for (String string : alignmentImporter.getFileExtensions()) {
                hashSet.add(string);
            }
        }
        File[] fileArray = Utils.getLoadFiles("Load Alignment File", new File(Beauti.g_sDir), "Alignment files", hashSet.toArray(new String[0]));
        if (fileArray != null && fileArray.length > 0) {
            return this.getAlignments(beautiDoc, fileArray);
        }
        return null;
    }

    public List<BEASTInterface> getAlignments(BeautiDoc beautiDoc, File[] fileArray) {
        if (fileArray == null) {
            return this.getAlignments(beautiDoc);
        }
        if (importers == null) {
            this.initImporters();
        }
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        ArrayList arrayList2 = new ArrayList();
        for (File file : fileArray) {
            ArrayList<AlignmentImporter> arrayList3 = new ArrayList<AlignmentImporter>();
            for (AlignmentImporter alignmentImporter : importers) {
                if (!alignmentImporter.canHandleFile(file)) continue;
                arrayList3.add(alignmentImporter);
            }
            if (arrayList3.size() > 0) {
                Object object2 = (AlignmentImporter)arrayList3.get(0);
                if (arrayList3.size() > 1) {
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    for (AlignmentImporter alignmentImporter : arrayList3) {
                        arrayList4.add(((BEASTInterface)((Object)alignmentImporter)).getDescription());
                    }
                    String string = (String)JOptionPane.showInputDialog(null, "Which importer is appropriate", "Option", 2, null, arrayList4.toArray(), arrayList4.get(0));
                    if (string == null) {
                        return arrayList;
                    }
                    int n = arrayList4.indexOf(string);
                    object2 = (AlignmentImporter)arrayList3.get(n);
                }
                List<BEASTInterface> list = object2.loadFile(file);
                arrayList.addAll(list);
                continue;
            }
            JOptionPane.showMessageDialog(null, "Unsupported sequence file.", "Error", 0);
        }
        this.addAlignments(beautiDoc, arrayList);
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public List<BEASTInterface> getAlignments(BeautiDoc beautiDoc, File[] fileArray, String[] stringArray) {
        List<BEASTInterface> list = this.getAlignments(beautiDoc, fileArray);
        return list;
    }

    protected void addAlignments(BeautiDoc beautiDoc, List<BEASTInterface> list) {
        for (BEASTInterface bEASTInterface : list) {
            if (!(bEASTInterface instanceof Alignment)) continue;
            int n = 0;
            String string = bEASTInterface.getID();
            boolean bl = true;
            while (beautiDoc.pluginmap.containsKey(string) && bl) {
                bl = false;
                for (Alignment alignment : beautiDoc.alignments) {
                    if (!alignment.getID().equals(bEASTInterface.getID())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    string = bEASTInterface.getID() + ++n;
                    continue;
                }
                BEASTInterface bEASTInterface2 = beautiDoc.pluginmap.get(bEASTInterface.getID());
                this.replaceItem(beautiDoc, bEASTInterface2, bEASTInterface);
            }
            bEASTInterface.setID(string);
            this.sortByTaxonName(((Alignment)bEASTInterface).sequenceInput.get());
            if (this.getStartTemplate() == null) continue;
            beautiDoc.addAlignmentWithSubnet((Alignment)bEASTInterface, this.getStartTemplate());
        }
    }

    private void replaceItem(BeautiDoc beautiDoc, BEASTInterface bEASTInterface, BEASTInterface bEASTInterface2) {
        beautiDoc.pluginmap.remove(bEASTInterface2.getID());
        LinkedHashSet<BEASTInterface> linkedHashSet = new LinkedHashSet<BEASTInterface>();
        linkedHashSet.addAll(bEASTInterface.getOutputs());
        for (BEASTInterface bEASTInterface3 : linkedHashSet) {
            for (Input<?> input : bEASTInterface3.listInputs()) {
                List list;
                int n;
                if (input.get() == bEASTInterface) {
                    input.setValue(bEASTInterface2, bEASTInterface3);
                    continue;
                }
                if (input.get() == null || !(input.get() instanceof List) || (n = (list = (List)input.get()).indexOf(bEASTInterface)) < 0) continue;
                list.set(n, bEASTInterface2);
                bEASTInterface2.getOutputs().add(bEASTInterface3);
            }
        }
    }

    void editAlignment(Alignment alignment, BeautiDoc beautiDoc) {
        try {
            AlignmentViewer alignmentViewer = new AlignmentViewer(alignment);
            alignmentViewer.showInDialog();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Something went wrong viewing the alignment: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    String validateAlignment() {
        return null;
    }

    protected BeautiSubTemplate getStartTemplate() {
        return this.template.get();
    }

    protected void sortByTaxonName(List<Sequence> list) {
        Collections.sort(list, (sequence, sequence2) -> sequence.taxonInput.get().compareTo(sequence2.taxonInput.get()));
    }

    public static BEASTInterface getXMLData(File file) {
        String string = "";
        try {
            XMLParser xMLParser = new XMLParser();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready()) {
                string = string + bufferedReader.readLine() + "\n";
            }
            bufferedReader.close();
            BEASTInterface bEASTInterface = xMLParser.parseBareFragment(string, false);
            BEASTInterface bEASTInterface2 = BeautiAlignmentProvider.getAlignment(bEASTInterface);
            bEASTInterface2.initAndValidate();
            return bEASTInterface2;
        }
        catch (Exception exception) {
            try {
                String string2 = file.getName();
                string2 = string2.substring(0, string2.lastIndexOf(46)).replaceAll("\\..*", "");
                BEASTInterface bEASTInterface = BeautiAlignmentProvider.parseBeast1XML(string2, string);
                if (bEASTInterface != null) {
                    bEASTInterface.setID(file.getName().substring(0, file.getName().length() - 4).replaceAll("\\..*", ""));
                }
                return bEASTInterface;
            }
            catch (Exception exception2) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Loading of " + file.getName() + " failed: " + exception.getMessage() + "\n" + exception2.getMessage());
                return null;
            }
        }
    }

    private static BEASTInterface parseBeast1XML(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string2)));
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("alignment");
        Alignment alignment = new Alignment();
        alignment.dataTypeInput.setValue("nucleotide", alignment);
        Node node = nodeList.item(0);
        String string3 = node.getAttributes().getNamedItem("dataType").getNodeValue();
        int n = 4;
        if (string3 == null) {
            alignment.dataTypeInput.setValue("integer", alignment);
        } else if (string3.toLowerCase().equals("dna") || string3.toLowerCase().equals("nucleotide")) {
            alignment.dataTypeInput.setValue("nucleotide", alignment);
            n = 4;
        } else if (string3.toLowerCase().equals("aminoacid") || string3.toLowerCase().equals("protein")) {
            alignment.dataTypeInput.setValue("aminoacid", alignment);
            n = 20;
        } else {
            alignment.dataTypeInput.setValue("integer", alignment);
        }
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (!node2.getNodeName().equals("sequence")) continue;
            Sequence sequence = new Sequence();
            String string4 = "";
            NodeList nodeList3 = node2.getChildNodes();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Node node3 = nodeList3.item(j);
                if (!node3.getNodeName().equals("taxon")) continue;
                string4 = node3.getAttributes().getNamedItem("idref").getNodeValue();
            }
            String string5 = node2.getTextContent();
            sequence.initByName("totalcount", n, "taxon", string4, "value", string5);
            sequence.setID("seq_" + string4);
            alignment.sequenceInput.setValue(sequence, alignment);
        }
        alignment.setID(string);
        alignment.initAndValidate();
        return alignment;
    }

    static BEASTInterface getAlignment(BEASTInterface bEASTInterface) throws IllegalArgumentException, IllegalAccessException {
        if (bEASTInterface instanceof Alignment) {
            return bEASTInterface;
        }
        for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
            if ((bEASTInterface2 = BeautiAlignmentProvider.getAlignment(bEASTInterface2)) == null) continue;
            return bEASTInterface2;
        }
        return null;
    }

    @Description(value="Fasta file importer")
    class FastaImporter
    implements AlignmentImporter {
        dtype datatype = dtype.userdefined;

        @Override
        public String[] getFileExtensions() {
            return new String[]{"fa", "fas", "fst", "fasta", "fna", "ffn", "faa", "frn"};
        }

        @Override
        public List<BEASTInterface> loadFile(File file) {
            ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
            try {
                Object object;
                boolean bl;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = "?";
                String string3 = "-";
                int n = 4;
                String string4 = "nucleotide";
                boolean bl2 = bl = !file.getName().toLowerCase().endsWith(".fna") && !file.getName().toLowerCase().endsWith(".ffn") && !file.getName().toLowerCase().endsWith(".frn");
                while (bufferedReader.ready()) {
                    String string5 = bufferedReader.readLine();
                    if (string5.startsWith(";")) continue;
                    if (string5.startsWith(">")) {
                        string = string5.substring(1).trim();
                        string = string.replaceAll("\\s.*$", "");
                        continue;
                    }
                    if (string == null) {
                        bufferedReader.close();
                        throw new RuntimeException("Expected taxon defined on first line");
                    }
                    if (hashMap.containsKey(string)) {
                        object = (StringBuilder)hashMap.get(string);
                        ((StringBuilder)object).append(string5);
                        continue;
                    }
                    object = new StringBuilder();
                    hashMap.put(string, object);
                    ((StringBuilder)object).append(string5);
                    arrayList2.add(string);
                }
                bufferedReader.close();
                int n2 = -1;
                object = new Alignment();
                for (String jComboBox : arrayList2) {
                    StringBuilder stringBuilder = (StringBuilder)hashMap.get(jComboBox);
                    String string5 = stringBuilder.toString();
                    string5 = string5.replaceAll("\\s", "");
                    hashMap.put(jComboBox, new StringBuilder(string5));
                    if (n2 < 0) {
                        n2 = string5.length();
                    }
                    if (string5.length() != n2) {
                        throw new IllegalArgumentException("Expected sequence of length " + n2 + " instead of " + string5.length() + " for taxon " + jComboBox);
                    }
                    string5 = string5.replace(string2.charAt(0), '?');
                    string5 = string5.replace(string3.charAt(0), '-');
                    if (bl && string4.equals("nucleotide") && this.guessSequenceType(string5).equals("aminoacid")) {
                        string4 = "aminoacid";
                        n = 20;
                        for (Sequence sequence : ((Alignment)object).sequenceInput.get()) {
                            sequence.totalCountInput.setValue(n, sequence);
                        }
                    }
                    Sequence sequence = new Sequence();
                    string5 = string5.replaceAll("[Xx]", "?");
                    sequence.init(n, jComboBox, string5);
                    sequence.setID(NexusParser.generateSequenceID(jComboBox));
                    ((Alignment)object).sequenceInput.setValue(sequence, (BEASTInterface)object);
                }
                Object object3 = file.getName();
                object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(46)).replaceAll("\\..*", "");
                ((BEASTObject)object).setID((String)object3);
                if (bl) {
                    switch (this.datatype) {
                        case userdefined: {
                            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"aminoacid", "nucleotide", "all are aminoacid", "all are nucleotide"});
                            jComboBox.setEditable(true);
                            jComboBox.setSelectedItem(string4);
                            JOptionPane.showMessageDialog(null, jComboBox, "Choose the datatype of alignment " + ((BEASTObject)object).getID(), 3);
                            switch ((String)jComboBox.getSelectedItem()) {
                                case "aminoacid": {
                                    string4 = "aminoacid";
                                    n = 20;
                                    break;
                                }
                                case "nucleotide": {
                                    string4 = "nucleotide";
                                    n = 4;
                                    break;
                                }
                                case "all are aminoacid": {
                                    string4 = "aminoacid";
                                    this.datatype = dtype.aminoacid;
                                    n = 20;
                                    break;
                                }
                                case "all are nucleotide": {
                                    string4 = "nucleotide";
                                    this.datatype = dtype.nucleotide;
                                    n = 4;
                                }
                            }
                            break;
                        }
                        case aminoacid: {
                            string4 = "aminoacid";
                            n = 20;
                            break;
                        }
                        case nucleotide: {
                            string4 = "nucleotide";
                            n = 4;
                        }
                    }
                    for (Sequence sequence : ((Alignment)object).sequenceInput.get()) {
                        sequence.totalCountInput.setValue(n, sequence);
                    }
                }
                ((Alignment)object).dataTypeInput.setValue(string4, (BEASTInterface)object);
                ((Alignment)object).initAndValidate();
                arrayList.add((BEASTInterface)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Loading of " + file.getName() + " failed: " + exception.getMessage());
            }
            return arrayList;
        }

        public String guessSequenceType(String string) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = n2 = string.length();
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < n5 && (bl || bl2); ++i) {
                char c = string.charAt(i);
                boolean bl3 = "ACGTUXNacgtuxn?_-".indexOf(c) > -1;
                bl2 &= true;
                if (!(bl &= bl3)) continue;
                assert (bl3);
                if ("ACGTacgt".indexOf(c) > -1) {
                    ++n3;
                    continue;
                }
                if ("?_-".indexOf(c) > -1) {
                    --n2;
                    continue;
                }
                if ("UXNuxn".indexOf(c) <= -1) continue;
                ++n4;
            }
            String string2 = "aminoacid";
            string2 = bl ? (n2 >= 100 ? "nucleotide" : ((double)(n = n3 + n4) >= (double)n2 * 0.7 ? "nucleotide" : "aminoacid")) : (bl2 ? "aminoacid" : null);
            return string2;
        }
    }

    static enum dtype {
        userdefined,
        aminoacid,
        nucleotide;

    }

    @Description(value="BEAST XML file importer")
    class XMLImporter
    implements AlignmentImporter {
        XMLImporter() {
        }

        @Override
        public String[] getFileExtensions() {
            return new String[]{"xml"};
        }

        @Override
        public List<BEASTInterface> loadFile(File file) {
            ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
            Alignment alignment = (Alignment)BeautiAlignmentProvider.getXMLData(file);
            arrayList.add(alignment);
            return arrayList;
        }
    }

    @Description(value="NEXUS file importer")
    class NexusImporter
    implements AlignmentImporter {
        NexusImporter() {
        }

        @Override
        public String[] getFileExtensions() {
            return new String[]{"nex", "nxs", "nexus"};
        }

        @Override
        public List<BEASTInterface> loadFile(File file) {
            ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
            NexusParser nexusParser = new NexusParser();
            try {
                nexusParser.parseFile(file);
                if (nexusParser.filteredAlignments.size() > 0) {
                    int[] nArray = new int[nexusParser.m_alignment.getSiteCount()];
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    int n = 1;
                    for (Alignment object : nexusParser.filteredAlignments) {
                        int[] nArray2;
                        for (int n2 : nArray2 = ((FilteredAlignment)object).indices()) {
                            if (nArray[n2] > 0) {
                                hashSet.add(nArray[n2] * 10000 + n);
                                continue;
                            }
                            nArray[n2] = n;
                        }
                        ++n;
                    }
                    if (hashSet.size() > 0) {
                        Object object2 = "<html>Warning: The following partitions overlap:<br/>";
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            int n3 = (Integer)iterator.next();
                            object2 = object2 + nexusParser.filteredAlignments.get(n3 / 10000 - 1).getID() + " overlaps with " + nexusParser.filteredAlignments.get(n3 % 10000 - 1).getID() + "<br/>";
                        }
                        object2 = object2 + "The first thing you might want to do is delete some of these partitions.</html>";
                        JOptionPane.showMessageDialog(null, object2);
                    }
                    for (Alignment alignment : nexusParser.filteredAlignments) {
                        BeautiAlignmentProvider.this.sortByTaxonName(alignment.sequenceInput.get());
                        arrayList.add(alignment);
                    }
                    if (nexusParser.calibrations != null) {
                        arrayList.addAll(nexusParser.calibrations);
                    }
                } else {
                    arrayList.add(nexusParser.m_alignment);
                    if (nexusParser.calibrations != null) {
                        arrayList.addAll(nexusParser.calibrations);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Loading of " + file.getPath() + " failed: " + exception.getMessage());
                return null;
            }
            return arrayList;
        }
    }
}

