/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beastapp;

import beagle.BeagleFlag;
import beagle.BeagleInfo;
import beast.app.BEASTVersion2;
import beast.app.BeastMCMC;
import beast.app.beastapp.BeastDialog;
import beast.app.util.Arguments;
import beast.app.util.ErrorLogHandler;
import beast.app.util.MessageLogHandler;
import beast.app.util.Utils;
import beast.app.util.Version;
import beast.core.util.Log;
import beast.util.Randomizer;
import beast.util.XMLParserException;
import jam.console.ConsoleApplication;
import jam.util.IconUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class BeastMain {
    private static final Version version = new BEASTVersion2();

    public BeastMain(BeastMCMC beastMCMC, BeastConsoleApp beastConsoleApp, int n) {
        Log.err = System.err;
        Log.warning = System.err;
        Log.info = System.out;
        Log.debug = System.out;
        Log.trace = System.out;
        Logger logger = Logger.getLogger("beast.app");
        try {
            if (beastConsoleApp != null) {
                beastConsoleApp.beastMCMC = beastMCMC;
            }
            Logger logger2 = Logger.getLogger("beast");
            StreamHandler streamHandler = new MessageLogHandler();
            streamHandler.setFilter(logRecord -> logRecord.getLevel().intValue() < Level.WARNING.intValue());
            logger2.addHandler(streamHandler);
            logger2.setUseParentHandlers(false);
            streamHandler = new ErrorLogHandler(n);
            streamHandler.setLevel(Level.WARNING);
            logger2.addHandler(streamHandler);
            beastMCMC.run();
        }
        catch (IOException iOException) {
            logger.severe("File error: " + iOException.getMessage());
        }
        catch (XMLParserException xMLParserException) {
            Log.info.println(xMLParserException.getMessage());
        }
        catch (Exception exception) {
            Log.info.println("Fatal exception: " + exception.getMessage());
            exception.printStackTrace(System.err);
            logger.severe("Fatal exception: " + exception.getMessage());
        }
    }

    static String getFileNameByDialog(String string) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toLowerCase();
                return string.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "xml files";
            }
        });
        jFileChooser.setDialogTitle(string);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    public static void centreLine(String string, int n) {
        int n2 = n - string.length();
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            Log.info.print(" ");
        }
        Log.info.println(string);
    }

    public static void printTitle() {
        int n = 72;
        Log.info.println();
        BeastMain.centreLine("BEAST " + version.getVersionString() + ", " + version.getDateString(), n);
        BeastMain.centreLine("Bayesian Evolutionary Analysis Sampling Trees", n);
        for (String string : version.getCredits()) {
            BeastMain.centreLine(string, n);
        }
        Log.info.println();
    }

    public static void printUsage(Arguments arguments) {
        arguments.printUsage("beast", "[<input-file-name>]");
        Log.info.println();
        Log.info.println("  Example: beast test.xml");
        Log.info.println("  Example: beast -window test.xml");
        Log.info.println("  Example: beast -help");
        Log.info.println();
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        block83: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl2;
            ArrayList<String> arrayList = new ArrayList<String>();
            Arguments arguments = new Arguments(new Arguments.Option[]{new Arguments.Option("window", "Provide a console window"), new Arguments.Option("options", "Display an options dialog"), new Arguments.Option("working", "Change working directory to input file's directory"), new Arguments.LongOption("seed", "Specify a random number generator seed"), new Arguments.StringOption("prefix", "PREFIX", "Specify a prefix for all output log filenames"), new Arguments.StringOption("statefile", "STATEFILE", "Specify the filename for storing/restoring the state"), new Arguments.Option("overwrite", "Allow overwriting of log files"), new Arguments.Option("resume", "Allow appending of log files"), new Arguments.Option("validate", "Parse the XML, but do not run -- useful for debugging XML"), new Arguments.IntegerOption("errors", "Specify maximum number of numerical errors before stopping"), new Arguments.IntegerOption("threads", "The number of computational threads to use (default 1), -1 for number of cores"), new Arguments.Option("java", "Use Java only, no native implementations"), new Arguments.Option("noerr", "Suppress all output to standard error"), new Arguments.StringOption("loglevel", "LEVEL", "error,warning,info,debug,trace"), new Arguments.IntegerOption("instances", "divide site patterns amongst number of threads (use with -threads option)"), new Arguments.Option("beagle", "Use beagle library if available"), new Arguments.Option("beagle_info", "BEAGLE: show information on available resources"), new Arguments.StringOption("beagle_order", "order", "BEAGLE: set order of resource use"), new Arguments.Option("beagle_CPU", "BEAGLE: use CPU instance"), new Arguments.Option("beagle_GPU", "BEAGLE: use GPU instance if available"), new Arguments.Option("beagle_SSE", "BEAGLE: use SSE extensions if available"), new Arguments.Option("beagle_single", "BEAGLE: use single precision if available"), new Arguments.Option("beagle_double", "BEAGLE: use double precision if available"), new Arguments.StringOption("beagle_scaling", new String[]{"default", "none", "dynamic", "always"}, false, "BEAGLE: specify scaling scheme to use"), new Arguments.Option("help", "Print this information and stop"), new Arguments.Option("version", "Print version and stop"), new Arguments.Option("strictversions", "Use only package versions as specified in the 'required' attribute")});
            try {
                arguments.parseArguments(stringArray);
            }
            catch (Arguments.ArgumentException argumentException) {
                Log.info.println();
                Log.info.println(argumentException.getMessage());
                Log.info.println();
                BeastMain.printUsage(arguments);
                System.exit(1);
            }
            if (arguments.hasOption("version")) {
                Log.info.println(new BEASTVersion2().getVersionString());
                System.exit(0);
            }
            if (arguments.hasOption("help")) {
                BeastMain.printUsage(arguments);
                System.exit(0);
            }
            bl = arguments.hasOption("window");
            boolean bl3 = arguments.hasOption("options");
            boolean bl4 = arguments.hasOption("working");
            boolean bl5 = arguments.hasOption("validate");
            String string = null;
            String string2 = null;
            long l = Randomizer.getSeed();
            boolean bl6 = false;
            int n = 1;
            if (arguments.hasOption("java")) {
                bl6 = true;
            }
            if (arguments.hasOption("prefix")) {
                string = arguments.getStringOption("prefix");
            }
            if (arguments.hasOption("statefile")) {
                string2 = arguments.getStringOption("statefile");
            }
            long l2 = 0L;
            boolean bl7 = bl2 = arguments.hasOption("beagle") || arguments.hasOption("beagle_CPU") || arguments.hasOption("beagle_GPU") || arguments.hasOption("beagle_SSE") || arguments.hasOption("beagle_double") || arguments.hasOption("beagle_single") || arguments.hasOption("beagle_order");
            if (arguments.hasOption("beagle_scaling")) {
                System.setProperty("beagle.scaling", arguments.getStringOption("beagle_scaling"));
            }
            boolean bl8 = arguments.hasOption("beagle_info");
            boolean bl9 = true;
            if (arguments.hasOption("beagle_CPU")) {
                l2 |= BeagleFlag.PROCESSOR_CPU.getMask();
                bl9 = false;
            }
            if (arguments.hasOption("beagle_GPU")) {
                l2 |= BeagleFlag.PROCESSOR_GPU.getMask();
                bl9 = false;
            }
            if (arguments.hasOption("beagle_SSE")) {
                l2 |= BeagleFlag.PROCESSOR_CPU.getMask();
                bl9 = true;
            }
            if (bl9) {
                l2 |= BeagleFlag.VECTOR_SSE.getMask();
            }
            if (arguments.hasOption("beagle_double")) {
                l2 |= BeagleFlag.PRECISION_DOUBLE.getMask();
            }
            if (arguments.hasOption("beagle_single")) {
                l2 |= BeagleFlag.PRECISION_SINGLE.getMask();
            }
            if (arguments.hasOption("noerr")) {
                System.setErr(new PrintStream(new OutputStream(){

                    @Override
                    public void write(int n) {
                    }
                }));
            }
            if (arguments.hasOption("beagle_order")) {
                System.setProperty("beagle.resource.order", arguments.getStringOption("beagle_order"));
            }
            if (arguments.hasOption("instances")) {
                System.setProperty("beast.instance.count", Integer.toString(arguments.getIntegerOption("instances")));
            }
            if (arguments.hasOption("beagle_scaling")) {
                System.setProperty("beagle.scaling", arguments.getStringOption("beagle_scaling"));
            }
            if (arguments.hasOption("threads")) {
                n = arguments.getIntegerOption("threads");
            }
            if (n <= 0) {
                n = Runtime.getRuntime().availableProcessors();
                Log.warning.println("Setting number of threads to " + n);
            }
            if (arguments.hasOption("seed") && (l = arguments.getLongOption("seed")) <= 0L) {
                BeastMain.printTitle();
                Log.err.println("The random number seed should be > 0");
                System.exit(1);
            }
            int n2 = 0;
            if (arguments.hasOption("errors") && (n2 = arguments.getIntegerOption("errors")) < 0) {
                n2 = 0;
            }
            BeastConsoleApp beastConsoleApp = null;
            String string3 = "BEAST " + version.getVersionString();
            if (bl) {
                Utils.loadUIManager();
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                System.setProperty("beast.useWindow", "true");
                object4 = IconUtils.getIcon(BeastMain.class, "images/beast.png");
                object3 = "<html><div style=\"font-family:sans-serif;\"><center><div style=\"font-size:12;\"><p>Bayesian Evolutionary Analysis Sampling Trees<br>Version " + version.getVersionString() + ", " + version.getDateString() + "</p>" + version.getHTMLCredits() + "</div></center></div></html>";
                beastConsoleApp = new BeastConsoleApp(string3, (String)object3, (Icon)object4);
                Log.err = System.err;
                Log.info = System.out;
            }
            BeastMain.printTitle();
            object4 = null;
            if (bl3) {
                Utils.loadUIManager();
                object3 = "<html><center><p>Bayesian Evolutionary Analysis Sampling Trees<br>Version " + version.getVersionString() + ", " + version.getDateString() + "</p></center></html>";
                object2 = IconUtils.getIcon(BeastMain.class, "images/beast.png");
                object = new BeastDialog(new JFrame(), (String)object3, (Icon)object2);
                if (!((BeastDialog)object).showDialog(string3, l)) {
                    System.exit(0);
                }
                switch (((BeastDialog)object).getLogginMode()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        arrayList.add("-overwrite");
                        break;
                    }
                    case 2: {
                        arrayList.add("-resume");
                    }
                }
                l = ((BeastDialog)object).getSeed();
                n = ((BeastDialog)object).getThreadPoolSize();
                bl2 = ((BeastDialog)object).useBeagle();
                if (bl2) {
                    bl8 = ((BeastDialog)object).showBeagleInfo();
                    if (((BeastDialog)object).preferBeagleCPU()) {
                        l2 |= BeagleFlag.PROCESSOR_CPU.getMask();
                    }
                    if (((BeastDialog)object).preferBeagleSSE()) {
                        l2 |= BeagleFlag.VECTOR_SSE.getMask();
                    }
                    if (((BeastDialog)object).preferBeagleGPU()) {
                        l2 |= BeagleFlag.PROCESSOR_GPU.getMask();
                    }
                    if (((BeastDialog)object).preferBeagleDouble()) {
                        l2 |= BeagleFlag.PRECISION_DOUBLE.getMask();
                    }
                    if (((BeastDialog)object).preferBeagleSingle()) {
                        l2 |= BeagleFlag.PRECISION_SINGLE.getMask();
                    }
                }
                object4 = ((BeastDialog)object).getInputFile();
                if (!bl8 && object4 == null) {
                    Log.err.println("No input file specified");
                    System.exit(1);
                }
                if (((BeastDialog)object).useStrictVersions()) {
                    arrayList.add("-strictversions");
                }
            } else {
                if (arguments.hasOption("overwrite")) {
                    arrayList.add("-overwrite");
                }
                if (arguments.hasOption("resume")) {
                    arrayList.add("-resume");
                }
            }
            if (arguments.hasOption("strictversions")) {
                arrayList.add("-strictversions");
            }
            if (bl8) {
                BeagleInfo.printResourceList();
                System.exit(0);
            }
            if (object4 == null) {
                object3 = arguments.getLeftoverArguments();
                if (((String[])object3).length > 1) {
                    Log.err.println("Unknown option: " + object3[1]);
                    Log.err.println();
                    BeastMain.printUsage(arguments);
                    System.exit(1);
                }
                object2 = null;
                if (((String[])object3).length > 0) {
                    object2 = object3[0];
                    object4 = new File((String)object2);
                }
                if (object2 == null) {
                    object = BeastMain.getFileNameByDialog("BEAST " + version.getVersionString() + " - Select XML input file");
                    if (object == null) {
                        System.exit(0);
                    }
                    object4 = new File((String)object);
                }
            }
            if (object4 != null && ((File)object4).getParent() != null && bl4) {
                System.setProperty("file.name.prefix", ((File)object4).getParentFile().getAbsolutePath());
            }
            if (bl) {
                if (object4 == null) {
                    beastConsoleApp.setTitle("null");
                } else {
                    beastConsoleApp.setTitle(((File)object4).getName());
                }
            }
            if (bl6) {
                System.setProperty("java.only", "true");
            }
            if (arguments.hasOption("loglevel")) {
                switch (object3 = arguments.getStringOption("loglevel")) {
                    case "error": {
                        Log.setLevel(Log.Level.error);
                        break;
                    }
                    case "warning": {
                        Log.setLevel(Log.Level.warning);
                        break;
                    }
                    case "info": {
                        Log.setLevel(Log.Level.info);
                        break;
                    }
                    case "debug": {
                        Log.setLevel(Log.Level.debug);
                        break;
                    }
                    case "trace": {
                        Log.setLevel(Log.Level.trace);
                    }
                }
            }
            if (string != null && string.trim().length() > 0) {
                System.setProperty("file.name.prefix", string.trim());
            }
            if (string2 != null && string2.trim().length() > 0) {
                System.setProperty("state.file.name", string2.trim());
                Log.info.println("Writing state to file " + string2);
            }
            if (l2 != 0L) {
                System.setProperty("beagle.preferred.flags", Long.toString(l2));
            }
            if (n > 0) {
                System.setProperty("thread.count", String.valueOf(n));
                arrayList.add("-threads");
                arrayList.add(n + "");
            }
            arrayList.add("-seed");
            arrayList.add(l + "");
            Randomizer.setSeed(l);
            Log.info.println("Random number seed: " + l);
            Log.info.println();
            object3 = new BeastMCMC();
            try {
                arrayList.add(((File)object4).getAbsolutePath());
                ((BeastMCMC)object3).parseArgs(arrayList.toArray(new String[0]));
                if (!bl5) {
                    new BeastMain((BeastMCMC)object3, beastConsoleApp, n2);
                } else {
                    Log.info.println("Done!");
                }
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    Log.info.println();
                    Log.info.println("BEAST has terminated with an error. Please select QUIT from the menu.");
                }
                runtimeException.printStackTrace();
            }
            catch (XMLParserException xMLParserException) {
                Log.info.println(xMLParserException.getMessage());
                if (!bl) {
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (bl) break block83;
                System.exit(1);
            }
        }
        if (!bl) {
            System.exit(0);
        }
    }

    static class BeastConsoleApp
    extends ConsoleApplication {
        BeastMCMC beastMCMC;

        public BeastConsoleApp(String string, String string2, Icon icon) throws IOException {
            super(string, string2, icon, false);
            this.getDefaultFrame().setDefaultCloseOperation(0);
        }

        @Override
        public void doStop() {
        }

        public void setTitle(String string) {
            this.getDefaultFrame().setTitle(string);
        }
    }
}

