/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PFont;
import processing.net.Client;
import traer.animation.Smoother3D;
import traer.physics.Particle;
import traer.physics.ParticleSystem;
import traer.physics.Spring;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class domaingraph
extends PApplet {
    final float NODE_SIZE = 6.0f;
    final float EDGE_LENGTH = 30.0f;
    final float EDGE_STRENGTH = 0.001f;
    final float SPACER_STRENGTH = 250.0f;
    ParticleSystem physics;
    Smoother3D centroid;
    PFont font;
    float x;
    float y;
    float z;
    Client myClient;
    Particle center0;
    Particle center1;
    String parsingHostName;
    String parsingHostID;
    HashMap nodes;
    String host;
    int port;
    float a;
    long lastUpdate;
    boolean initTime;

    public void setup() {
        String[] stringArray = PFont.list();
        this.font = this.createFont(stringArray[0], 32.0f);
        this.textFont(this.font, 9.0f);
        this.size(660, 400);
        this.smooth();
        this.frameRate(6.0f);
        this.strokeWeight(1.0f);
        this.ellipseMode(3);
        this.physics = new ParticleSystem(0.0f, 0.25f);
        this.centroid = new Smoother3D(0.8f);
        this.initializePhysics();
        URL uRL = null;
        try {
            uRL = this.getDocumentBase();
        }
        catch (NullPointerException nullPointerException) {}
        if (uRL == null) {
            this.host = "localhost";
            this.port = 8080;
        } else {
            this.host = uRL.getHost();
            this.port = uRL.getPort();
        }
        this.initRequest(false);
    }

    public void initializePhysics() {
        this.physics.clear();
        this.center0 = this.physics.makeParticle(1.0f, -300.0f, 0.0f, 0.0f);
        this.center0.makeFixed();
        this.center1 = this.physics.makeParticle(1.0f, 300.0f, 0.0f, 0.0f);
        this.center1.makeFixed();
        this.centroid.setValue(0.0f, 0.0f, 1.0f);
    }

    public void draw() {
        this.processRequestResponse(50);
        this.physics.tick(1.0f);
        HashSet hashSet = this.invisibleParticles();
        this.deleteParticles(hashSet);
        if (this.physics.numberOfParticles() > 1) {
            this.updateCentroid(hashSet);
        }
        this.centroid.tick();
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.scale(this.centroid.z());
        this.translate(-this.centroid.x(), -this.centroid.y());
        this.drawNetwork();
    }

    public void initRequest(boolean bl) {
        this.myClient = new Client(this, this.host, this.port);
        this.myClient.write(bl ? "GET /api/webstructure.xml?latest= HTTP/1.1\n" : "GET /xml/webstructure.xml HTTP/1.1\n");
        this.myClient.write("Host: localhost\n\n");
    }

    public void processRequestResponse(int n) {
        if ((this.myClient == null || this.myClient.available() <= 0) && System.currentTimeMillis() - this.lastUpdate > 10000L) {
            this.initRequest(true);
            this.lastUpdate = Long.MAX_VALUE;
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.myClient.available() > 0) {
                int n3;
                int n4;
                String string = this.myClient.readStringUntil(10);
                string = string == null ? "" : string.trim();
                int n5 = string.indexOf("<domain");
                if (n5 >= 0) {
                    this.processDomain(this.parseProps(string.substring(n5 + 8, string.length() - 1).trim()));
                }
                if ((n5 = string.indexOf("<reference")) >= 0 && (n4 = string.indexOf("</reference>")) > 0 && (n3 = string.lastIndexOf(62, n4)) > 0) {
                    String string2 = string.substring(n3, n4);
                    this.processCitation(string2, this.parseProps(string.substring(n5 + 11, n3).trim()));
                }
                this.lastUpdate = System.currentTimeMillis();
            } else {
                this.initTime = false;
            }
            ++n2;
        }
    }

    public void processDomain(HashMap hashMap) {
        host host2;
        this.parsingHostName = (String)hashMap.get("host");
        if (this.parsingHostName == null) {
            this.parsingHostName = "";
        }
        this.parsingHostID = (String)hashMap.get("id");
        if (this.parsingHostID == null) {
            this.parsingHostID = "";
        }
        if ((host2 = (host)this.nodes.get(this.parsingHostID)) != null) {
            host2.time = System.currentTimeMillis();
            return;
        }
        host2 = new host(this.parsingHostName, this.physics.makeParticle(1.0f, 600.0f * domaingraph.cos(this.a), -300.0f * domaingraph.sin(this.a), 0.0f));
        this.a += 3.1661365f;
        if (this.a > (float)Math.PI * 2) {
            this.a -= (float)Math.PI * 2;
        }
        this.nodes.put(this.parsingHostID, host2);
        this.addAttraction(host2.node);
    }

    public void processCitation(String string, HashMap hashMap) {
        Object object;
        String string2 = (String)hashMap.get("id");
        if (string2 == null) {
            string2 = "";
        }
        int n = 0;
        try {
            object = (String)hashMap.get("count");
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        object = (host)this.nodes.get(string2);
        if (object == null) {
            return;
        }
        ((host)object).time = System.currentTimeMillis();
        host host2 = (host)this.nodes.get(this.parsingHostID);
        if (host2 == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.physics.numberOfSprings()) {
            Spring spring = this.physics.getSpring(n2);
            Particle particle = spring.getOneEnd();
            Particle particle2 = spring.getTheOtherEnd();
            if (particle == ((host)object).node && particle2 == host2.node || particle2 == ((host)object).node && particle == host2.node) {
                return;
            }
            ++n2;
        }
        this.physics.makeSpring(((host)object).node, host2.node, 0.001f, 0.001f, 30.0f);
    }

    public HashMap parseProps(String string) {
        String[] stringArray = string.split(" ");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("=");
            if (n2 > 0) {
                String string2 = stringArray[n].substring(n2 + 1).trim();
                if (string2.charAt(0) == '\"') {
                    string2 = string2.substring(1);
                }
                if (string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                hashMap.put(stringArray[n].substring(0, n2), string2);
            }
            ++n;
        }
        return hashMap;
    }

    public HashSet invisibleParticles() {
        host host2;
        HashSet<Particle> hashSet = new HashSet<Particle>();
        Iterator iterator = this.nodes.values().iterator();
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (iterator.hasNext()) {
            host2 = (host)iterator.next();
            l += l2 - host2.time;
            hashSet.add(host2.node);
        }
        l /= (long)(this.nodes.size() + 1);
        int n = 0;
        while (n < this.physics.numberOfSprings()) {
            Spring spring = this.physics.getSpring(n);
            hashSet.remove(spring.getOneEnd());
            hashSet.remove(spring.getTheOtherEnd());
            ++n;
        }
        if (this.nodes.size() > 80) {
            iterator = this.nodes.values().iterator();
            while (iterator.hasNext()) {
                host2 = (host)iterator.next();
                if (l2 - host2.time > 15000L) {
                    hashSet.add(host2.node);
                }
                if (this.nodes.size() - hashSet.size() < 80) break;
            }
        }
        return hashSet;
    }

    public void deleteParticles(HashSet hashSet) {
        Iterator iterator = this.nodes.values().iterator();
        while (iterator.hasNext()) {
            host host2 = (host)iterator.next();
            if (!hashSet.contains(host2.node)) continue;
            host2.node.kill();
            iterator.remove();
        }
    }

    public void drawNetwork() {
        this.fill(120.0f, 255.0f, 120.0f);
        this.noStroke();
        Iterator iterator = this.nodes.values().iterator();
        while (iterator.hasNext()) {
            host host2 = (host)iterator.next();
            Particle particle = host2.node;
            this.ellipse(particle.position().x(), particle.position().y(), 6.0f, 6.0f);
            String string = host2.name;
            this.text(string, particle.position().x() - (float)(string.length() * 26 / 10), particle.position().y() + 14.0f);
        }
        this.stroke(200);
        int n = 0;
        while (n < this.physics.numberOfSprings()) {
            Spring spring = this.physics.getSpring(n);
            Particle particle = spring.getOneEnd();
            Particle particle2 = spring.getTheOtherEnd();
            this.line(particle.position().x(), particle.position().y(), particle2.position().x(), particle2.position().y());
            ++n;
        }
    }

    public void keyPressed() {
        if (this.key == 'c') {
            this.initializePhysics();
        }
        if (this.key == 'a') {
            this.x = Math.max(-1.0f, this.x - 0.1f);
        }
        if (this.key == 'd') {
            this.x = Math.min(1.0f, this.x + 0.1f);
        }
        if (this.key == 'w') {
            this.y = Math.max(-1.0f, this.y - 0.1f);
        }
        if (this.key == 's') {
            this.y = Math.min(1.0f, this.y + 0.1f);
        }
        if (this.key == '-') {
            this.z = Math.max(1.0f, this.z - 1.0f);
        }
        if (this.key == '+') {
            this.z = Math.min(10.0f, this.z + 1.0f);
        }
        if (this.key == '0') {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        }
        if (this.key == 't') {
            HashSet<Particle> hashSet = new HashSet<Particle>();
            int n = 0;
            while (n < this.physics.numberOfParticles()) {
                hashSet.add(this.physics.getParticle(n));
                ++n;
            }
            n = 0;
            while (n < this.physics.numberOfSprings()) {
                hashSet.remove(this.physics.getSpring(n).getOneEnd());
                hashSet.remove(this.physics.getSpring(n).getTheOtherEnd());
                ++n;
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((Particle)iterator.next()).kill();
            }
            return;
        }
    }

    public void updateCentroid(HashSet hashSet) {
        float f;
        float f2;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.POSITIVE_INFINITY;
        float f5 = Float.POSITIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.physics.numberOfParticles()) {
            Particle particle = this.physics.getParticle(n);
            if (n < 2 || particle != this.center0 && particle != this.center1 && !hashSet.contains(particle)) {
                f3 = domaingraph.max(f3, particle.position().x());
                f4 = domaingraph.min(f4, particle.position().x());
                f5 = domaingraph.min(f5, particle.position().y());
                f6 = domaingraph.max(f6, particle.position().y());
            }
            ++n;
        }
        this.centroid.setTarget(f4 + (this.x + 1.0f) * 0.5f * f2, f5 + (this.y + 1.0f) * 0.5f * f, this.z * ((f = f6 - f5) > (f2 = f3 - f4) ? (float)this.height / (f + 50.0f) : (float)this.width / (f2 + 50.0f)));
    }

    public void addAttraction(Particle particle) {
        this.physics.makeAttraction(this.center0, particle, 2500000.0f, 3000.0f);
        this.physics.makeAttraction(this.center1, particle, 2500000.0f, 3000.0f);
        int n = 0;
        while (n < this.physics.numberOfParticles()) {
            Particle particle2 = this.physics.getParticle(n);
            if (particle != particle2) {
                this.physics.makeAttraction(particle, particle2, -250.0f, 20.0f);
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"domaingraph"});
    }

    private final /* synthetic */ void this() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 1.0f;
        this.parsingHostName = "";
        this.parsingHostID = "";
        this.nodes = new HashMap();
        this.a = 0.0f;
        this.lastUpdate = Long.MAX_VALUE;
        this.initTime = true;
    }

    public domaingraph() {
        this.this();
    }

    static class host {
        String name;
        Particle node;
        long time;

        public host(String string, Particle particle) {
            this.name = string;
            this.node = particle;
            this.time = System.currentTimeMillis();
        }
    }
}

