/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.BoolVector;
import Common.CRC;
import Common.IntVector;
import Common.LongVector;
import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Decoder;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.InArchiveInfo;
import SevenZip.Archive.SevenZip.InStream;
import SevenZip.Archive.SevenZip.StreamSwitch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class ArchiveDB {
    public static final int kNumNoIndex = -1;
    public final LongVector PackSizes = new LongVector();
    public final BoolVector PackCRCsDefined = new BoolVector();
    public final IntVector PackCRCs = new IntVector();
    public final IntVector NumUnPackStreamsVector = new IntVector();
    public final Vector<FileItem> Files = new Vector();
    public Vector<Folder> Folders = new Vector();
    public final IntVector FolderStartPackStreamIndex = new IntVector();
    public final IntVector FolderStartFileIndex = new IntVector();
    public final IntVector FileIndexToFolderIndexMap = new IntVector();
    private final InStream inStream;
    private final InArchiveInfo ArchiveInfo = new InArchiveInfo();
    private final LongVector PackStreamStartPositions = new LongVector();

    public ArchiveDB(InStream inStream) throws IOException {
        this.inStream = inStream;
        this.ArchiveInfo.StartPosition = this.inStream.archiveBeginStreamPosition;
        byte[] btmp = new byte[2];
        int realProcessedSize = this.inStream.ReadDirect(btmp, 2);
        if (realProcessedSize != 2) {
            throw new IOException("Unexpected End Of Archive");
        }
        this.ArchiveInfo.ArchiveVersion_Major = btmp[0];
        this.ArchiveInfo.ArchiveVersion_Minor = btmp[1];
        if (this.ArchiveInfo.ArchiveVersion_Major != 0) {
            throw new IOException("Unsupported Version: " + this.ArchiveInfo.ArchiveVersion_Major + "." + this.ArchiveInfo.ArchiveVersion_Minor);
        }
        int crcFromArchive = this.inStream.SafeReadDirectUInt32();
        long nextHeaderOffset = this.inStream.SafeReadDirectUInt64();
        long nextHeaderSize = this.inStream.SafeReadDirectUInt64();
        int nextHeaderCRC = this.inStream.SafeReadDirectUInt32();
        this.ArchiveInfo.StartPositionAfterHeader = this.inStream.position;
        CRC crc = new CRC();
        crc.UpdateUInt64(nextHeaderOffset);
        crc.UpdateUInt64(nextHeaderSize);
        crc.UpdateUInt32(nextHeaderCRC);
        if (crc.GetDigest() != crcFromArchive) {
            throw new IOException("Incorrect Header, CRCs don't match: archive: " + Integer.toHexString(crcFromArchive) + ", calculated: " + crc);
        }
        if (nextHeaderSize == 0L) {
            return;
        }
        if (nextHeaderSize >= 0xFFFFFFFFL) {
            throw new IOException("second header too big: " + nextHeaderSize);
        }
        this.inStream.position = this.inStream.stream.Seek(nextHeaderOffset, 1);
        this.readNextStreamHeaders((int)nextHeaderSize, nextHeaderCRC);
        this.readHeader();
        this.Fill();
    }

    private void readNextStreamHeaders(int nextHeaderSize, int nextHeaderCRC) throws IOException {
        long type;
        byte[] buffer = new byte[nextHeaderSize];
        if (!this.inStream.SafeReadDirect(buffer, nextHeaderSize)) {
            throw new IOException("Unexpected End Of Archive");
        }
        if (!CRC.VerifyDigest(nextHeaderCRC, buffer, nextHeaderSize)) {
            throw new IOException("Incorrect Header, CRCs don't match");
        }
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, buffer);
        while ((type = this.inStream.ReadID()) != 1L) {
            if (type != 23L) {
                throw new IOException("Incorrect Header");
            }
            Vector dataVector = this.ReadAndDecodePackedStreams(this.ArchiveInfo.StartPositionAfterHeader, 1);
            if (dataVector.size() == 0) {
                return;
            }
            if (dataVector.size() > 1) {
                throw new IOException("Incorrect Header");
            }
            streamSwitch.Set(this.inStream, (byte[])dataVector.firstElement());
        }
        streamSwitch.close();
    }

    private void ReadArchiveProperties(InArchiveInfo archiveInfo) throws IOException {
        while (this.inStream.ReadID() != 0L) {
            this.inStream.SkeepData();
        }
    }

    private void readHeader() throws IOException {
        long type = this.inStream.ReadID();
        if (type == 2L) {
            this.ReadArchiveProperties(this.ArchiveInfo);
            type = this.inStream.ReadID();
        }
        Vector dataVector = new Vector();
        if (type == 3L) {
            dataVector.addAll(this.ReadAndDecodePackedStreams(this.ArchiveInfo.StartPositionAfterHeader, 1));
            this.ArchiveInfo.DataStartPosition2 += this.ArchiveInfo.StartPositionAfterHeader;
            type = this.inStream.ReadID();
        }
        LongVector unPackSizes = new LongVector();
        BoolVector digestsDefined = new BoolVector();
        IntVector digests = new IntVector();
        if (type == 4L) {
            type = this.inStream.ReadID();
            assert (type == 6L);
            this.ReadPackInfo(this.PackSizes, this.PackCRCsDefined, this.PackCRCs, 0);
            type = this.inStream.ReadID();
            assert (type == 7L);
            this.Folders = this.ReadUnPackInfo(dataVector);
            type = this.inStream.ReadID();
            assert (type == 8L);
            this.ReadSubStreamsInfo(this.Folders, this.NumUnPackStreamsVector, unPackSizes, digestsDefined, digests);
            type = this.inStream.ReadID();
            assert (type == 0L);
            this.ArchiveInfo.DataStartPosition += this.ArchiveInfo.StartPositionAfterHeader;
            type = this.inStream.ReadID();
        } else {
            for (int i = 0; i < this.Folders.size(); ++i) {
                this.NumUnPackStreamsVector.add(1);
                Folder folder = this.Folders.get(i);
                unPackSizes.add(folder.GetUnPackSize());
                digestsDefined.add(folder.UnPackCRCDefined);
                digests.add(folder.UnPackCRC);
            }
        }
        if (type == 0L) {
            return;
        }
        if (type != 5L) {
            throw new IOException("Incorrect Header");
        }
        this.readFileDescriptions(dataVector, unPackSizes, digests, digestsDefined);
    }

    private void readFileDescriptions(Vector dataVector, LongVector unPackSizes, IntVector digests, BoolVector digestsDefined) throws IOException {
        int i;
        long type;
        int numFiles = this.inStream.ReadNum();
        this.ArchiveInfo.FileInfoPopIDs.add(9L);
        if (!this.PackSizes.isEmpty()) {
            this.ArchiveInfo.FileInfoPopIDs.add(6L);
        }
        if (numFiles > 0 && !digests.isEmpty()) {
            this.ArchiveInfo.FileInfoPopIDs.add(10L);
        }
        this.Files.clear();
        this.Files.ensureCapacity(numFiles);
        for (int i2 = 0; i2 < numFiles; ++i2) {
            this.Files.add(new FileItem());
        }
        BoolVector emptyStreamVector = new BoolVector();
        emptyStreamVector.Reserve(numFiles);
        for (int i3 = 0; i3 < numFiles; ++i3) {
            emptyStreamVector.add(false);
        }
        BoolVector emptyFileVector = new BoolVector();
        BoolVector antiFileVector = new BoolVector();
        int numEmptyStreams = 0;
        block11: while ((type = this.inStream.ReadID()) != 0L) {
            long size = this.inStream.ReadNumber();
            this.ArchiveInfo.FileInfoPopIDs.add(type);
            switch ((int)type) {
                case 14: {
                    emptyStreamVector.setBoolVector(this.inStream.ReadBoolVector(numFiles));
                    for (i = 0; i < emptyStreamVector.size(); ++i) {
                        if (!emptyStreamVector.get(i)) continue;
                        ++numEmptyStreams;
                    }
                    emptyFileVector.Reserve(numEmptyStreams);
                    antiFileVector.Reserve(numEmptyStreams);
                    for (i = 0; i < numEmptyStreams; ++i) {
                        emptyFileVector.add(false);
                        antiFileVector.add(false);
                    }
                    continue block11;
                }
                case 17: {
                    this.ReadFileNames(dataVector);
                    break;
                }
                case 21: {
                    this.ReadFileAttributes(dataVector);
                    break;
                }
                case 24: {
                    this.ReadFileStartPositions(dataVector);
                    break;
                }
                case 15: {
                    emptyFileVector.setBoolVector(this.inStream.ReadBoolVector(numEmptyStreams));
                    break;
                }
                case 16: {
                    antiFileVector.setBoolVector(this.inStream.ReadBoolVector(numEmptyStreams));
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    this.ReadTime(dataVector, type);
                    break;
                }
                default: {
                    this.ArchiveInfo.FileInfoPopIDs.DeleteBack();
                    this.inStream.SkeepData(size);
                }
            }
        }
        int emptyFileIndex = 0;
        int sizeIndex = 0;
        for (i = 0; i < numFiles; ++i) {
            FileItem file = this.Files.get(i);
            boolean bl = file.HasStream = !emptyStreamVector.get(i);
            if (file.HasStream) {
                file.IsDirectory = false;
                file.IsAnti = false;
                file.UnPackSize = unPackSizes.get(sizeIndex);
                file.FileCRC = digests.get(sizeIndex);
                file.IsFileCRCDefined = digestsDefined.get(sizeIndex);
                ++sizeIndex;
                continue;
            }
            file.IsDirectory = !emptyFileVector.get(emptyFileIndex);
            file.IsAnti = antiFileVector.get(emptyFileIndex);
            ++emptyFileIndex;
            file.UnPackSize = 0L;
            file.IsFileCRCDefined = false;
        }
    }

    private void ReadSubStreamsInfo(Vector<Folder> folders, IntVector numUnPackStreamsInFolders, LongVector unPackSizes, BoolVector digestsDefined, IntVector digests) throws IOException {
        int numSubstreams;
        int i;
        long type;
        numUnPackStreamsInFolders.clear();
        numUnPackStreamsInFolders.Reserve(folders.size());
        while ((type = this.inStream.ReadID()) != 10L && type != 9L && type != 0L) {
            if (type == 13L) {
                for (i = 0; i < folders.size(); ++i) {
                    int value = this.inStream.ReadNum();
                    numUnPackStreamsInFolders.add(value);
                }
                continue;
            }
            this.inStream.SkeepData();
        }
        if (numUnPackStreamsInFolders.isEmpty()) {
            for (i = 0; i < folders.size(); ++i) {
                numUnPackStreamsInFolders.add(1);
            }
        }
        ArrayList<Number> sizes = new ArrayList<Number>();
        for (int i2 = 0; i2 < numUnPackStreamsInFolders.size(); ++i2) {
            numSubstreams = numUnPackStreamsInFolders.get(i2);
            if (numSubstreams < 1) continue;
            long sum = 0L;
            if (type == 9L) {
                for (int j = 1; j < numSubstreams; ++j) {
                    long size = this.inStream.ReadNumber();
                    sum += size;
                    sizes.add(new Long(size));
                }
            }
            sizes.add(new Long(folders.get(i2).GetUnPackSize() - sum));
        }
        unPackSizes.addAll(sizes);
        sizes.clear();
        if (type == 9L) {
            type = this.inStream.ReadID();
        }
        int numDigests = 0;
        int numDigestsTotal = 0;
        for (int i3 = 0; i3 < folders.size(); ++i3) {
            numSubstreams = numUnPackStreamsInFolders.get(i3);
            if (numSubstreams != 1 || !folders.get((int)i3).UnPackCRCDefined) {
                numDigests += numSubstreams;
            }
            numDigestsTotal += numSubstreams;
        }
        ArrayList<Boolean> bsizes = new ArrayList<Boolean>();
        do {
            if (type == 10L) {
                BoolVector digestsDefined2 = new BoolVector();
                IntVector digests2 = new IntVector();
                digests2 = this.inStream.ReadHashDigests(numDigests, digestsDefined2);
                int digestIndex = 0;
                for (int i4 = 0; i4 < folders.size(); ++i4) {
                    numSubstreams = numUnPackStreamsInFolders.get(i4);
                    Folder folder = folders.get(i4);
                    if (numSubstreams == 1 && folder.UnPackCRCDefined) {
                        bsizes.add(Boolean.TRUE);
                        sizes.add(new Integer(folder.UnPackCRC));
                        continue;
                    }
                    int j = 0;
                    while (j < numSubstreams) {
                        bsizes.add(new Boolean(digestsDefined2.get(digestIndex)));
                        sizes.add(new Integer(digests2.get(digestIndex)));
                        ++j;
                        ++digestIndex;
                    }
                }
                digestsDefined.addAll(bsizes);
                bsizes.clear();
                digests.addAll(sizes);
                sizes.clear();
                continue;
            }
            this.inStream.SkeepData();
        } while ((type = this.inStream.ReadID()) != 0L);
        if (digestsDefined.isEmpty()) {
            digests.clear();
            for (int i5 = 0; i5 < numDigestsTotal; ++i5) {
                digestsDefined.add(false);
                digests.add(0);
            }
        }
    }

    private Vector ReadAndDecodePackedStreams(long baseOffset, int dataStartPosIndex) throws IOException {
        LongVector packSizes = new LongVector();
        BoolVector packCRCsDefined = new BoolVector();
        IntVector packCRCs = new IntVector();
        long type = this.inStream.ReadID();
        assert (type == 6L);
        this.ReadPackInfo(packSizes, packCRCsDefined, packCRCs, dataStartPosIndex);
        type = this.inStream.ReadID();
        assert (type == 7L);
        Vector<Folder> folders = this.ReadUnPackInfo(null);
        type = this.inStream.ReadID();
        assert (type == 0L);
        int packIndex = 0;
        Decoder decoder = new Decoder(false);
        Vector<byte[]> dataVector = new Vector<byte[]>();
        long dataStartPos = baseOffset + (dataStartPosIndex == 0 ? this.ArchiveInfo.DataStartPosition : this.ArchiveInfo.DataStartPosition2);
        for (int i = 0; i < folders.size(); ++i) {
            Folder folder = folders.get(i);
            long unPackSize = folder.GetUnPackSize();
            if (unPackSize > Integer.MAX_VALUE || unPackSize > 0xFFFFFFFFL) {
                throw new IOException("unPackSize too great: " + unPackSize);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)unPackSize);
            decoder.Decode(this.inStream.stream, dataStartPos, packSizes, packIndex, folder, baos, null);
            byte[] data = baos.toByteArray();
            dataVector.add(data);
            if (folder.UnPackCRCDefined && !CRC.VerifyDigest(folder.UnPackCRC, data, (int)unPackSize)) {
                throw new IOException("Incorrect Header, CRCs of packed folder don't match: archive: " + Integer.toHexString(folder.UnPackCRC) + ", calculated: " + Integer.toHexString(CRC.CalculateDigest(data, (int)unPackSize)) + ". Either is the archive corrupted or an internal error occured");
            }
            for (int j = 0; j < folder.PackStreams.size(); ++j) {
                dataStartPos += packSizes.get(packIndex++);
            }
        }
        return dataVector;
    }

    private void ReadPackInfo(LongVector packSizes, BoolVector packCRCsDefined, IntVector packCRCs, int dataStartPosIndex) throws IOException {
        long type;
        if (dataStartPosIndex == 0) {
            this.ArchiveInfo.DataStartPosition = this.inStream.ReadNumber();
        } else {
            this.ArchiveInfo.DataStartPosition2 = this.inStream.ReadNumber();
        }
        int numPackStreams = this.inStream.ReadNum();
        this.inStream.skipToAttribute(9L);
        packSizes.clear();
        packSizes.Reserve(numPackStreams);
        for (int i = 0; i < numPackStreams; ++i) {
            long size = this.inStream.ReadNumber();
            packSizes.add(size);
        }
        while ((type = this.inStream.ReadID()) != 0L) {
            if (type == 10L) {
                packCRCs = this.inStream.ReadHashDigests(numPackStreams, packCRCsDefined);
                continue;
            }
            this.inStream.SkeepData();
        }
        if (packCRCsDefined.isEmpty()) {
            packCRCsDefined.Reserve(numPackStreams);
            packCRCsDefined.clear();
            packCRCs.Reserve(numPackStreams);
            packCRCs.clear();
            for (int i = 0; i < numPackStreams; ++i) {
                packCRCsDefined.add(false);
                packCRCs.add(0);
            }
        }
    }

    private void ReadFileNames(Vector from) throws IOException {
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, from);
        StringBuffer name = new StringBuffer(30);
        for (int i = 0; i < this.Files.size(); ++i) {
            char c;
            while ((c = this.inStream.ReadWideCharLE()) != '\u0000') {
                name.append(c);
            }
            this.Files.get((int)i).name = new String(name);
            name.delete(0, name.length());
        }
        streamSwitch.close();
    }

    private void ReadFileAttributes(Vector from) throws IOException {
        BoolVector boolVector = this.inStream.ReadBoolVector2(this.Files.size());
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, from);
        for (int i = 0; i < this.Files.size(); ++i) {
            FileItem file = this.Files.get(i);
            file.AreAttributesDefined = boolVector.get(i);
            if (!file.AreAttributesDefined) continue;
            file.Attributes = this.inStream.ReadUInt32();
        }
        streamSwitch.close();
    }

    private void ReadFileStartPositions(Vector from) throws IOException {
        BoolVector boolVector = this.inStream.ReadBoolVector2(this.Files.size());
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, from);
        for (int i = 0; i < this.Files.size(); ++i) {
            FileItem file = this.Files.get(i);
            file.IsStartPosDefined = boolVector.get(i);
            if (!file.IsStartPosDefined) continue;
            file.StartPos = this.inStream.ReadUInt64();
        }
        streamSwitch.close();
    }

    private void ReadTime(Vector dataVector, long type) throws IOException {
        BoolVector boolVector = this.inStream.ReadBoolVector2(this.Files.size());
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, dataVector);
        block5: for (int i = 0; i < this.Files.size(); ++i) {
            FileItem file = this.Files.get(i);
            int low = 0;
            int high = 0;
            boolean defined = boolVector.get(i);
            if (defined) {
                low = this.inStream.ReadUInt32();
                high = this.inStream.ReadUInt32();
            }
            switch ((int)type) {
                case 18: {
                    if (!defined) continue block5;
                    file.CreationTime = InStream.FileTimeToLong(high, low);
                    continue block5;
                }
                case 20: {
                    if (!defined) continue block5;
                    file.LastWriteTime = InStream.FileTimeToLong(high, low);
                    continue block5;
                }
                case 19: {
                    if (!defined) continue block5;
                    file.LastAccessTime = InStream.FileTimeToLong(high, low);
                }
            }
        }
        streamSwitch.close();
    }

    private Vector<Folder> ReadUnPackInfo(Vector dataVector) throws IOException {
        long type;
        int i;
        this.inStream.skipToAttribute(11L);
        int numFolders = this.inStream.ReadNum();
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this.inStream, dataVector);
        Vector<Folder> folders = new Vector<Folder>(numFolders);
        for (i = 0; i < numFolders; ++i) {
            folders.add(this.GetNextFolderItem());
        }
        streamSwitch.close();
        this.inStream.skipToAttribute(12L);
        for (i = 0; i < numFolders; ++i) {
            Folder folder = (Folder)folders.get(i);
            int numOutStreams = folder.GetNumOutStreams();
            folder.UnPackSizes.Reserve(numOutStreams);
            for (int j = 0; j < numOutStreams; ++j) {
                long unPackSize = this.inStream.ReadNumber();
                folder.UnPackSizes.add(unPackSize);
            }
        }
        while ((type = this.inStream.ReadID()) != 0L) {
            if (type == 10L) {
                BoolVector crcsDefined = new BoolVector();
                IntVector crcs = new IntVector();
                crcs = this.inStream.ReadHashDigests(numFolders, crcsDefined);
                for (int i2 = 0; i2 < numFolders; ++i2) {
                    Folder folder = folders.get(i2);
                    folder.UnPackCRCDefined = crcsDefined.get(i2);
                    folder.UnPackCRC = crcs.get(i2);
                }
                continue;
            }
            this.inStream.SkeepData();
        }
        return folders;
    }

    private Folder GetNextFolderItem() throws IOException {
        int numCoders = this.inStream.ReadNum();
        Folder folder = new Folder();
        folder.Coders.clear();
        folder.Coders.ensureCapacity(numCoders);
        int numInStreams = 0;
        int numOutStreams = 0;
        for (int i = 0; i < numCoders; ++i) {
            int mainByte;
            folder.Coders.add(new CoderInfo());
            CoderInfo coder = folder.Coders.lastElement();
            do {
                int propertiesSize;
                AltCoderInfo altCoder = new AltCoderInfo();
                coder.AltCoders.add(altCoder);
                mainByte = this.inStream.ReadByte();
                altCoder.MethodID.IDSize = (byte)(mainByte & 0xF);
                if (!this.inStream.ReadBytes(altCoder.MethodID.ID, (int)altCoder.MethodID.IDSize)) {
                    throw new IOException("error reading properties for alternative decoder");
                }
                if ((mainByte & 0x10) != 0) {
                    coder.NumInStreams = this.inStream.ReadNum();
                    coder.NumOutStreams = this.inStream.ReadNum();
                } else {
                    coder.NumInStreams = 1;
                    coder.NumOutStreams = 1;
                }
                if ((mainByte & 0x20) == 0 || this.inStream.ReadBytes(altCoder.Properties, propertiesSize = this.inStream.ReadNum())) continue;
                throw new IOException("error reading properties for alternative decoder");
            } while ((mainByte & 0x80) != 0);
            numInStreams += coder.NumInStreams;
            numOutStreams += coder.NumOutStreams;
        }
        int numBindPairs = numOutStreams - 1;
        folder.BindPairs.clear();
        folder.BindPairs.ensureCapacity(numBindPairs);
        for (int i = 0; i < numBindPairs; ++i) {
            BindPair bindPair = new BindPair();
            bindPair.InIndex = this.inStream.ReadNum();
            bindPair.OutIndex = this.inStream.ReadNum();
            folder.BindPairs.add(bindPair);
        }
        int numPackedStreams = numInStreams - numBindPairs;
        folder.PackStreams.Reserve(numPackedStreams);
        if (numPackedStreams == 1) {
            for (int j = 0; j < numInStreams; ++j) {
                if (folder.FindBindPairForInStream(j) >= 0) continue;
                folder.PackStreams.add(j);
                break;
            }
        } else {
            for (int i = 0; i < numPackedStreams; ++i) {
                int packStreamInfo = this.inStream.ReadNum();
                folder.PackStreams.add(packStreamInfo);
            }
        }
        return folder;
    }

    private void Fill() throws IOException {
        this.FillFolderStartPackStream();
        this.FillStartPos();
        this.FillFolderStartFileIndex();
    }

    private void FillFolderStartPackStream() {
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartPackStreamIndex.Reserve(this.Folders.size());
        int startPos = 0;
        for (int i = 0; i < this.Folders.size(); ++i) {
            this.FolderStartPackStreamIndex.add(startPos);
            startPos += this.Folders.get((int)i).PackStreams.size();
        }
    }

    private void FillStartPos() {
        this.PackStreamStartPositions.clear();
        this.PackStreamStartPositions.Reserve(this.PackSizes.size());
        long startPos = 0L;
        for (int i = 0; i < this.PackSizes.size(); ++i) {
            this.PackStreamStartPositions.add(startPos);
            startPos += this.PackSizes.get(i);
        }
    }

    private void FillFolderStartFileIndex() throws IOException {
        this.FolderStartFileIndex.clear();
        this.FolderStartFileIndex.Reserve(this.Folders.size());
        this.FileIndexToFolderIndexMap.clear();
        this.FileIndexToFolderIndexMap.Reserve(this.Files.size());
        int folderIndex = 0;
        int indexInFolder = 0;
        for (int i = 0; i < this.Files.size(); ++i) {
            boolean emptyStream;
            FileItem file = this.Files.get(i);
            boolean bl = emptyStream = !file.HasStream;
            if (emptyStream && indexInFolder == 0) {
                this.FileIndexToFolderIndexMap.add(-1);
                continue;
            }
            if (indexInFolder == 0) {
                while (true) {
                    if (folderIndex >= this.Folders.size()) {
                        throw new IOException("Incorrect Header");
                    }
                    this.FolderStartFileIndex.add(i);
                    if (this.NumUnPackStreamsVector.get(folderIndex) != 0) break;
                    ++folderIndex;
                }
            }
            this.FileIndexToFolderIndexMap.add(folderIndex);
            if (emptyStream || ++indexInFolder < this.NumUnPackStreamsVector.get(folderIndex)) continue;
            ++folderIndex;
            indexInFolder = 0;
        }
    }

    public void clear() {
        this.ArchiveInfo.FileInfoPopIDs.clear();
        this.PackStreamStartPositions.clear();
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartFileIndex.clear();
        this.FileIndexToFolderIndexMap.clear();
        this.PackSizes.clear();
        this.PackCRCsDefined.clear();
        this.PackCRCs.clear();
        this.Folders.clear();
        this.NumUnPackStreamsVector.clear();
        this.Files.clear();
    }

    public long GetFolderFullPackSize(int folderIndex) {
        int packStreamIndex = this.FolderStartPackStreamIndex.get(folderIndex);
        Folder folder = this.Folders.get(folderIndex);
        long size = 0L;
        for (int i = 0; i < folder.PackStreams.size(); ++i) {
            size += this.PackSizes.get(packStreamIndex + i);
        }
        return size;
    }

    public long GetFolderStreamPos(int folderIndex, int indexInFolder) {
        return this.ArchiveInfo.DataStartPosition + this.PackStreamStartPositions.get(this.FolderStartPackStreamIndex.get(folderIndex) + indexInFolder);
    }
}

