/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.filechooser;

import VASSAL.configure.DirectoryConfigurer;
import VASSAL.tools.filechooser.DirectoryFileFilter;
import VASSAL.tools.filechooser.FileFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;

public abstract class FileChooser {
    protected Component parent;
    protected DirectoryConfigurer prefs;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;

    protected FileChooser(Component component, DirectoryConfigurer directoryConfigurer) {
        this.parent = component;
        this.prefs = directoryConfigurer;
    }

    public static FileChooser createFileChooser(Component component) {
        return FileChooser.createFileChooser(component, null);
    }

    public static FileChooser createFileChooser(Component component, DirectoryConfigurer directoryConfigurer) {
        return FileChooser.createFileChooser(component, directoryConfigurer, 0);
    }

    public static FileChooser createFileChooser(Component component, DirectoryConfigurer directoryConfigurer, int n) {
        FileChooser fileChooser = SystemUtils.IS_OS_MAC_OSX ? new NativeFileChooser(component, directoryConfigurer, n) : (n == 0 && SystemUtils.IS_OS_WINDOWS ? new NativeFileChooser(component, directoryConfigurer, n) : new SwingFileChooser(component, directoryConfigurer, n));
        return fileChooser;
    }

    public abstract File getCurrentDirectory();

    public abstract void setCurrentDirectory(File var1);

    public abstract void rescanCurrentDirectory();

    public abstract File getSelectedFile();

    public abstract void setSelectedFile(File var1);

    public abstract String getDialogTitle();

    public abstract void setDialogTitle(String var1);

    public abstract int showOpenDialog(Component var1);

    public abstract int showSaveDialog(Component var1);

    public abstract FileFilter getFileFilter();

    public abstract void setFileFilter(FileFilter var1);

    public abstract void addChoosableFileFilter(FileFilter var1);

    public abstract boolean removeChoosableFileFilter(FileFilter var1);

    public abstract void resetChoosableFileFilters();

    public void selectDotSavFile() {
        int n;
        String string;
        File file = this.getSelectedFile();
        if (file != null && (string = file.getPath()) != null && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n) + ".vsav";
            this.setSelectedFile(new File(string));
        }
    }

    public int showOpenDialog() {
        return this.showOpenDialog(this.parent);
    }

    public int showSaveDialog() {
        return this.showSaveDialog(this.parent);
    }

    protected void updateDirectoryPreference() {
        if (this.prefs != null && this.getCurrentDirectory() != null && !this.getCurrentDirectory().equals(this.prefs.getFileValue())) {
            this.prefs.setValue(this.getCurrentDirectory());
        }
    }

    private static class NativeFileChooser
    extends FileChooser {
        private File cur;
        private String title;
        private FileFilter filter;
        private int mode = 0;
        protected static final boolean isJava15;
        protected static final Frame dummy;

        public NativeFileChooser(Component component, DirectoryConfigurer directoryConfigurer, int n) {
            super(component, directoryConfigurer);
            if (directoryConfigurer != null && directoryConfigurer.getFileValue() != null) {
                this.setCurrentDirectory(directoryConfigurer.getFileValue());
            }
            this.mode = n;
            if (n == 1) {
                this.setFileFilter(new DirectoryFileFilter());
            }
        }

        public File getCurrentDirectory() {
            return this.cur == null ? null : this.cur.getParentFile();
        }

        public void setCurrentDirectory(File file) {
            this.cur = file;
        }

        public void rescanCurrentDirectory() {
        }

        public File getSelectedFile() {
            return this.cur;
        }

        public void setSelectedFile(File file) {
            this.cur = file;
        }

        public int getFileSelectionMode() {
            return this.mode;
        }

        public void setFileSelectionMode(int n) {
            this.mode = n;
        }

        public String getDialogTitle() {
            return this.title;
        }

        public void setDialogTitle(String string) {
            this.title = string;
        }

        protected FileDialog awt_file_dialog_init(Component component) {
            FileDialog fileDialog;
            if (component == null) {
                fileDialog = isJava15 ? new FileDialog(dummy, this.title) : new FileDialog((Frame)null, this.title);
            } else if (component instanceof Dialog) {
                fileDialog = new FileDialog((Dialog)component, this.title);
            } else if (component instanceof Frame) {
                fileDialog = new FileDialog((Frame)component, this.title);
            } else {
                Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component);
                if (dialog != null) {
                    fileDialog = new FileDialog(dialog, this.title);
                } else {
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
                    if (frame != null) {
                        fileDialog = new FileDialog(frame, this.title);
                    } else {
                        throw new IllegalArgumentException("parent is contained in neither a Dialog nor a Frame");
                    }
                }
            }
            fileDialog.setModal(true);
            fileDialog.setFilenameFilter(this.filter);
            if (this.cur != null) {
                if (this.cur.isDirectory()) {
                    fileDialog.setDirectory(this.cur.getPath());
                } else {
                    fileDialog.setDirectory(this.cur.getParent());
                    fileDialog.setFile(this.cur.getName());
                }
            }
            return fileDialog;
        }

        public int showOpenDialog(Component component) {
            int n;
            FileDialog fileDialog = this.awt_file_dialog_init(component);
            fileDialog.setMode(0);
            System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(this.mode == 1));
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.cur = new File(fileDialog.getDirectory(), fileDialog.getFile());
                n = 0;
            } else {
                n = 1;
            }
            this.updateDirectoryPreference();
            return n;
        }

        public int showSaveDialog(Component component) {
            int n;
            FileDialog fileDialog = this.awt_file_dialog_init(component);
            fileDialog.setMode(1);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.cur = new File(fileDialog.getDirectory(), fileDialog.getFile());
                n = 0;
            } else {
                n = 1;
            }
            this.updateDirectoryPreference();
            return n;
        }

        public FileFilter getFileFilter() {
            return this.filter;
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public void addChoosableFileFilter(FileFilter fileFilter) {
        }

        public boolean removeChoosableFileFilter(FileFilter fileFilter) {
            return false;
        }

        public void resetChoosableFileFilters() {
        }

        static {
            String string = System.getProperty("java.version");
            isJava15 = string == null || string.startsWith("1.5");
            dummy = isJava15 ? new Frame() : null;
        }
    }

    private static class SwingFileChooser
    extends FileChooser {
        private JFileChooser fc = new JFileChooser();

        public SwingFileChooser(Component component, DirectoryConfigurer directoryConfigurer, int n) {
            super(component, directoryConfigurer);
            if (directoryConfigurer != null && directoryConfigurer.getFileValue() != null) {
                this.setCurrentDirectory(directoryConfigurer.getFileValue());
            }
            if (n == 1) {
                this.setFileFilter(new DirectoryFileFilter());
            }
            this.fc.setFileSelectionMode(n);
        }

        public File getCurrentDirectory() {
            return this.fc.getCurrentDirectory();
        }

        public void setCurrentDirectory(File file) {
            this.fc.setCurrentDirectory(file);
        }

        public void rescanCurrentDirectory() {
            this.fc.rescanCurrentDirectory();
        }

        public File getSelectedFile() {
            return this.fc.getSelectedFile();
        }

        public void setSelectedFile(File file) {
            this.fc.setSelectedFile(file);
        }

        public int getFileSelectionMode() {
            return this.fc.getFileSelectionMode();
        }

        public void setFileSelectionMode(int n) {
            this.fc.setFileSelectionMode(n);
        }

        public String getDialogTitle() {
            return this.fc.getDialogTitle();
        }

        public void setDialogTitle(String string) {
            this.fc.setDialogTitle(string);
        }

        public int showOpenDialog(Component component) {
            int n = this.fc.showOpenDialog(component);
            this.updateDirectoryPreference();
            return n;
        }

        public int showSaveDialog(Component component) {
            int n = this.fc.showSaveDialog(component);
            if (n == 0 && this.getSelectedFile().exists() && 1 == JOptionPane.showConfirmDialog(component, "Overwrite " + this.getSelectedFile().getName() + "?", "File Exists", 0)) {
                n = 1;
            }
            this.updateDirectoryPreference();
            return n;
        }

        public FileFilter getFileFilter() {
            javax.swing.filechooser.FileFilter fileFilter = this.fc.getFileFilter();
            return fileFilter instanceof FileFilter ? (FileFilter)fileFilter : null;
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.fc.setFileFilter(fileFilter);
        }

        public void addChoosableFileFilter(FileFilter fileFilter) {
            this.fc.addChoosableFileFilter(fileFilter);
        }

        public boolean removeChoosableFileFilter(FileFilter fileFilter) {
            return this.fc.removeChoosableFileFilter(fileFilter);
        }

        public void resetChoosableFileFilters() {
            this.fc.resetChoosableFileFilters();
        }
    }
}

