/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent.listener;

import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.EventListenerSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventListenerSupport<T>
implements EventListenerSupport<T> {
    protected final List<EventListener<? super T>> listeners = new CopyOnWriteArrayList<EventListener<? super T>>();
    protected final Object src;

    public DefaultEventListenerSupport(Object object) {
        this.src = object;
    }

    @Override
    public void addEventListener(EventListener<? super T> eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void removeEventListener(EventListener<? super T> eventListener) {
        this.listeners.remove(eventListener);
    }

    @Override
    public boolean hasEventListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public List<EventListener<? super T>> getEventListeners() {
        return new ArrayList<EventListener<? super T>>(this.listeners);
    }

    @Override
    public void notify(T t) {
        for (EventListener<T> eventListener : this.listeners) {
            eventListener.receive(this.src, t);
        }
    }
}

