/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SynchCommand;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class SynchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final long TOO_SOON = 15000L;
    private static Room lastRoom;
    private static long lastSync;
    private Player p;
    private ChatServerConnection client;
    private Room targetRoom;

    public SynchAction(Player player, ChatServerConnection chatServerConnection) {
        super(Resources.getString("Chat.synchronize"));
        this.p = player;
        this.client = chatServerConnection;
        this.targetRoom = null;
        for (Room room : chatServerConnection.getAvailableRooms()) {
            if (!room.getPlayerList().contains(player)) continue;
            this.targetRoom = room;
        }
        long l = System.currentTimeMillis();
        if (!(player == null || GameModule.getGameModule() == null || player.equals(chatServerConnection.getUserInfo()) || chatServerConnection.getRoom() == null || !chatServerConnection.getRoom().equals(this.targetRoom) || this.targetRoom.equals(lastRoom) && l - lastSync <= 15000L)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public static void clearSynchRoom() {
        lastRoom = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            long l = System.currentTimeMillis();
            if (!this.targetRoom.equals(lastRoom) || l - lastSync > 15000L) {
                GameModule.getGameModule().getGameState().setup(false);
                this.client.sendTo(this.p, new SynchCommand(this.client.getUserInfo(), this.client));
                lastSync = l;
            }
            lastRoom = this.targetRoom;
        }
    }

    public static PlayerActionFactory factory(final ChatServerConnection chatServerConnection) {
        return new PlayerActionFactory(){

            public Action getAction(SimplePlayer simplePlayer, JTree jTree) {
                Room room = chatServerConnection.getRoom();
                if (chatServerConnection instanceof LockableChatServerConnection && ((LockableChatServerConnection)chatServerConnection).isDefaultRoom(room)) {
                    return null;
                }
                return new SynchAction(simplePlayer, chatServerConnection);
            }
        };
    }

    static {
        lastSync = System.currentTimeMillis();
    }
}

