/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.ChangePropertyButton;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.TemporaryToolBar;
import VASSAL.tools.ToolBarComponent;
import java.beans.PropertyChangeListener;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalProperty
extends AbstractConfigurable
implements ToolBarComponent,
GameComponent,
CommandEncoder,
PropertySource,
MutableProperty {
    public static final String NAME = "name";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String DESCRIPTION = "description";
    public static final String NUMERIC = "isNumeric";
    public static final String MIN_VALUE = "min";
    public static final String MAX_VALUE = "max";
    public static final String WRAP = "wrap";
    protected static final String COMMAND_PREFIX = "GlobalProperty\t";
    protected TemporaryToolBar tempToolbar = new TemporaryToolBar();
    protected String description;
    protected String initialValue;
    protected boolean numeric;
    protected String minValue;
    protected String maxValue;
    protected boolean wrap;
    protected VisibilityCondition numericVisibility;
    protected FormattedString format = new FormattedString();
    protected PropertySource propertySource;
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);
    protected MutablePropertiesContainer parentContainer;

    public GlobalProperty() {
        this.numericVisibility = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return GlobalProperty.this.isNumeric();
            }
        };
    }

    public GlobalProperty(GlobalProperty globalProperty) {
        this();
        this.setConfigureName(globalProperty.getConfigureName());
        this.description = globalProperty.description;
        this.initialValue = globalProperty.initialValue;
        this.numeric = globalProperty.numeric;
        this.minValue = globalProperty.minValue;
        this.maxValue = globalProperty.maxValue;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Initial value:  ", "Description:  ", "Is Numeric", "Minimum value:  ", "Maximum value:  ", "Wrap around"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, Boolean.class, String.class, String.class, Boolean.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, INITIAL_VALUE, DESCRIPTION, NUMERIC, MIN_VALUE, MAX_VALUE, WRAP};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            this.property.setPropertyName(this.getConfigureName());
        } else if (INITIAL_VALUE.equals(string)) {
            this.initialValue = (String)object;
            if (this.initialValue == null) {
                this.initialValue = "";
            }
            this.property.setPropertyValue(this.initialValue);
        } else if (DESCRIPTION.equals(string)) {
            this.description = (String)object;
        } else if (NUMERIC.equals(string)) {
            this.numeric = Boolean.TRUE.equals(object) || "true".equals(object);
        } else if (MIN_VALUE.equals(string)) {
            this.minValue = (String)object;
        } else if (MAX_VALUE.equals(string)) {
            this.maxValue = (String)object;
        } else if (WRAP.equals(string)) {
            this.wrap = Boolean.TRUE.equals(object) || "true".equals(object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (INITIAL_VALUE.equals(string)) {
            return this.initialValue;
        }
        if (DESCRIPTION.equals(string)) {
            return this.description;
        }
        if (NUMERIC.equals(string)) {
            return String.valueOf(this.numeric);
        }
        if (MIN_VALUE.equals(string)) {
            return String.valueOf(this.minValue);
        }
        if (MAX_VALUE.equals(string)) {
            return String.valueOf(this.maxValue);
        }
        if (WRAP.equals(string)) {
            return String.valueOf(this.wrap);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (MIN_VALUE.equals(string) || MAX_VALUE.equals(string) || WRAP.equals(string)) {
            return this.numericVisibility;
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.property.removeFromContainer();
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.htm");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ChangePropertyButton.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        this.parentContainer = (MutablePropertiesContainer)((Object)buildable);
        this.property.addTo(this.parentContainer);
        this.tempToolbar.setDelegate((ToolBarComponent)((Object)buildable));
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.propertySource = (PropertySource)((Object)buildable);
        this.setAllAttributesUntranslatable();
    }

    @Override
    public JToolBar getToolBar() {
        return this.tempToolbar.getToolBar();
    }

    @Override
    public void setup(boolean bl) {
        if (!bl) {
            this.property.setPropertyValue(this.initialValue);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new SetGlobalProperty(this, "", this.property.getPropertyValue());
    }

    @Override
    public Command decode(String string) {
        SetGlobalProperty setGlobalProperty = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken("");
        if (string2.equals(COMMAND_PREFIX)) {
            String string3 = decoder.nextToken("");
            String string4 = decoder.nextToken("");
            String string5 = decoder.nextToken("");
            if (string3.equals(this.getPropertyId()) && (string5.length() == 0 || string5.equals(this.parentContainer.getMutablePropertiesContainerId()))) {
                setGlobalProperty = new SetGlobalProperty(this, this.property.getPropertyValue(), string4);
            }
        }
        return setGlobalProperty;
    }

    protected String getPropertyId() {
        return this.getConfigureName();
    }

    protected String getContainerId() {
        return this.parentContainer == null ? "" : this.parentContainer.getMutablePropertiesContainerId();
    }

    @Override
    public String encode(Command command) {
        SetGlobalProperty setGlobalProperty;
        String string = null;
        if (command instanceof SetGlobalProperty && (setGlobalProperty = (SetGlobalProperty)command).getTargetName().equals(this.getPropertyId()) && this.getContainerId().equals(setGlobalProperty.getProperty().getContainerId())) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(COMMAND_PREFIX, ';');
            sequenceEncoder.append(this.getPropertyId());
            sequenceEncoder.append(setGlobalProperty.newValue);
            sequenceEncoder.append(this.getContainerId());
            string = sequenceEncoder.getValue();
        }
        return string;
    }

    public int getMaxValue() {
        int n = 100;
        if (this.maxValue != null) {
            this.format.setFormat(this.maxValue);
            try {
                n = Integer.parseInt(this.format.getText(this));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public int getMinValue() {
        int n = 0;
        if (this.minValue != null) {
            this.format.setFormat(this.minValue);
            try {
                n = Integer.parseInt(this.format.getText(this));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getProperty(Object object) {
        return this.propertySource == null ? null : this.propertySource.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        return this.propertySource == null ? null : this.propertySource.getLocalizedProperty(object);
    }

    public static String getConfigureTypeName() {
        return "Global Property";
    }

    @Override
    public void addMutablePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.property.addMutablePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeMutablePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.property.removeMutablePropertyChangeListener(propertyChangeListener);
    }

    public void setPropertyName(String string) {
        this.property.setPropertyName(string);
    }

    @Override
    public Command setPropertyValue(String string) {
        return this.property.setPropertyValue(string);
    }

    @Override
    public String getPropertyValue() {
        return this.property.getPropertyValue();
    }

    @Override
    public MutablePropertiesContainer getParent() {
        return this.parentContainer;
    }

    public static class SetGlobalProperty
    extends Command {
        protected String newValue;
        protected String oldValue;
        protected GlobalProperty target;
        protected String targetName;

        public SetGlobalProperty(GlobalProperty globalProperty, String string, String string2) {
            this.oldValue = string;
            this.newValue = string2;
            this.target = globalProperty;
        }

        public String getTargetName() {
            if (this.target == null) {
                return "";
            }
            String string = this.target.getPropertyId();
            return string == null ? "" : string;
        }

        public GlobalProperty getProperty() {
            return this.target;
        }

        protected void executeCommand() {
            this.target.property.setPropertyValue(this.newValue);
        }

        protected Command myUndoCommand() {
            return new SetGlobalProperty(this.target, this.newValue, this.oldValue);
        }
    }
}

