/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBoxItem
extends TextItem {
    public static final String TYPE = "TextBox";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String USE_HTML = "use_html";
    protected int height = 30;
    protected int width = 40;
    protected boolean isHTML = false;

    public TextBoxItem() {
    }

    public TextBoxItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
    }

    public TextBoxItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return ArrayUtils.insert(super.getAttributeDescriptions(), 2, "Width:  ", "Height:  ", "Use HTML:  ");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class[] classArray = ArrayUtils.insert(super.getAttributeTypes(), 2, Integer.class, Integer.class, Boolean.class);
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"text".equals(stringArray[i])) continue;
            classArray[i] = TextConfigurer.class;
            break;
        }
        return classArray;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if ("font".equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !TextBoxItem.this.isHTML;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public String[] getAttributeNames() {
        return ArrayUtils.insert(super.getAttributeNames(), 2, WIDTH, HEIGHT, USE_HTML);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.width = (Integer)object;
            if (this.width < 1) {
                this.width = 1;
            }
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.height = (Integer)object;
            if (this.height < 1) {
                this.height = 1;
            }
        } else if (USE_HTML.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.isHTML = Boolean.TRUE.equals(object);
        } else {
            super.setAttribute(string, object);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (WIDTH.equals(string)) {
            return String.valueOf(this.width);
        }
        if (HEIGHT.equals(string)) {
            return String.valueOf(this.height);
        }
        if (USE_HTML.equals(string)) {
            return String.valueOf(this.isHTML);
        }
        return super.getAttributeValueString(string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        Serializable serializable;
        ItemInstance itemInstance = null;
        if (gamePieceImage != null) {
            itemInstance = gamePieceImage.getTextBoxInstance(this.getConfigureName());
        }
        if (itemInstance == null) {
            itemInstance = new TextBoxItemInstance();
        }
        Color color = itemInstance.getFgColor().getColor();
        Color color2 = itemInstance.getBgColor().getColor();
        Point point = this.layout.getPosition(this);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        String string = null;
        if (this.textSource.equals("Fixed for this layout")) {
            string = this.text;
        } else if (gamePieceImage != null && itemInstance != null) {
            string = ((TextBoxItemInstance)itemInstance).getValue();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        AffineTransform affineTransform = null;
        if (this.getRotation() != 0) {
            affineTransform = graphics2D.getTransform();
            serializable = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.getLayout().getVisualizerWidth() / 2, this.getLayout().getVisualizerHeight() / 2);
            graphics2D.transform((AffineTransform)serializable);
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        serializable = new JTextPane();
        if (this.isHTML) {
            ((JEditorPane)serializable).setContentType("text/html");
        }
        ((JEditorPane)serializable).setText(string);
        ((Component)serializable).setSize(this.width - 2, this.height - 2);
        ((JComponent)serializable).setBackground(color2 != null ? color2 : new Color(0, true));
        ((JComponent)serializable).setForeground(color != null ? color : new Color(0, true));
        FontStyle fontStyle = FontManager.getFontManager().getFontStyle(this.fontStyleName);
        OutlineFont outlineFont = fontStyle.getFont();
        ((JComponent)serializable).setFont(outlineFont);
        BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(Math.max(((JComponent)serializable).getWidth(), 1), Math.max(((JComponent)serializable).getHeight(), 1));
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        ((JComponent)serializable).paint(graphics2D2);
        graphics2D2.dispose();
        graphics2D.drawImage((Image)bufferedImage, point.x + 1, point.y + 1, null);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return "Text Box";
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        TextBoxItem textBoxItem = new TextBoxItem(gamePieceLayout);
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        String string2 = decoder.nextToken("");
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, ';');
        decoder2.nextToken();
        textBoxItem.width = decoder2.nextInt(30);
        textBoxItem.height = decoder2.nextInt(40);
        textBoxItem.isHTML = decoder2.nextBoolean(false);
        TextItem.decode(textBoxItem, decoder.nextToken(""));
        return textBoxItem;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.width);
        sequenceEncoder.append(this.height);
        sequenceEncoder.append(this.isHTML);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), ',');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }
}

