/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalBorders;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public class ColumnHeaderRendererAddon
extends AbstractComponentAddon {
    private static final Logger LOG = Logger.getLogger(ColumnHeaderRendererAddon.class.getName());

    public ColumnHeaderRendererAddon() {
        super("ColumnHeaderRenderer");
    }

    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addBasicDefaults(addon, defaults);
        defaults.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-up.png"));
        defaults.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-dn.png"));
        this.hackMetalBorder(addon, defaults);
    }

    private void hackMetalBorder(LookAndFeelAddons addon, DefaultsList defaults) {
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        if (border instanceof MetalBorders.TableHeaderBorder) {
            border = new BorderUIResource.CompoundBorderUIResource(border, BorderFactory.createEmptyBorder());
            defaults.add("ColumnHeaderRenderer.metalBorderHack", border);
        }
    }

    protected void addLinuxDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addLinuxDefaults(addon, defaults);
        if (this.isSynth()) {
            defaults.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-up.png"));
            defaults.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-dn.png"));
        }
    }

    protected void addMacDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addMacDefaults(addon, defaults);
        defaults.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-up.png"));
        defaults.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-dn.png"));
    }

    protected void addWindowsDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addWindowsDefaults(addon, defaults);
        if (OS.isWindowsXP()) {
            defaults.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-up.png"));
            defaults.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-dn.png"));
        } else {
            defaults.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-up.png"));
            defaults.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-dn.png"));
        }
        this.hackVistaHeaderBorder(addon, defaults);
    }

    private void hackVistaHeaderBorder(LookAndFeelAddons addon, DefaultsList defaults) {
        if (!OS.isWindowsVista() || addon instanceof WindowsClassicLookAndFeelAddons) {
            return;
        }
        defaults.add("ColumnHeaderRenderer.vistaBorderHack", new BorderUIResource.EmptyBorderUIResource(5, 5, 5, 5));
    }
}

