/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

final class AttributeImpl
extends NodeImpl
implements Attr {
    private int nameCode;
    private String value;

    public AttributeImpl(ElementImpl elementImpl, int n) {
        this.parent = elementImpl;
        this.index = n;
        AttributeCollection attributeCollection = elementImpl.getAttributeList();
        this.nameCode = attributeCollection.getNameCode(n);
        this.value = attributeCollection.getValue(n);
    }

    @Override
    public int getNameCode() {
        return this.nameCode;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        AttributeImpl attributeImpl = (AttributeImpl)nodeInfo;
        return this.parent.isSameNode(attributeImpl.parent) && (this.nameCode & 0xFFFFF) == (attributeImpl.nameCode & 0xFFFFF);
    }

    @Override
    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    @Override
    public final short getNodeType() {
        return 2;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    @Override
    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (this == nodeImpl) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    @Override
    public String generateId() {
        return this.parent.generateId() + "_a" + this.getFingerprint();
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        int n = this.getNameCode();
        if ((n >> 20 & 0xFF) != 0) {
            n = outputter.checkAttributePrefix(n);
        }
        outputter.writeAttribute(n, this.getStringValue());
    }
}

