/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLGeneralOutput;
import com.icl.saxon.tree.AttributeCollection;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLOutput
extends XSLGeneralOutput {
    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        super.prepareAttributes();
        if (this.href != null) {
            this.compileError("The href attribute is not allowed on this element");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
        if (!this.forwardsCompatibleModeIsEnabled()) {
            AttributeCollection attributeCollection = this.getAttributeList();
            for (int i = 0; i < attributeCollection.getLength(); ++i) {
                if (attributeCollection.getValue(i).indexOf(123) < 0) continue;
                this.compileError("To use attribute value templates in xsl:output, set xsl:stylesheet version='1.1'");
                break;
            }
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
    }

    protected Properties gatherOutputProperties(Properties properties) {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        if (this.method != null) {
            properties.put("method", attributeCollection.getValueByFingerprint(standardNames.METHOD));
        }
        if (this.version != null) {
            properties.put("version", attributeCollection.getValueByFingerprint(standardNames.VERSION));
        }
        if (this.indent != null) {
            properties.put("indent", attributeCollection.getValueByFingerprint(standardNames.INDENT));
        }
        if (this.indentSpaces != null) {
            properties.put("{http://icl.com/saxon}indent-spaces", attributeCollection.getValueByFingerprint(standardNames.SAXON_INDENT_SPACES));
        }
        if (this.encoding != null) {
            properties.put("encoding", attributeCollection.getValueByFingerprint(standardNames.ENCODING));
        }
        if (this.mediaType != null) {
            properties.put("media-type", attributeCollection.getValueByFingerprint(standardNames.MEDIA_TYPE));
        }
        if (this.doctypeSystem != null) {
            properties.put("doctype-system", attributeCollection.getValueByFingerprint(standardNames.DOCTYPE_SYSTEM));
        }
        if (this.doctypePublic != null) {
            properties.put("doctype-public", attributeCollection.getValueByFingerprint(standardNames.DOCTYPE_PUBLIC));
        }
        if (this.omitDeclaration != null) {
            properties.put("omit-xml-declaration", attributeCollection.getValueByFingerprint(standardNames.OMIT_XML_DECLARATION));
        }
        if (this.standalone != null) {
            properties.put("standalone", attributeCollection.getValueByFingerprint(standardNames.STANDALONE));
        }
        if (this.cdataElements != null) {
            String string = properties.getProperty("cdata-section-elements");
            String string2 = string + " " + attributeCollection.getValueByFingerprint(standardNames.CDATA_SECTION_ELEMENTS);
            properties.put("cdata-section-elements", string2);
        }
        if (this.nextInChain != null) {
            // empty if block
        }
        if (this.requireWellFormed != null) {
            properties.put("{http://saxon.sf.net/}require-well-formed", attributeCollection.getValueByFingerprint(standardNames.SAXON_REQUIRE_WELL_FORMED));
        }
        return properties;
    }
}

