/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.sort.HashMap;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class HTMLIndenter
extends ProxyEmitter {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private static String[] inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button"};
    private static HashMap inlineTable = new HashMap(203);
    private static HashMap formattedTable;

    private static boolean isInline(String string) {
        return inlineTable.get(string);
    }

    private static boolean isFormatted(String string) {
        return formattedTable.get(string);
    }

    @Override
    public void startDocument() throws TransformerException {
        super.startDocument();
        String string = this.outputProperties.getProperty("{http://icl.com/saxon}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.indentSpaces = 3;
            }
        }
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        String string = this.namePool.getDisplayName(n);
        this.isInlineTag = HTMLIndenter.isInline(string);
        boolean bl = this.inFormattedTag = this.inFormattedTag || HTMLIndenter.isFormatted(string);
        if (!(this.isInlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        super.startElement(n, attributes, nArray, n2);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    @Override
    public void endElement(int n) throws TransformerException {
        --this.level;
        String string = this.namePool.getDisplayName(n);
        boolean bl = HTMLIndenter.isInline(string);
        boolean bl2 = HTMLIndenter.isFormatted(string);
        if (!(bl || bl2 || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = bl;
            this.afterFormatted = bl2;
        }
        super.endElement(n);
        this.inFormattedTag = this.inFormattedTag && !bl2;
        this.sameLine = false;
    }

    @Override
    public void processingInstruction(String string, String string2) throws TransformerException {
        super.processingInstruction(string, string2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (this.inFormattedTag) {
            super.characters(cArray, n, n2);
        } else {
            int n3 = n;
            for (int i = n; i < n + n2; ++i) {
                if (cArray[i] != '\n' && (i - n3 <= 120 || cArray[i] != ' ')) continue;
                this.sameLine = false;
                super.characters(cArray, n3, i - n3);
                this.indent();
                for (n3 = i + 1; n3 < n2 && cArray[n3] == ' '; ++n3) {
                }
            }
            if (n3 < n + n2) {
                super.characters(cArray, n3, n + n2 - n3);
            }
        }
        this.afterInline = false;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws TransformerException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        this.indent();
        super.comment(cArray, n, n2);
    }

    @Override
    public void endDocument() throws TransformerException {
        super.endDocument();
    }

    private void indent() throws TransformerException {
        int n = this.level * this.indentSpaces;
        while (n > this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        char[] cArray = new char[n + 1];
        cArray[0] = 10;
        this.indentChars.getChars(0, n, cArray, 1);
        super.characters(cArray, 0, n + 1);
        this.sameLine = false;
    }

    static {
        for (int i = 0; i < inlineTags.length; ++i) {
            inlineTable.set(inlineTags[i]);
        }
        formattedTable = new HashMap(51);
        formattedTable.set("pre");
        formattedTable.set("script");
        formattedTable.set("style");
        formattedTable.set("textarea");
        formattedTable.set("xmp");
    }
}

