/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.style.StandardNames;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class NamePool {
    private static NamePool defaultNamePool = new NamePool();
    private StandardNames standardNames = null;
    NameEntry[] hashslots = new NameEntry[1024];
    String[] prefixes = new String[100];
    short prefixesUsed = 0;
    String[] uris = new String[100];
    String[] prefixesForUri = new String[100];
    short urisUsed = 0;
    Vector signatures = new Vector();
    boolean sealed = false;

    public static NamePool getDefaultNamePool() {
        return defaultNamePool;
    }

    public NamePool() {
        this.prefixes[0] = "";
        this.uris[0] = "";
        this.prefixesForUri[0] = "";
        this.prefixes[1] = "xml";
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        this.prefixesForUri[1] = "xml ";
        this.prefixes[2] = "xsl";
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        this.prefixesForUri[2] = "xsl ";
        this.prefixes[3] = "saxon";
        this.uris[3] = "http://icl.com/saxon";
        this.prefixesForUri[3] = "saxon ";
        this.prefixes[4] = "func";
        this.uris[4] = "http://exslt.org/functions";
        this.prefixesForUri[4] = "func ";
        this.prefixesUsed = (short)5;
        this.urisUsed = (short)5;
    }

    public synchronized void loadStandardNames() {
        if (this.standardNames == null) {
            this.standardNames = new StandardNames(this);
            this.standardNames.allocateNames();
        }
    }

    public StandardNames getStandardNames() {
        return this.standardNames;
    }

    public synchronized void setStylesheetSignature(Object object) {
        this.signatures.addElement(new Integer(object.hashCode()));
    }

    public boolean hasSignature(Object object) {
        return this.signatures.contains(new Integer(object.hashCode()));
    }

    public synchronized void importPool(NamePool namePool) throws TransformerException {
        int n;
        if (this.signatures.size() > 0) {
            throw new TransformerException("Cannot merge names into a non-empty namepool");
        }
        for (n = 0; n < namePool.signatures.size(); ++n) {
            this.signatures.addElement(namePool.signatures.elementAt(n));
        }
        for (n = 0; n < 1024; ++n) {
            NameEntry nameEntry = namePool.hashslots[n];
            NameEntry nameEntry2 = null;
            while (nameEntry != null) {
                NameEntry nameEntry3 = new NameEntry(nameEntry.uriCode, nameEntry.localName);
                if (nameEntry2 == null) {
                    this.hashslots[n] = nameEntry3;
                } else {
                    nameEntry2.nextEntry = nameEntry3;
                }
                nameEntry2 = nameEntry3;
                nameEntry = nameEntry.nextEntry;
            }
        }
        this.prefixesUsed = namePool.prefixesUsed;
        this.urisUsed = namePool.urisUsed;
        if (this.prefixesUsed > 60) {
            this.prefixes = new String[this.prefixesUsed * 2];
        }
        if (this.urisUsed > 60) {
            this.uris = new String[this.urisUsed * 2];
            this.prefixesForUri = new String[this.urisUsed * 2];
        }
        System.arraycopy(namePool.prefixes, 0, this.prefixes, 0, this.prefixesUsed);
        System.arraycopy(namePool.uris, 0, this.uris, 0, this.urisUsed);
        System.arraycopy(namePool.prefixesForUri, 0, this.prefixesForUri, 0, this.urisUsed);
        namePool.sealed = true;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    private NameEntry getNameEntry(int n) {
        int n2 = n & 0x3FF;
        int n3 = n >> 10 & 0x3FF;
        NameEntry nameEntry = this.hashslots[n2];
        for (int i = 0; i < n3; ++i) {
            if (nameEntry == null) {
                return null;
            }
            nameEntry = nameEntry.nextEntry;
        }
        return nameEntry;
    }

    public synchronized int allocateNamespaceCode(String string, String string2) {
        String string3;
        short s = this.allocateCodeForPrefix(string);
        short s2 = this.allocateCodeForURI(string2);
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + " ") < 0) {
            short s3 = s2;
            this.prefixesForUri[s3] = this.prefixesForUri[s3] + string3;
        }
        return (s << 16) + s2;
    }

    public int getNamespaceCode(String string, String string2) {
        String string3;
        short s = this.getCodeForPrefix(string);
        if (s < 0) {
            return -1;
        }
        short s2 = this.getCodeForURI(string2);
        if (s2 < 0) {
            return -1;
        }
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + " ") < 0) {
            return -1;
        }
        return (s << 16) + s2;
    }

    public synchronized short allocateCodeForURI(String string) {
        for (short s = 0; s < this.urisUsed; s = (short)(s + 1)) {
            if (!this.uris[s].equals(string)) continue;
            return s;
        }
        if (this.sealed) {
            throw new IllegalArgumentException("Namepool has been sealed");
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new IllegalArgumentException("Too many namespace URIs");
            }
            String[] stringArray = new String[this.urisUsed * 2];
            String[] stringArray2 = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixesForUri, 0, stringArray, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, stringArray2, 0, this.urisUsed);
            this.prefixesForUri = stringArray;
            this.uris = stringArray2;
        }
        this.uris[this.urisUsed] = string;
        this.prefixesForUri[this.urisUsed] = "";
        short s = this.urisUsed;
        this.urisUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForURI(String string) {
        for (short s = 0; s < this.urisUsed; s = (short)(s + 1)) {
            if (!this.uris[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    public synchronized short allocateCodeForPrefix(String string) {
        for (short s = 0; s < this.prefixesUsed; s = (short)(s + 1)) {
            if (!this.prefixes[s].equals(string)) continue;
            return s;
        }
        if (this.sealed) {
            throw new IllegalArgumentException("Namepool has been sealed");
        }
        if (this.prefixesUsed >= this.prefixes.length) {
            if (this.prefixesUsed > 32000) {
                throw new IllegalArgumentException("Too many namespace prefixes");
            }
            String[] stringArray = new String[this.prefixesUsed * 2];
            System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixesUsed);
            this.prefixes = stringArray;
        }
        this.prefixes[this.prefixesUsed] = string;
        short s = this.prefixesUsed;
        this.prefixesUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForPrefix(String string) {
        for (short s = 0; s < this.prefixesUsed; s = (short)(s + 1)) {
            if (!this.prefixes[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    public int getPrefixIndex(short s, String string) {
        if (string.equals("")) {
            return 0;
        }
        if (this.prefixesForUri[s].equals(string + " ")) {
            return 1;
        }
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        while (stringTokenizer.hasMoreElements()) {
            if (string.equals(stringTokenizer.nextElement())) {
                return n;
            }
            if (n++ != 255) continue;
            throw new IllegalArgumentException("Too many prefixes for one namespace URI");
        }
        return -1;
    }

    public String getPrefixWithIndex(short s, int n) {
        if (n == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        int n2 = 1;
        while (stringTokenizer.hasMoreElements()) {
            String string = (String)stringTokenizer.nextElement();
            if (n2++ != n) continue;
            return string;
        }
        return null;
    }

    public synchronized int allocate(String string, String string2, String string3) {
        short s = this.allocateCodeForURI(string2);
        return this.allocate(string, s, string3);
    }

    public synchronized int allocate(String string, short s, String string2) {
        int n = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n2 = 0;
        int n3 = this.getPrefixIndex(s, string);
        if (n3 < 0) {
            short s2 = s;
            this.prefixesForUri[s2] = this.prefixesForUri[s2] + string + " ";
            n3 = this.getPrefixIndex(s, string);
        }
        NameEntry nameEntry = null;
        if (this.hashslots[n] == null) {
            if (this.sealed) {
                throw new IllegalArgumentException("Namepool has been sealed");
            }
            this.hashslots[n] = nameEntry = new NameEntry(s, string2);
        } else {
            nameEntry = this.hashslots[n];
            while (true) {
                boolean bl;
                boolean bl2 = nameEntry.localName.equals(string2);
                boolean bl3 = bl = nameEntry.uriCode == s;
                if (bl2 && bl) break;
                NameEntry nameEntry2 = nameEntry.nextEntry;
                if (++n2 >= 1024) {
                    throw new IllegalArgumentException("Saxon name pool is full");
                }
                if (nameEntry2 == null) {
                    NameEntry nameEntry3;
                    if (this.sealed) {
                        throw new IllegalArgumentException("Namepool has been sealed");
                    }
                    nameEntry.nextEntry = nameEntry3 = new NameEntry(s, string2);
                    break;
                }
                nameEntry = nameEntry2;
            }
        }
        return (n3 << 20) + (n2 << 10) + n;
    }

    public synchronized int allocateNamespaceCode(int n) {
        String string = this.getPrefix(n);
        short s = this.getURICode(n);
        short s2 = this.allocateCodeForPrefix(string);
        return (s2 << 16) + s;
    }

    public int getNamespaceCode(int n) {
        String string = this.getPrefix(n);
        short s = this.getURICode(n);
        short s2 = this.getCodeForPrefix(string);
        return (s2 << 16) + s;
    }

    public String getURI(int n) {
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return this.uris[nameEntry.uriCode];
    }

    public short getURICode(int n) {
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return nameEntry.uriCode;
    }

    public String getLocalName(int n) {
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return nameEntry.localName;
    }

    public String getPrefix(int n) {
        short s = this.getURICode(n);
        int n2 = n >> 20 & 0xFF;
        return this.getPrefixWithIndex(s, n2);
    }

    public String getDisplayName(int n) {
        int n2;
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        if ((n2 = n >> 20 & 0xFF) == 0) {
            return nameEntry.localName;
        }
        return this.getPrefixWithIndex(nameEntry.uriCode, n2) + ':' + nameEntry.localName;
    }

    private void unknownNameCode(int n) {
        System.err.println("Unknown name code " + n);
        this.diagnosticDump();
        new IllegalArgumentException("Unknown name").printStackTrace();
        throw new IllegalArgumentException("Unknown name code " + n);
    }

    public int getFingerprint(int n) {
        return n & 0xFFFFF;
    }

    public int getFingerprint(String string, String string2) {
        int n;
        short s = -1;
        for (n = 0; n < this.urisUsed; n = (int)((short)(n + 1))) {
            if (!this.uris[n].equals(string)) continue;
            s = (short)n;
            break;
        }
        if (s == -1) {
            return -1;
        }
        n = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n2 = 0;
        NameEntry nameEntry = null;
        if (this.hashslots[n] == null) {
            return -1;
        }
        nameEntry = this.hashslots[n];
        while (true) {
            boolean bl;
            boolean bl2 = nameEntry.localName.equals(string2);
            boolean bl3 = bl = nameEntry.uriCode == s;
            if (bl2 && bl) break;
            NameEntry nameEntry2 = nameEntry.nextEntry;
            ++n2;
            if (nameEntry2 == null) {
                return -1;
            }
            nameEntry = nameEntry2;
        }
        return (n2 << 10) + n;
    }

    public String getURIFromNamespaceCode(int n) {
        return this.uris[n & 0xFFFF];
    }

    public String getURIFromURICode(short s) {
        return this.uris[s];
    }

    public String getPrefixFromNamespaceCode(int n) {
        return this.prefixes[n >> 16];
    }

    public synchronized void diagnosticDump() {
        int n;
        System.err.println("Contents of NamePool " + this);
        for (n = 0; n < 1024; ++n) {
            NameEntry nameEntry = this.hashslots[n];
            int n2 = 0;
            while (nameEntry != null) {
                System.err.println("Fingerprint " + n2 + "/" + n);
                System.err.println("  local name = " + nameEntry.localName + " uri code = " + nameEntry.uriCode);
                nameEntry = nameEntry.nextEntry;
                ++n2;
            }
        }
        for (n = 0; n < this.prefixesUsed; ++n) {
            System.err.println("Prefix " + n + " = " + this.prefixes[n]);
        }
        for (n = 0; n < this.urisUsed; ++n) {
            System.err.println("URI " + n + " = " + this.uris[n]);
            System.err.println("Prefixes for URI " + n + " = " + this.prefixesForUri[n]);
        }
    }

    public void generateJavaConstants() {
        System.out.println("// Declarations generated from NamePool");
        for (int i = 0; i < 1024; ++i) {
            NameEntry nameEntry = this.hashslots[i];
            int n = 0;
            while (nameEntry != null) {
                int n2;
                int n3 = (n << 10) + i;
                String string = "";
                if (nameEntry.uriCode == 0) {
                    string = "";
                } else if (nameEntry.uriCode == 2) {
                    string = "XSL_";
                } else if (nameEntry.uriCode == 1) {
                    string = "XML_";
                } else if (nameEntry.uriCode == 3) {
                    string = "SAXON_";
                }
                String string2 = nameEntry.localName.toUpperCase();
                while ((n2 = string2.indexOf(45)) >= 0) {
                    string2 = string2.substring(0, n2) + '_' + string2.substring(n2 + 1);
                }
                System.out.println("public final static int " + string + string2 + " = " + n3 + ";");
                nameEntry = nameEntry.nextEntry;
                ++n;
            }
        }
    }

    static {
        defaultNamePool.loadStandardNames();
    }

    private class NameEntry {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short s, String string) {
            this.uriCode = s;
            this.localName = string;
            this.nextEntry = null;
        }
    }
}

