/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public final class StringValue
extends Value {
    private String value;

    public StringValue(String string) {
        this.value = string == null ? "" : string;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public double asNumber() {
        return Value.stringToNumber(this.value);
    }

    @Override
    public boolean asBoolean() {
        return this.value.length() > 0;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    public int getLength() {
        return StringValue.getLength(this.value);
    }

    public static int getLength(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public static int[] expand(String string) {
        int[] nArray = new int[StringValue.getLength(string)];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2;
            int n3 = string.charAt(i);
            if (n3 >= 55296 && n3 <= 56319) {
                n2 = (n3 - 55296) * 1024 + (string.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                n2 = n3;
            }
            nArray[n++] = n2;
        }
        return nArray;
    }

    public boolean equals(StringValue stringValue) {
        return this.value.equals(stringValue.value);
    }

    @Override
    public int conversionPreference(Class clazz) {
        if (clazz == Object.class) {
            return 50;
        }
        if (clazz.isAssignableFrom(StringValue.class)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 6;
        }
        if (clazz == Boolean.class) {
            return 7;
        }
        if (clazz == Byte.TYPE) {
            return 4;
        }
        if (clazz == Byte.class) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Character.class) {
            return 3;
        }
        if (clazz == Double.TYPE) {
            return 4;
        }
        if (clazz == Double.class) {
            return 5;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Float.class) {
            return 5;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Integer.class) {
            return 5;
        }
        if (clazz == Long.TYPE) {
            return 4;
        }
        if (clazz == Long.class) {
            return 5;
        }
        if (clazz == Short.TYPE) {
            return 4;
        }
        if (clazz == Short.class) {
            return 5;
        }
        if (clazz == String.class) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == Object.class) {
            return this.value;
        }
        if (clazz.isAssignableFrom(StringValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == Boolean.class) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == String.class) {
            return this.value;
        }
        if (clazz == Double.TYPE) {
            return new Double(this.asNumber());
        }
        if (clazz == Double.class) {
            return new Double(this.asNumber());
        }
        if (clazz == Float.TYPE) {
            return new Float(this.asNumber());
        }
        if (clazz == Float.class) {
            return new Float(this.asNumber());
        }
        if (clazz == Long.TYPE) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Long.class) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Integer.TYPE) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Integer.class) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Short.TYPE) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Short.class) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Byte.class) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            if (this.value.length() == 1) {
                return new Character(this.value.charAt(0));
            }
            throw new XPathException("Cannot convert string to Java char unless length is 1");
        }
        throw new XPathException("Conversion of string to " + clazz.getName() + " is not supported");
    }

    @Override
    public void display(int n) {
        System.err.println(StringValue.indent(n) + "string (\"" + this.value + "\")");
    }
}

