/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BinaryExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.IsLastExpression;
import com.icl.saxon.expr.NodeSetComparison;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.PositionRange;
import com.icl.saxon.expr.SingletonComparison;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.BooleanFn;
import com.icl.saxon.functions.Count;
import com.icl.saxon.functions.Last;
import com.icl.saxon.functions.Not;
import com.icl.saxon.functions.Position;
import com.icl.saxon.functions.StringFn;
import com.icl.saxon.functions.StringLength;

final class RelationalExpression
extends BinaryExpression {
    public RelationalExpression() {
    }

    public RelationalExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    @Override
    public Expression simplify() throws XPathException {
        double d;
        this.p1 = this.p1.simplify();
        this.p2 = this.p2.simplify();
        if (this.p1 instanceof SingletonExpression && (this.p2 instanceof StringValue || this.p2 instanceof NumericValue || this.p2 instanceof FragmentValue || this.p2 instanceof TextFragmentValue)) {
            SingletonComparison singletonComparison = new SingletonComparison((SingletonExpression)this.p1, this.operator, (Value)this.p2);
            singletonComparison.setStaticContext(this.getStaticContext());
            return singletonComparison;
        }
        if (this.p2 instanceof SingletonExpression && (this.p1 instanceof StringValue || this.p1 instanceof NumericValue || this.p1 instanceof FragmentValue || this.p1 instanceof TextFragmentValue)) {
            SingletonComparison singletonComparison = new SingletonComparison((SingletonExpression)this.p2, Value.inverse(this.operator), (Value)this.p1);
            singletonComparison.setStaticContext(this.getStaticContext());
            return singletonComparison;
        }
        if (this.p1 instanceof NodeSetExpression && (this.p2 instanceof StringValue || this.p2 instanceof NumericValue || this.p2 instanceof FragmentValue || this.p2 instanceof TextFragmentValue)) {
            NodeSetComparison nodeSetComparison = new NodeSetComparison((NodeSetExpression)this.p1, this.operator, (Value)this.p2);
            nodeSetComparison.setStaticContext(this.getStaticContext());
            return nodeSetComparison;
        }
        if (this.p2 instanceof NodeSetExpression && (this.p1 instanceof StringValue || this.p1 instanceof NumericValue || this.p1 instanceof FragmentValue || this.p1 instanceof TextFragmentValue)) {
            NodeSetComparison nodeSetComparison = new NodeSetComparison((NodeSetExpression)this.p2, Value.inverse(this.operator), (Value)this.p1);
            nodeSetComparison.setStaticContext(this.getStaticContext());
            return nodeSetComparison;
        }
        if (this.p1 instanceof Value && this.p2 instanceof Value) {
            return this.evaluate(null);
        }
        if (this.p1 instanceof Count && ((Count)this.p1).getNumberOfArguments() == 1 && ((Count)this.p1).argument[0].getDataType() == 4 && this.p2 instanceof NumericValue && ((Value)this.p2).asNumber() == 0.0) {
            if (this.operator == 11 || this.operator == 24) {
                Not not = new Not();
                not.addArgument(((Count)this.p1).argument[0]);
                not.setStaticContext(this.getStaticContext());
                return not;
            }
            if (this.operator == 34 || this.operator == 21) {
                BooleanFn booleanFn = new BooleanFn();
                booleanFn.addArgument(((Count)this.p1).argument[0]);
                booleanFn.setStaticContext(this.getStaticContext());
                return booleanFn;
            }
            if (this.operator == 23) {
                return new BooleanValue(true);
            }
            return new BooleanValue(false);
        }
        if (this.p2 instanceof Count && this.p1 instanceof NumericValue && ((Value)this.p1).asNumber() == 0.0) {
            Expression expression = new RelationalExpression(this.p2, Value.inverse(this.operator), this.p1).simplify();
            expression.setStaticContext(this.getStaticContext());
            return expression;
        }
        if (this.p1 instanceof StringLength && ((StringLength)this.p1).getNumberOfArguments() == 1 && this.p2 instanceof NumericValue && ((Value)this.p2).asNumber() == 0.0) {
            Function function;
            Expression expression = ((StringLength)this.p1).argument[0];
            if (!(expression instanceof StringValue)) {
                function = new StringFn();
                function.addArgument(expression);
                expression = function;
            }
            if (this.operator == 11 || this.operator == 24) {
                function = new Not();
                function.addArgument(expression);
                function.setStaticContext(this.getStaticContext());
                return function;
            }
            if (this.operator == 21 || this.operator == 34) {
                function = new BooleanFn();
                function.addArgument(expression);
                function.setStaticContext(this.getStaticContext());
                return function;
            }
            if (this.operator == 23) {
                return new BooleanValue(true);
            }
            return new BooleanValue(false);
        }
        if (this.p2 instanceof StringLength && this.p1 instanceof NumericValue && ((Value)this.p1).asNumber() == 0.0) {
            Expression expression = new RelationalExpression(this.p2, Value.inverse(this.operator), this.p1).simplify();
            expression.setStaticContext(this.getStaticContext());
            return expression;
        }
        if (this.p1 instanceof Position && this.p2 instanceof NumericValue) {
            d = ((NumericValue)this.p2).asNumber();
            switch (this.operator) {
                case 11: {
                    return new PositionRange((int)d, (int)d);
                }
                case 23: {
                    return new PositionRange((int)d, Integer.MAX_VALUE);
                }
                case 34: {
                    break;
                }
                case 22: {
                    return new PositionRange(1, (int)Math.floor(d - 1.0E-11));
                }
                case 21: {
                    return new PositionRange((int)Math.ceil(d + 1.0E-11), Integer.MAX_VALUE);
                }
                case 24: {
                    return new PositionRange(1, (int)d);
                }
            }
        }
        if (this.p1 instanceof NumericValue && this.p2 instanceof Position) {
            d = ((NumericValue)this.p1).asNumber();
            switch (this.operator) {
                case 11: {
                    return new PositionRange((int)d, (int)d);
                }
                case 24: {
                    return new PositionRange((int)d, Integer.MAX_VALUE);
                }
                case 34: {
                    break;
                }
                case 21: {
                    return new PositionRange(1, (int)Math.floor(d - 1.0E-11));
                }
                case 22: {
                    return new PositionRange((int)Math.ceil(d + 1.0E-11), Integer.MAX_VALUE);
                }
                case 23: {
                    return new PositionRange(1, (int)d);
                }
            }
        }
        if (this.p1 instanceof Position && this.p2 instanceof Last) {
            switch (this.operator) {
                case 11: 
                case 23: {
                    return new IsLastExpression(true);
                }
                case 22: 
                case 34: {
                    return new IsLastExpression(false);
                }
                case 21: {
                    return new BooleanValue(false);
                }
                case 24: {
                    return new BooleanValue(true);
                }
            }
        }
        if (this.p1 instanceof Last && this.p2 instanceof Position) {
            switch (this.operator) {
                case 11: 
                case 24: {
                    return new IsLastExpression(true);
                }
                case 21: 
                case 34: {
                    return new IsLastExpression(false);
                }
                case 22: {
                    return new BooleanValue(false);
                }
                case 23: {
                    return new BooleanValue(true);
                }
            }
        }
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        Value value = this.p1.evaluate(context);
        Value value2 = this.p2.evaluate(context);
        return value.compare(this.operator, value2);
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.getDependencies() & n) != 0) {
            RelationalExpression relationalExpression = new RelationalExpression(this.p1.reduce(n, context), this.operator, this.p2.reduce(n, context));
            relationalExpression.setStaticContext(this.getStaticContext());
            return ((Expression)relationalExpression).simplify();
        }
        return this;
    }
}

