/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

class PositionRange
extends Expression {
    private int minPosition;
    private int maxPosition;

    public PositionRange(int n, int n2) {
        this.minPosition = n;
        this.maxPosition = n2;
    }

    @Override
    public Expression simplify() throws XPathException {
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        int n = context.getContextPosition();
        return n >= this.minPosition && n <= this.maxPosition;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public int getDependencies() {
        return 16;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((0x10 & n) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    protected int getMinPosition() {
        return this.minPosition;
    }

    protected int getMaxPosition() {
        return this.maxPosition;
    }

    @Override
    public void display(int n) {
        System.err.println(PositionRange.indent(n) + "positionRange(" + this.minPosition + "," + this.maxPosition + ")");
    }
}

