/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class ObjectValue
extends Value {
    private Object value;

    public ObjectValue(Object object) {
        this.value = object;
    }

    @Override
    public String asString() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public double asNumber() {
        return this.value == null ? Double.NaN : Value.stringToNumber(this.value.toString());
    }

    @Override
    public boolean asBoolean() {
        return this.value == null ? false : this.value.toString().length() > 0;
    }

    @Override
    public int getDataType() {
        return 6;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean equals(ObjectValue objectValue) {
        return this.value.equals(objectValue.value);
    }

    @Override
    public int conversionPreference(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Integer.MAX_VALUE;
        }
        if (clazz == Boolean.class) {
            return Integer.MAX_VALUE;
        }
        if (clazz == Byte.TYPE) {
            return 4;
        }
        if (clazz == Byte.class) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Character.class) {
            return 3;
        }
        if (clazz == Double.TYPE) {
            return 4;
        }
        if (clazz == Double.class) {
            return 5;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Float.class) {
            return 5;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Integer.class) {
            return 5;
        }
        if (clazz == Long.TYPE) {
            return 4;
        }
        if (clazz == Long.class) {
            return 5;
        }
        if (clazz == Short.TYPE) {
            return 4;
        }
        if (clazz == Short.class) {
            return 5;
        }
        if (clazz == String.class) {
            return 1;
        }
        if (clazz == Object.class) {
            return 8;
        }
        if (clazz == this.value.getClass()) {
            return -1;
        }
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Object convertToJava(Class clazz) throws XPathException {
        if (this.value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        if (clazz == Value.class || clazz == ObjectValue.class) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == Boolean.class) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == String.class) {
            return this.asString();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.asNumber());
        }
        if (clazz == Double.class) {
            return new Double(this.asNumber());
        }
        if (clazz == Float.TYPE) {
            return new Float(this.asNumber());
        }
        if (clazz == Float.class) {
            return new Float(this.asNumber());
        }
        if (clazz == Long.TYPE) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Long.class) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Integer.TYPE) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Integer.class) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Short.TYPE) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Short.class) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Byte.class) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            String string = this.asString();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new XPathException("Cannot convert string to Java char unless length is 1");
        }
        throw new XPathException("Conversion of external object to " + clazz.getName() + " is not supported");
    }

    @Override
    public void display(int n) {
        System.err.println(ObjectValue.indent(n) + "** external object **");
    }
}

