/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.StylesheetStripper;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.style.LiteralResultElement;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class PreparedStyleSheet
implements Templates {
    private DocumentImpl styleDoc;
    private TransformerFactoryImpl factory;
    private NamePool namePool;
    private StyleNodeFactory nodeFactory;
    private int errorCount = 0;

    protected PreparedStyleSheet(TransformerFactoryImpl transformerFactoryImpl) {
        this.factory = transformerFactoryImpl;
    }

    @Override
    public Transformer newTransformer() {
        Controller controller = new Controller(this.factory);
        controller.setPreparedStyleSheet(this);
        return controller;
    }

    public TransformerFactoryImpl getTransformerFactory() {
        return this.factory;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    protected void prepare(SAXSource sAXSource) throws TransformerConfigurationException {
        DocumentImpl documentImpl;
        if (this.namePool == null || this.namePool.isSealed()) {
            this.namePool = NamePool.getDefaultNamePool();
        }
        this.nodeFactory = new StyleNodeFactory(this.namePool);
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(this.namePool);
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.setNamePool(this.namePool);
        treeBuilder.setErrorListener(this.factory.getErrorListener());
        treeBuilder.setStripper(stylesheetStripper);
        treeBuilder.setSystemId(sAXSource.getSystemId());
        treeBuilder.setNodeFactory(this.nodeFactory);
        treeBuilder.setDiscardCommentsAndPIs(true);
        treeBuilder.setLineNumbering(true);
        try {
            documentImpl = (DocumentImpl)treeBuilder.build(sAXSource);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null) {
                if (throwable instanceof SAXParseException) {
                    throw new TransformerConfigurationException("Failed to parse stylesheet");
                }
                if (throwable instanceof TransformerConfigurationException) {
                    throw (TransformerConfigurationException)throwable;
                }
                throw new TransformerConfigurationException(throwable);
            }
            throw new TransformerConfigurationException(transformerException);
        }
        if (documentImpl.getDocumentElement() == null) {
            throw new TransformerConfigurationException("Stylesheet is empty or absent");
        }
        this.setStyleSheetDocument(documentImpl);
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    protected void setStyleSheetDocument(DocumentImpl documentImpl) throws TransformerConfigurationException {
        this.styleDoc = documentImpl;
        this.namePool = documentImpl.getNamePool();
        this.nodeFactory = new StyleNodeFactory(this.namePool);
        StyleElement styleElement = (StyleElement)this.styleDoc.getDocumentElement();
        if (styleElement instanceof LiteralResultElement) {
            this.styleDoc = ((LiteralResultElement)styleElement).makeStyleSheet(this);
        }
        if (!(this.styleDoc.getDocumentElement() instanceof XSLStyleSheet)) {
            throw new TransformerConfigurationException("Top-level element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStyleSheet xSLStyleSheet = (XSLStyleSheet)this.styleDoc.getDocumentElement();
        xSLStyleSheet.setPreparedStyleSheet(this);
        xSLStyleSheet.preprocess();
    }

    public DocumentImpl getStyleSheetDocument() {
        return this.styleDoc;
    }

    @Override
    public Properties getOutputProperties() {
        Properties properties = new Properties();
        properties.put("encoding", "utf-8");
        properties.put("omit-xml-declaration", "no");
        properties.put("cdata-section-elements", "");
        Properties properties2 = new Properties(properties);
        ((XSLStyleSheet)this.styleDoc.getDocumentElement()).gatherOutputProperties(properties2);
        return properties2;
    }

    public void reportError(TransformerException transformerException) throws TransformerException {
        ++this.errorCount;
        this.factory.getErrorListener().error(transformerException);
    }

    public DocumentInfo stripWhitespace(Document document) throws TransformerException {
        XSLStyleSheet xSLStyleSheet = (XSLStyleSheet)this.styleDoc.getDocumentElement();
        if (xSLStyleSheet.stripsWhitespace() || !(document instanceof DocumentInfo)) {
            Builder builder = ((Controller)this.newTransformer()).makeBuilder();
            builder.setNamePool(this.namePool);
            return builder.build(this.factory.getSAXSource(new DOMSource(document), false));
        }
        return (DocumentInfo)((Object)document);
    }
}

