/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.GeneralOutputter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;

public class IdentityTransformerHandler
extends ContentEmitter
implements TransformerHandler {
    Result result;
    String systemId;
    Controller controller;
    GeneralOutputter outputter;

    protected IdentityTransformerHandler(Controller controller) {
        this.controller = controller;
        this.setNamePool(controller.getNamePool());
    }

    @Override
    public Transformer getTransformer() {
        return this.controller;
    }

    @Override
    public void setSystemId(String string) {
        this.systemId = string;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        try {
            NamePool namePool = this.controller.getNamePool();
            Properties properties = this.controller.getOutputProperties();
            this.outputter = new GeneralOutputter(namePool);
            this.outputter.setOutputDestination(properties, this.result);
            Emitter emitter = this.outputter.getEmitter();
            this.setNamePool(namePool);
            this.setEmitter(emitter);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.outputter.close();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

