/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objenesis.ObjenesisException;

class SunReflectionFactoryHelper {
    SunReflectionFactoryHelper() {
    }

    public static <T> Constructor<T> newConstructorForSerialization(Class<T> clazz, Constructor<?> constructor) {
        Class<?> clazz2 = SunReflectionFactoryHelper.getReflectionFactoryClass();
        Object object = SunReflectionFactoryHelper.createReflectionFactory(clazz2);
        Method method = SunReflectionFactoryHelper.getNewConstructorForSerializationMethod(clazz2);
        try {
            return (Constructor)method.invoke(object, clazz, constructor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjenesisException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjenesisException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjenesisException(invocationTargetException);
        }
    }

    private static Class<?> getReflectionFactoryClass() {
        try {
            return Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjenesisException(classNotFoundException);
        }
    }

    private static Object createReflectionFactory(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getReflectionFactory", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjenesisException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjenesisException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjenesisException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjenesisException(invocationTargetException);
        }
    }

    private static Method getNewConstructorForSerializationMethod(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjenesisException(noSuchMethodException);
        }
    }
}

