/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.basic.ClassDefinitionUtils;

public class ProxyingInstantiator<T>
implements ObjectInstantiator<T> {
    private static final int INDEX_CLASS_THIS = 1;
    private static final int INDEX_CLASS_SUPERCLASS = 2;
    private static final int INDEX_UTF8_CONSTRUCTOR_NAME = 3;
    private static final int INDEX_UTF8_CONSTRUCTOR_DESC = 4;
    private static final int INDEX_UTF8_CODE_ATTRIBUTE = 5;
    private static final int INDEX_UTF8_CLASS = 7;
    private static final int INDEX_UTF8_SUPERCLASS = 8;
    private static int CONSTANT_POOL_COUNT = 9;
    private static final byte[] CODE = new byte[]{42, -79};
    private static final int CODE_ATTRIBUTE_LENGTH = 12 + CODE.length;
    private static final String SUFFIX = "$$$Objenesis";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "()V";
    private final Class<?> newType;

    public ProxyingInstantiator(Class<T> clazz) {
        byte[] byArray = ProxyingInstantiator.writeExtendingClass(clazz, SUFFIX);
        try {
            this.newType = ClassDefinitionUtils.defineClass(clazz.getName() + SUFFIX, byArray, clazz.getClassLoader());
        }
        catch (Exception exception) {
            throw new ObjenesisException(exception);
        }
    }

    @Override
    public T newInstance() {
        try {
            return (T)this.newType.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ObjenesisException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjenesisException(illegalAccessException);
        }
    }

    private static byte[] writeExtendingClass(Class<?> clazz, String string) {
        String string2 = ClassDefinitionUtils.classNameToInternalClassName(clazz.getName());
        String string3 = string2 + string;
        DataOutputStream dataOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        try {
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(ClassDefinitionUtils.MAGIC);
            dataOutputStream.write(ClassDefinitionUtils.VERSION);
            dataOutputStream.writeShort(CONSTANT_POOL_COUNT);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(7);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(8);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_NAME);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_DESC);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("Code");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("L" + string3 + ";");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeShort(33);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(5);
            dataOutputStream.writeInt(CODE_ATTRIBUTE_LENGTH);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(CODE.length);
            dataOutputStream.write(CODE);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw new ObjenesisException(iOException);
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new ObjenesisException(iOException);
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

