/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.ObjectInstantiator;

public class ObjectInputStreamInstantiator<T>
implements ObjectInstantiator<T> {
    private ObjectInputStream inputStream;

    public ObjectInputStreamInstantiator(Class<T> clazz) {
        if (Serializable.class.isAssignableFrom(clazz)) {
            try {
                this.inputStream = new ObjectInputStream(new MockStream(clazz));
            }
            catch (IOException iOException) {
                throw new Error("IOException: " + iOException.getMessage());
            }
        } else {
            throw new ObjenesisException(new NotSerializableException(clazz + " not serializable"));
        }
    }

    @Override
    public T newInstance() {
        try {
            return (T)this.inputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            throw new ObjenesisException(exception);
        }
    }

    private static class MockStream
    extends InputStream {
        private int pointer = 0;
        private byte[] data = HEADER;
        private int sequence = 0;
        private static final int[] NEXT = new int[]{1, 2, 2};
        private byte[][] buffers;
        private final byte[] FIRST_DATA;
        private static byte[] HEADER;
        private static byte[] REPEATING_DATA;

        private static void initialize() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeShort(-21267);
                dataOutputStream.writeShort(5);
                HEADER = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(115);
                dataOutputStream.writeByte(113);
                dataOutputStream.writeInt(0x7E0000);
                REPEATING_DATA = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new Error("IOException: " + iOException.getMessage());
            }
        }

        public MockStream(Class<?> clazz) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(115);
                dataOutputStream.writeByte(114);
                dataOutputStream.writeUTF(clazz.getName());
                dataOutputStream.writeLong(ObjectStreamClass.lookup(clazz).getSerialVersionUID());
                dataOutputStream.writeByte(2);
                dataOutputStream.writeShort(0);
                dataOutputStream.writeByte(120);
                dataOutputStream.writeByte(112);
            }
            catch (IOException iOException) {
                throw new Error("IOException: " + iOException.getMessage());
            }
            this.FIRST_DATA = byteArrayOutputStream.toByteArray();
            this.buffers = new byte[][]{HEADER, this.FIRST_DATA, REPEATING_DATA};
        }

        private void advanceBuffer() {
            this.pointer = 0;
            this.sequence = NEXT[this.sequence];
            this.data = this.buffers[this.sequence];
        }

        @Override
        public int read() throws IOException {
            byte by = this.data[this.pointer++];
            if (this.pointer >= this.data.length) {
                this.advanceBuffer();
            }
            return by;
        }

        @Override
        public int available() throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = this.data.length - this.pointer;
            for (n3 = n2; n4 <= n3; n3 -= n4) {
                System.arraycopy(this.data, this.pointer, byArray, n, n4);
                n += n4;
                this.advanceBuffer();
                n4 = this.data.length - this.pointer;
            }
            if (n3 > 0) {
                System.arraycopy(this.data, this.pointer, byArray, n, n3);
                this.pointer += n3;
            }
            return n2;
        }

        static {
            MockStream.initialize();
        }
    }
}

