/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.util.reflection.InstanceField;

public abstract class Fields {
    public static InstanceFields allDeclaredFieldsOf(Object object) {
        ArrayList<InstanceField> arrayList = new ArrayList<InstanceField>();
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            arrayList.addAll(Fields.instanceFieldsIn(object, clazz.getDeclaredFields()));
        }
        return new InstanceFields(object, arrayList);
    }

    public static InstanceFields declaredFieldsOf(Object object) {
        ArrayList<InstanceField> arrayList = new ArrayList<InstanceField>();
        arrayList.addAll(Fields.instanceFieldsIn(object, object.getClass().getDeclaredFields()));
        return new InstanceFields(object, arrayList);
    }

    private static List<InstanceField> instanceFieldsIn(Object object, Field[] fieldArray) {
        ArrayList<InstanceField> arrayList = new ArrayList<InstanceField>();
        for (Field field : fieldArray) {
            InstanceField instanceField = new InstanceField(field, object);
            arrayList.add(instanceField);
        }
        return arrayList;
    }

    public static ListUtil.Filter<InstanceField> annotatedBy(final Class<? extends Annotation> ... classArray) {
        return new ListUtil.Filter<InstanceField>(){

            @Override
            public boolean isOut(InstanceField instanceField) {
                Checks.checkNotNull(classArray, "Provide at least one annotation class");
                for (Class clazz : classArray) {
                    if (!instanceField.isAnnotatedBy(clazz)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static ListUtil.Filter<InstanceField> nullField() {
        return new ListUtil.Filter<InstanceField>(){

            @Override
            public boolean isOut(InstanceField instanceField) {
                return instanceField.isNull();
            }
        };
    }

    public static class InstanceFields {
        private final Object instance;
        private final List<InstanceField> instanceFields;

        public InstanceFields(Object object, List<InstanceField> list) {
            this.instance = object;
            this.instanceFields = list;
        }

        public InstanceFields filter(ListUtil.Filter<InstanceField> filter) {
            return new InstanceFields(this.instance, ListUtil.filter(this.instanceFields, filter));
        }

        public InstanceFields notNull() {
            return this.filter(Fields.nullField());
        }

        public List<InstanceField> instanceFields() {
            return new ArrayList<InstanceField>(this.instanceFields);
        }

        public List<Object> assignedValues() {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.instanceFields.size());
            for (InstanceField instanceField : this.instanceFields) {
                arrayList.add(instanceField.read());
            }
            return arrayList;
        }

        public List<String> names() {
            ArrayList<String> arrayList = new ArrayList<String>(this.instanceFields.size());
            for (InstanceField instanceField : this.instanceFields) {
                arrayList.add(instanceField.name());
            }
            return arrayList;
        }
    }
}

