/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;

public class EqualsWithDelta
extends ArgumentMatcher<Number>
implements Serializable {
    private static final long serialVersionUID = 5066980489920383664L;
    private final Number wanted;
    private final Number delta;

    public EqualsWithDelta(Number number, Number number2) {
        this.wanted = number;
        this.delta = number2;
    }

    @Override
    public boolean matches(Object object) {
        Number number = (Number)object;
        if (this.wanted == null ^ object == null) {
            return false;
        }
        if (this.wanted == object) {
            return true;
        }
        return this.wanted.doubleValue() - this.delta.doubleValue() <= number.doubleValue() && number.doubleValue() <= this.wanted.doubleValue() + this.delta.doubleValue();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("eq(" + this.wanted + ", " + this.delta + ")");
    }
}

