/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.instance;

import java.lang.reflect.Constructor;
import org.mockito.internal.creation.instance.InstantationException;
import org.mockito.internal.creation.instance.Instantiator;

public class ConstructorInstantiator
implements Instantiator {
    private final Object outerClassInstance;

    public ConstructorInstantiator(Object object) {
        this.outerClassInstance = object;
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        if (this.outerClassInstance == null) {
            return ConstructorInstantiator.noArgConstructor(clazz);
        }
        return ConstructorInstantiator.withParams(clazz, this.outerClassInstance);
    }

    private static <T> T withParams(Class<T> clazz, Object ... objectArray) {
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (!ConstructorInstantiator.paramsMatch(classArray, objectArray)) continue;
                return (T)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw ConstructorInstantiator.paramsException(clazz, exception);
        }
        throw ConstructorInstantiator.paramsException(clazz, null);
    }

    private static <T> InstantationException paramsException(Class<T> clazz, Exception exception) {
        return new InstantationException("Unable to create instance of '" + clazz.getSimpleName() + "'.\nPlease ensure that the outer instance has correct type and that the target class has 0-arg constructor.", exception);
    }

    private static boolean paramsMatch(Class<?>[] classArray, Object[] objectArray) {
        if (objectArray.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    private static <T> T noArgConstructor(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new InstantationException("Unable to create instance of '" + clazz.getSimpleName() + "'.\nPlease ensure it has 0-arg constructor which invokes cleanly.", throwable);
        }
    }
}

